/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import io.opentelemetry.sdk.metrics.internal.view.ViewRegistryBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class SdkMeterProviderBuilder {
    private static final ExemplarFilter DEFAULT_EXEMPLAR_FILTER = ExemplarFilter.sampleWithTraces();
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final ViewRegistryBuilder viewRegistryBuilder = ViewRegistry.builder();
    private final List<RegisteredReader> registeredReaders = new ArrayList<RegisteredReader>();
    private ExemplarFilter exemplarFilter = DEFAULT_EXEMPLAR_FILTER;

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.viewRegistryBuilder.addView(selector, view, view.getAttributesProcessor(), SourceInfo.fromCurrentStack());
        return this;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReader reader) {
        this.registeredReaders.add(RegisteredReader.create(reader));
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.registeredReaders, this.clock, this.resource, this.viewRegistryBuilder.build(), this.exemplarFilter);
    }
}

