/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v101.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v101.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v101.audits.model.SourceCodeLocation;
import org.openqa.selenium.json.JsonInput;

public class DeprecationIssueDetails {
    private final Optional<AffectedFrame> affectedFrame;
    private final SourceCodeLocation sourceCodeLocation;
    private final Optional<String> message;
    private final String deprecationType;

    public DeprecationIssueDetails(Optional<AffectedFrame> affectedFrame, SourceCodeLocation sourceCodeLocation, Optional<String> message, String deprecationType) {
        this.affectedFrame = affectedFrame;
        this.sourceCodeLocation = Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.message = message;
        this.deprecationType = Objects.requireNonNull(deprecationType, "deprecationType is required");
    }

    public Optional<AffectedFrame> getAffectedFrame() {
        return this.affectedFrame;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Deprecated
    public Optional<String> getMessage() {
        return this.message;
    }

    @Deprecated
    public String getDeprecationType() {
        return this.deprecationType;
    }

    private static DeprecationIssueDetails fromJson(JsonInput input) {
        Optional<AffectedFrame> affectedFrame = Optional.empty();
        SourceCodeLocation sourceCodeLocation = null;
        Optional<String> message = Optional.empty();
        String deprecationType = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "affectedFrame": {
                    affectedFrame = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block12;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = (SourceCodeLocation)input.read(SourceCodeLocation.class);
                    continue block12;
                }
                case "message": {
                    message = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "deprecationType": {
                    deprecationType = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeprecationIssueDetails(affectedFrame, sourceCodeLocation, message, deprecationType);
    }
}

