/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v102.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v102.css.model.CSSContainerQuery;
import org.openqa.selenium.devtools.v102.css.model.CSSLayer;
import org.openqa.selenium.devtools.v102.css.model.CSSMedia;
import org.openqa.selenium.devtools.v102.css.model.CSSStyle;
import org.openqa.selenium.devtools.v102.css.model.CSSSupports;
import org.openqa.selenium.devtools.v102.css.model.SelectorList;
import org.openqa.selenium.devtools.v102.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v102.css.model.StyleSheetOrigin;
import org.openqa.selenium.json.JsonInput;

public class CSSRule {
    private final Optional<StyleSheetId> styleSheetId;
    private final SelectorList selectorList;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;
    private final Optional<List<CSSMedia>> media;
    private final Optional<List<CSSContainerQuery>> containerQueries;
    private final Optional<List<CSSSupports>> supports;
    private final Optional<List<CSSLayer>> layers;

    public CSSRule(Optional<StyleSheetId> styleSheetId, SelectorList selectorList, StyleSheetOrigin origin, CSSStyle style, Optional<List<CSSMedia>> media, Optional<List<CSSContainerQuery>> containerQueries, Optional<List<CSSSupports>> supports, Optional<List<CSSLayer>> layers) {
        this.styleSheetId = styleSheetId;
        this.selectorList = Objects.requireNonNull(selectorList, "selectorList is required");
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
        this.media = media;
        this.containerQueries = containerQueries;
        this.supports = supports;
        this.layers = layers;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    public Optional<List<CSSMedia>> getMedia() {
        return this.media;
    }

    @Beta
    public Optional<List<CSSContainerQuery>> getContainerQueries() {
        return this.containerQueries;
    }

    @Beta
    public Optional<List<CSSSupports>> getSupports() {
        return this.supports;
    }

    @Beta
    public Optional<List<CSSLayer>> getLayers() {
        return this.layers;
    }

    private static CSSRule fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        SelectorList selectorList = null;
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        Optional<List<CSSMedia>> media = Optional.empty();
        Optional<List<CSSContainerQuery>> containerQueries = Optional.empty();
        Optional<List<CSSSupports>> supports = Optional.empty();
        Optional<List<CSSLayer>> layers = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block20;
                }
                case "selectorList": {
                    selectorList = (SelectorList)input.read(SelectorList.class);
                    continue block20;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block20;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block20;
                }
                case "media": {
                    media = Optional.ofNullable((List)input.read(new TypeToken<List<CSSMedia>>(){}.getType()));
                    continue block20;
                }
                case "containerQueries": {
                    containerQueries = Optional.ofNullable((List)input.read(new TypeToken<List<CSSContainerQuery>>(){}.getType()));
                    continue block20;
                }
                case "supports": {
                    supports = Optional.ofNullable((List)input.read(new TypeToken<List<CSSSupports>>(){}.getType()));
                    continue block20;
                }
                case "layers": {
                    layers = Optional.ofNullable((List)input.read(new TypeToken<List<CSSLayer>>(){}.getType()));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSRule(styleSheetId, selectorList, origin, style, media, containerQueries, supports, layers);
    }
}

