/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v102.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v102.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v102.audits.model.DeprecationIssueType;
import org.openqa.selenium.devtools.v102.audits.model.SourceCodeLocation;
import org.openqa.selenium.json.JsonInput;

public class DeprecationIssueDetails {
    private final Optional<AffectedFrame> affectedFrame;
    private final SourceCodeLocation sourceCodeLocation;
    private final Optional<String> message;
    private final Optional<String> deprecationType;
    private final DeprecationIssueType type;

    public DeprecationIssueDetails(Optional<AffectedFrame> affectedFrame, SourceCodeLocation sourceCodeLocation, Optional<String> message, Optional<String> deprecationType, DeprecationIssueType type) {
        this.affectedFrame = affectedFrame;
        this.sourceCodeLocation = Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.message = message;
        this.deprecationType = deprecationType;
        this.type = Objects.requireNonNull(type, "type is required");
    }

    public Optional<AffectedFrame> getAffectedFrame() {
        return this.affectedFrame;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Deprecated
    public Optional<String> getMessage() {
        return this.message;
    }

    @Deprecated
    public Optional<String> getDeprecationType() {
        return this.deprecationType;
    }

    public DeprecationIssueType getType() {
        return this.type;
    }

    private static DeprecationIssueDetails fromJson(JsonInput input) {
        Optional<AffectedFrame> affectedFrame = Optional.empty();
        SourceCodeLocation sourceCodeLocation = null;
        Optional<String> message = Optional.empty();
        Optional<String> deprecationType = Optional.empty();
        DeprecationIssueType type = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "affectedFrame": {
                    affectedFrame = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block14;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = (SourceCodeLocation)input.read(SourceCodeLocation.class);
                    continue block14;
                }
                case "message": {
                    message = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "deprecationType": {
                    deprecationType = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "type": {
                    type = (DeprecationIssueType)((Object)input.read(DeprecationIssueType.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeprecationIssueDetails(affectedFrame, sourceCodeLocation, message, deprecationType, type);
    }
}

