/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class browsermatorDesktopManager
extends DefaultDesktopManager {
    HashMap<JInternalFrame, String> FrameHashMap;
    InternalFrameAdapter ifl = new InternalFrameAdapter(){

        @Override
        public void internalFrameIconified(InternalFrameEvent e) {
            JInternalFrame iframe = e.getInternalFrame();
            JInternalFrame.JDesktopIcon icon = iframe.getDesktopIcon();
        }
    };

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        super.deiconifyFrame(f);
        super.activateFrame(f);
        try {
            f.setSelected(true);
        }
        catch (Exception e) {
            System.out.println("Exception when unminizing/selecting frame: " + e.toString());
        }
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        int minWidth = this.computeMinFrameWidth();
        int minHeight = this.computeMinFrameHeight();
        int desiredWidth = this.computeDesktopIconWidth(minWidth, f.getTitle());
        int desiredHeight = this.computeDesktopIconHeight(minHeight, f.getTitle());
        super.iconifyFrame(f);
        JInternalFrame.JDesktopIcon icon = f.getDesktopIcon();
        icon.setSize(desiredWidth, desiredHeight);
        super.activateFrame(f);
        try {
            f.setSelected(false);
        }
        catch (Exception e) {
            System.out.println("Exception when minizing/unselecting frame: " + e.toString());
        }
        super.deactivateFrame(f);
    }

    private int computeMinFrameWidth() {
        JInternalFrame f = new JInternalFrame("", true, true, true, true);
        f.pack();
        Rectangle r = f.getBounds();
        f.dispose();
        return r.width;
    }

    private int computeMinFrameHeight() {
        JInternalFrame f = new JInternalFrame("", true, true, true, true);
        f.pack();
        Rectangle r = f.getBounds();
        f.dispose();
        return r.height;
    }

    private int computeDesktopIconHeight(int minHeight, String title) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Font font = UIManager.getFont("InternalFrame.titleFont");
        int maxTitleHeight = 0;
        Rectangle2D r = new TextLayout(title, font, frc).getBounds();
        int textHeight = (int)r.getHeight();
        if (textHeight > maxTitleHeight) {
            maxTitleHeight = textHeight;
        }
        int totalHeight = minHeight + maxTitleHeight;
        return totalHeight;
    }

    private int computeDesktopIconWidth(int minWidth, String title) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        Font font = UIManager.getFont("InternalFrame.titleFont");
        int maxTitleWidth = 0;
        Rectangle2D r = new TextLayout(title, font, frc).getBounds();
        int textWidth = (int)r.getWidth();
        if (textWidth > maxTitleWidth) {
            maxTitleWidth = textWidth;
        }
        int totalWidth = minWidth + maxTitleWidth;
        return totalWidth;
    }
}

