/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import browsermator4.com.BMAction;
import browsermator4.com.BrowserMatorConfig;
import browsermator4.com.Procedure;
import browsermator4.com.ProcedureView;
import browsermator4.com.Protector;
import browsermator4.com.UserSingleInputFrame;
import browsermator4.com.UserSingleInputPanel;
import com.opencsv.CSVReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeleniumTestToolData {
    transient CSVReader CSVFileReader;
    ArrayList<Procedure> BugArray = new ArrayList();
    ArrayList<String> AllFieldValues;
    ArrayList<String> Visitted_URL_List;
    Thread ActionThread;
    Boolean AllTestsPassed;
    Boolean ShowReport;
    Boolean EmailReport;
    Boolean EmailReportFail;
    Boolean ExitAfter;
    Boolean PromptToClose;
    Boolean changes;
    String TargetBrowser;
    Boolean MultiSession;
    Boolean TemplateOrNew = false;
    String OSType;
    int WaitTime;
    int Sessions;
    boolean hasStoredVar;
    boolean hasStoredArray;
    boolean IncludeScreenshots;
    Map<String, String> VarHashMap = new HashMap<String, String>();
    Map<String, List<String>> VarLists = new HashMap<String, List<String>>();
    boolean cancelled;
    boolean testRunning;
    String short_filename;
    int Timeout;
    LocalDateTime TimeOfRun;
    boolean UniqueList;
    String UniqueOption;
    String URL;
    String filename;
    String EmailPassword;
    String EmailTo;
    String EmailFrom;
    String EmailSubject;
    String SMTPHostName;
    String EmailLoginName;
    Boolean silentMode;
    String waitForLoad;
    String promptBehavior;
    public final String UNIQUE_LOG_DIR;
    Map<String, List<String[]>> DataFileHashMap = new HashMap<String, List<String[]>>();
    String BrowsermatorAppFolder;
    boolean hasSentStoredVars = false;
    int EcTimeout;
    BrowserMatorConfig appConfig = new BrowserMatorConfig();

    public SeleniumTestToolData(ArrayList<Procedure> BugArray) {
        this.BrowsermatorAppFolder = System.getProperty("user.home") + File.separator + "BrowsermatorAppFolder" + File.separator;
        this.UNIQUE_LOG_DIR = this.BrowsermatorAppFolder + "BrowsermatorUniqueLogFolder" + File.separator;
        this.BugArray = BugArray;
        this.UniqueOption = "file";
        this.UniqueList = false;
        this.MultiSession = false;
        this.cancelled = false;
        this.hasStoredVar = false;
        this.hasStoredArray = false;
        this.VarHashMap = new HashMap<String, String>();
        this.TargetBrowser = "Chrome";
        this.waitForLoad = "Yes";
        this.promptBehavior = "Dismiss";
        this.OSType = "Windows32";
        this.Sessions = 1;
        this.changes = false;
        this.PromptToClose = false;
        this.ShowReport = false;
        this.short_filename = this.filename = "";
        this.URL = "";
        this.IncludeScreenshots = false;
        this.testRunning = false;
        this.AllFieldValues = new ArrayList();
        this.Visitted_URL_List = new ArrayList();
        this.EmailReport = false;
        this.EmailReportFail = false;
        this.ExitAfter = false;
        this.AllTestsPassed = false;
        this.EmailPassword = "";
        this.EmailTo = "";
        this.EmailFrom = "";
        this.EmailSubject = "";
        this.SMTPHostName = "";
        this.EmailLoginName = "";
        this.silentMode = false;
        this.EcTimeout = 10;
        try {
            this.loadGlobalEmailSettings();
        }
        catch (Exception e) {
            System.out.println("Exception on loading email settings: " + e);
        }
    }

    public void setEcTimeout(int _timeout) {
        this.EcTimeout = _timeout;
    }

    public int getEcTimeout() {
        return this.EcTimeout;
    }

    public void setSilentMode(Boolean modeset) {
        this.silentMode = modeset;
    }

    public void setHasStoredVar(boolean hasit) {
        this.hasStoredVar = hasit;
    }

    public void setHasStoredArray(boolean hasit) {
        this.hasStoredArray = hasit;
    }

    public void initVarHashMap() {
        this.VarHashMap = new HashMap<String, String>();
    }

    public void setIsTemplateOrNew(boolean is_template_or_new) {
        this.TemplateOrNew = is_template_or_new;
    }

    public boolean getIsTemplateOrNew() {
        return this.TemplateOrNew;
    }

    public void initVarLists() {
        this.VarLists = new HashMap<String, List<String>>();
        this.VarLists.put("MASTER", new ArrayList());
    }

    public Map<String, String> getVarHashMap() {
        return this.VarHashMap;
    }

    public Map<String, List<String>> getVarLists() {
        return this.VarLists;
    }

    public void DeleteBug(int BugIndex) {
        for (BMAction A : this.BugArray.get((int)(BugIndex - 1)).ActionsList) {
            if ("Store Link as Variable by XPATH".equals(A.Type)) {
                this.VarHashMap.remove(A.Variable2);
            }
            if (!"Store Links as URL List by XPATH".equals(A.Type)) continue;
            this.VarLists.remove(A.Variable2);
        }
        this.BugArray.remove(BugIndex - 1);
        this.ResetBugIndexes();
        this.changes = true;
    }

    public void ResetBugIndexes() {
        int newindex = 1;
        for (Procedure proc : this.BugArray) {
            proc.setIndex(newindex);
            ++newindex;
        }
    }

    public void DeleteAction(Procedure thisBug, int atIndex) {
        thisBug.ActionsList.remove(atIndex);
        for (int BugIndex = 0; BugIndex < thisBug.ActionsList.size(); ++BugIndex) {
            if (BugIndex < atIndex) continue;
            --thisBug.ActionsList.get((int)BugIndex).index;
        }
        this.changes = true;
    }

    public void clearEmailSettings() {
        this.setSMTPHostname("");
        this.setEmailLoginName("");
        this.setEmailPassword("");
        this.setEmailTo("");
        this.setEmailFrom("");
        this.setSubject("");
    }

    public void MoveAction(Procedure thisBug, int toMoveIndex, int Direction) {
        int SwapIndex = toMoveIndex + Direction;
        if (Direction == 1 && toMoveIndex < thisBug.ActionsList.size() - 1) {
            Collections.swap(thisBug.ActionsList, toMoveIndex, SwapIndex);
            thisBug.ActionsList.get(toMoveIndex).setActionIndex(toMoveIndex);
            thisBug.ActionsList.get(SwapIndex).setActionIndex(SwapIndex);
        }
        if (Direction == -1 && toMoveIndex != 0) {
            Collections.swap(thisBug.ActionsList, toMoveIndex, SwapIndex);
            thisBug.ActionsList.get(toMoveIndex).setActionIndex(toMoveIndex);
            thisBug.ActionsList.get(SwapIndex).setActionIndex(SwapIndex);
        }
        this.changes = true;
    }

    public List<String[]> CreateArrayListFromFile(String DataFile) {
        List<Object> return_array = new ArrayList<String[]>();
        File checkPath = new File(DataFile);
        if (checkPath.exists()) {
            try {
                this.CSVFileReader = new CSVReader((Reader)new FileReader(DataFile), ',', '\"', '\u0000');
                return_array = this.CSVFileReader.readAll();
            }
            catch (Exception ex) {
                System.out.println("Exception reading csv file: 122 procedure" + ex.toString());
            }
        }
        return return_array;
    }

    public void addDataFileToDataFileHashMap(String path_to_file) {
        List<Object> DataSet = new ArrayList();
        DataSet = this.CreateArrayListFromFile(path_to_file);
        this.DataFileHashMap.put(path_to_file, DataSet);
    }

    public List<String[]> getDataSetByFileName(String filename) {
        List<Object> DataOut = new ArrayList();
        if (this.DataFileHashMap.containsKey(filename)) {
            DataOut = this.DataFileHashMap.get(filename);
        } else {
            File checkfile = new File(filename);
            if (checkfile.exists()) {
                this.addDataFileToDataFileHashMap(filename);
                DataOut = this.DataFileHashMap.get(filename);
            }
        }
        return DataOut;
    }

    public void addSelectedVariableName(String varname) {
        this.VarHashMap.put(varname, "");
    }

    public void updateSelectedVariableName(String oldname, String newname) {
        if (this.VarHashMap.containsKey(newname)) {
            this.VarHashMap.put(newname, "");
            this.VarHashMap.put(oldname, "");
        } else {
            this.VarHashMap.remove(oldname);
            this.VarHashMap.put(newname, "");
        }
    }

    public String GetStoredVariableValue(String fieldname) {
        String ret_val = "";
        if (this.VarHashMap.containsKey(fieldname)) {
            ret_val = this.VarHashMap.get(fieldname);
        }
        return ret_val;
    }

    public void SetSentStoredVariableName(String varname) {
        this.VarHashMap.put(varname, "");
        this.hasSentStoredVars = true;
    }

    public void SetStoredVariableName(String varname) {
        this.VarHashMap.put(varname, "");
    }

    public void SetStoredVariableValue(String varname, String varval) {
        if (this.VarHashMap.containsKey(varname)) {
            this.VarHashMap.put(varname, varval);
        }
    }

    public void setAllFieldValues(ArrayList<String> allfieldvalues) {
        this.AllFieldValues = allfieldvalues;
    }

    public final void loadGlobalEmailSettings() throws IOException {
        String smtp_hostname = this.appConfig.getKeyValue("smtp_hostname");
        String login_name = this.appConfig.getKeyValue("email_login_name");
        String password = this.appConfig.getKeyValue("email_login_password");
        String to = this.appConfig.getKeyValue("email_to");
        String from = this.appConfig.getKeyValue("email_from");
        String subject = this.appConfig.getKeyValue("email_subject");
        this.setSMTPHostname(smtp_hostname);
        this.setEmailLoginName(login_name);
        if (password != null) {
            try {
                String machineID = this.appConfig.ReturnMachineSerialNumber();
                password = Protector.decryptLocal(password, machineID);
            }
            catch (Exception ex) {
                System.out.println("Exception getting email password: " + ex.toString());
            }
        }
        this.setEmailPassword(password);
        this.setEmailTo(to);
        this.setEmailFrom(from);
        this.setSubject(subject);
    }

    public void ClearEmailSettings() {
        this.setSMTPHostname("");
        this.setEmailLoginName("");
        this.setEmailPassword("");
        this.setEmailTo("");
        this.setEmailFrom("");
        this.setSubject("");
    }

    public void setEmailPassword(String password) {
        this.EmailPassword = password;
    }

    public void setEmailTo(String to) {
        this.EmailTo = to;
    }

    public void RefreshData() {
        for (Procedure proc : this.BugArray) {
            if (!"Dataloop".equals(proc.Type)) continue;
            if ("file".equals(proc.DataLoopSource)) {
                proc.RefreshFileData();
                continue;
            }
            proc.RefreshURLListData();
        }
    }

    public String getWaitForLoad() {
        return this.waitForLoad;
    }

    public String getPromptBehavior() {
        return this.promptBehavior;
    }

    public String getTargetBrowser() {
        return this.TargetBrowser;
    }

    public void setEmailFrom(String from) {
        this.EmailFrom = from;
    }

    public void setSubject(String subject) {
        this.EmailSubject = subject;
    }

    public void setSMTPHostname(String smtp_hostname) {
        this.SMTPHostName = smtp_hostname;
    }

    public void setEmailLoginName(String login_name) {
        this.EmailLoginName = login_name;
    }

    public int getWaitTime() {
        return this.WaitTime;
    }

    public int getTimeout() {
        return this.Timeout;
    }

    public int getSessions() {
        return this.Sessions;
    }

    public String getSMTPHostname() {
        return this.SMTPHostName;
    }

    public String getEmailFrom() {
        return this.EmailFrom;
    }

    public String getEmailLoginName() {
        return this.EmailLoginName;
    }

    public String getEmailPassword() {
        return this.EmailPassword;
    }

    public String getEmailTo() {
        return this.EmailTo;
    }

    public String getEmailSubject() {
        return this.EmailSubject;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getShortFilename() {
        return this.short_filename;
    }

    public void setFilenames(String filename) {
        Path thisP = Paths.get(filename, new String[0]);
        String shortname = thisP.getFileName().toString();
        if (shortname.length() > 1) {
            int end_of_name = shortname.indexOf(".browsermation");
            if (end_of_name < 1) {
                end_of_name = shortname.length();
            }
            this.short_filename = shortname.substring(0, end_of_name);
        } else {
            this.short_filename = shortname;
        }
        this.filename = filename;
    }

    public boolean getEmailReportFail() {
        return this.EmailReportFail;
    }

    public boolean getExitAfter() {
        return this.ExitAfter;
    }

    public void setPromptToClose(boolean closeit) {
        this.PromptToClose = closeit;
    }

    public boolean getPromptToClose() {
        return this.PromptToClose;
    }

    public boolean getShowReport() {
        return this.ShowReport;
    }

    public boolean getIncludeScreenshots() {
        return this.IncludeScreenshots;
    }

    public boolean getUniqueList() {
        return this.UniqueList;
    }

    public boolean getEmailReport() {
        return this.EmailReport;
    }

    public void setShowReport(Boolean showreport) {
        this.ShowReport = showreport;
        if (!this.ShowReport.booleanValue()) {
            this.IncludeScreenshots = false;
        } else {
            this.EmailReportFail = false;
            this.EmailReport = false;
            this.ExitAfter = false;
        }
    }

    public void setExitAfter(Boolean exitafter) {
        this.ExitAfter = exitafter;
        if (this.ExitAfter.booleanValue()) {
            this.ShowReport = false;
        }
    }

    public String getUniqueFileOption() {
        return this.UniqueOption;
    }

    public void setUniqueFileOption(String option) {
        if (option.equals("file")) {
            this.UniqueOption = option;
        }
        if (option.equals("global")) {
            this.UniqueOption = option;
        }
    }

    public void setIncludeScreenshots(Boolean includescreenshots) {
        this.IncludeScreenshots = includescreenshots;
    }

    public void setEmailReport(Boolean emailreport) {
        this.EmailReport = emailreport;
        if (emailreport.booleanValue()) {
            this.IncludeScreenshots = false;
            this.ShowReport = false;
            this.IncludeScreenshots = false;
        }
    }

    public void setEmailReportFail(Boolean emailreportfail) {
        this.EmailReportFail = emailreportfail;
        if (emailreportfail.booleanValue()) {
            this.IncludeScreenshots = false;
            this.ShowReport = false;
            this.EmailReport = false;
        } else {
            this.EmailReportFail = false;
        }
    }

    public void setWaitForLoad(String in_waitForLoad) {
        this.waitForLoad = in_waitForLoad;
    }

    public void setPromptBehavior(String in_PromptBehavior) {
        this.promptBehavior = in_PromptBehavior;
    }

    public void setTargetBrowser(String targetbrowser) {
        if (!this.silentMode.booleanValue()) {
            if ("Firefox-Marionette".equals(targetbrowser)) {
                targetbrowser = "Firefox";
            }
            this.TargetBrowser = targetbrowser;
        } else {
            for (Procedure thisProc : this.BugArray) {
                for (BMAction thisAct : thisProc.ActionsList) {
                    if (!thisAct.Type.equals("Switch Driver")) continue;
                    thisAct.Variable1 = targetbrowser;
                }
            }
        }
    }

    public void AddDataLoopProc(Procedure newdataloop) {
        this.BugArray.add(newdataloop);
        int thissize = this.BugArray.size();
        this.BugArray.get(thissize - 1).setIndex(thissize);
    }

    public void AddDataLoopProc(Procedure newdataloop, int atindex) {
        this.BugArray.add(--atindex, newdataloop);
        this.ResetBugIndexes();
    }

    public void AddNewBug() {
        Procedure newbug = new Procedure();
        newbug.setType("Procedure");
        this.BugArray.add(newbug);
        int thissize = this.BugArray.size();
        this.BugArray.get(thissize - 1).setIndex(thissize);
    }

    public void AddNewBug(int atindex) {
        Procedure newbug = new Procedure();
        newbug.setType("Procedure");
        this.BugArray.add(--atindex, newbug);
        this.ResetBugIndexes();
    }

    public void AddNewDataLoopURLList(String in_listname) {
        Procedure newdataloop = new Procedure();
        newdataloop.setType("Dataloop");
        newdataloop.setDataLoopSource("urllist");
        ArrayList<String> blanklist = new ArrayList<String>();
        newdataloop.setURLListData(blanklist, in_listname);
        if (!"".equals(in_listname)) {
            this.VarLists.put(in_listname, blanklist);
        }
        this.AddDataLoopProc(newdataloop);
    }

    public void AddNewDataLoopURLList(String in_listname, int at_index) {
        Procedure newdataloop = new Procedure();
        newdataloop.setType("Dataloop");
        newdataloop.setDataLoopSource("urllist");
        ArrayList<String> blanklist = new ArrayList<String>();
        newdataloop.setURLListData(blanklist, in_listname);
        if (!"".equals(in_listname)) {
            this.VarLists.put(in_listname, blanklist);
        }
        this.AddDataLoopProc(newdataloop, at_index);
    }

    public void AddNewDataLoopFile(File CSVFile) {
        Procedure newdataloop = new Procedure();
        newdataloop.setType("Dataloop");
        newdataloop.setDataLoopSource("file");
        if (CSVFile.exists()) {
            try {
                newdataloop.setDataFile(CSVFile.getCanonicalPath());
            }
            catch (IOException ex) {
                System.out.println(ex.toString());
            }
        } else {
            newdataloop.setDataFile("placeholder");
        }
        this.AddDataLoopProc(newdataloop);
    }

    public void AddNewDataLoopFile(File CSVFile, int at_index) {
        Procedure newdataloop = new Procedure();
        newdataloop.setType("Dataloop");
        newdataloop.setDataLoopSource("file");
        if (CSVFile.exists()) {
            try {
                newdataloop.setDataFile(CSVFile.getCanonicalPath());
            }
            catch (IOException ex) {
                System.out.println(ex.toString());
            }
        } else {
            newdataloop.setDataFile("");
        }
        this.AddDataLoopProc(newdataloop, at_index);
    }

    public String getOSType() {
        return this.OSType;
    }

    public void AddNewDataLoop() {
        Procedure newdataloop = new Procedure();
        newdataloop.setType("Dataloop");
        newdataloop.setDataLoopSource("none");
        this.AddDataLoopProc(newdataloop);
    }

    public void AddNewDataLoop(int atindex) {
        Procedure newdataloop = new Procedure();
        newdataloop.setType("Dataloop");
        newdataloop.setDataLoopSource("none");
        this.AddDataLoopProc(newdataloop, atindex);
    }

    public void RefreshActionIndexes(ArrayList<BMAction> actionlist) {
        for (int x = 0; x < actionlist.size(); ++x) {
            actionlist.get((int)x).index = x;
        }
    }

    public void AddActionToArray(BMAction action, Procedure newbug, ProcedureView newbugview) {
        String bugdashactionindex;
        String stringbugindex;
        String stringactionindex;
        int at_index = newbugview.getJComboBoxAddAtPosition();
        if (at_index > 0) {
            --at_index;
        }
        newbug.ActionsList.add(at_index, action);
        action.index = at_index;
        this.RefreshActionIndexes(newbug.ActionsList);
        if ("Store Links as URL List by XPATH".equals(action.Type)) {
            stringactionindex = Integer.toString(action.index + 1);
            stringbugindex = Integer.toString(newbug.index);
            bugdashactionindex = stringbugindex + "-" + stringactionindex;
            this.addSelectedArrayName(bugdashactionindex);
        }
        if ("Store Link as Variable by XPATH".equals(action.Type)) {
            stringactionindex = Integer.toString(action.index + 1);
            stringbugindex = Integer.toString(newbug.index);
            bugdashactionindex = stringbugindex + "-" + stringactionindex;
            this.addSelectedVariableName(bugdashactionindex);
        }
    }

    public void AddActionToArray(BMAction action, Procedure newbug) {
        String bugdashactionindex;
        String stringbugindex;
        String stringactionindex;
        newbug.ActionsList.add(action);
        action.index = newbug.ActionsList.size() - 1;
        if ("Store Links as URL List by XPATH".equals(action.Type)) {
            stringactionindex = Integer.toString(action.index + 1);
            stringbugindex = Integer.toString(newbug.index);
            bugdashactionindex = stringbugindex + "-" + stringactionindex;
            this.addSelectedArrayName(bugdashactionindex);
        }
        if ("Store Link as Variable by XPATH".equals(action.Type)) {
            stringactionindex = Integer.toString(action.index + 1);
            stringbugindex = Integer.toString(newbug.index);
            bugdashactionindex = stringbugindex + "-" + stringactionindex;
            this.addSelectedVariableName(bugdashactionindex);
        }
    }

    public void setSessions(int number_of_sessions) {
        this.Sessions = number_of_sessions;
    }

    public void setWaitTime(int timeout_seconds) {
        this.WaitTime = timeout_seconds;
    }

    public void addSelectedArrayName(String varname) {
        this.VarLists.put(varname, new ArrayList());
    }

    public void setOSType(String in_OSType) {
        switch (in_OSType) {
            case "Windows": {
                this.OSType = "Windows32";
                break;
            }
            case "Windows32": {
                this.OSType = "Windows32";
                break;
            }
            case "Windows64": {
                this.OSType = "Windows64";
                break;
            }
            case "Mac": {
                this.OSType = "Mac";
                break;
            }
            case "Linux-32": {
                this.OSType = "Linux-32";
                break;
            }
            case "Linux-64": {
                this.OSType = "Linux-64";
            }
        }
        this.OSType = this.OSType;
    }

    public List<String[]> RandomizeAndLimitFileList(List<String[]> data_REF, int limit, Boolean randval) {
        ArrayList<String[]> ret_val = new ArrayList<String[]>();
        ArrayList<String[]> data_in = new ArrayList<String[]>();
        for (String[] thisrow : data_REF) {
            data_in.add(thisrow);
        }
        if (data_in.size() > 0) {
            data_in.remove(0);
            if (randval.booleanValue()) {
                Collections.shuffle(data_in);
            }
            if (limit > 0) {
                int sizeofvarlist = data_in.size();
                data_in.subList(limit, sizeofvarlist).clear();
            }
            ret_val = data_in;
        }
        return ret_val;
    }

    public void setUniqueList(boolean unique) {
        this.UniqueList = unique;
        this.setUniqueFileOption(this.UniqueOption);
    }

    public List<String> RandomizeAndLimitURLList(String URLListName, int limit, Boolean randval) {
        ArrayList<String> currentlist = new ArrayList<String>();
        if (this.VarLists.containsKey(URLListName)) {
            currentlist = new ArrayList(this.VarLists.get(URLListName));
            if (currentlist.size() > 0) {
                if (this.UniqueList) {
                    String visited_list_file_path;
                    File file;
                    String file_name_to_check = "global";
                    if (this.UniqueOption.equals("file")) {
                        file_name_to_check = this.short_filename;
                    }
                    if ((file = new File(visited_list_file_path = this.UNIQUE_LOG_DIR + "browsermator_" + file_name_to_check + "_visited_url_log.xml")).exists()) {
                        Document doc = null;
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                            DocumentBuilder builder = factory.newDocumentBuilder();
                            String file_path = file.getAbsolutePath();
                            doc = builder.parse(file_path);
                            ArrayList<String> removeList = new ArrayList<String>();
                            for (String grabbedURL : currentlist) {
                                NodeList theseElements = doc.getElementsByTagName("URLsVisited");
                                NodeList SettingsNodes = theseElements.item(0).getChildNodes();
                                String URL_FROM_FILE = "";
                                Boolean hasValue = false;
                                for (int k = 0; k < SettingsNodes.getLength(); ++k) {
                                    URL_FROM_FILE = SettingsNodes.item(k).getTextContent();
                                    if (!URL_FROM_FILE.equals(grabbedURL)) continue;
                                    removeList.add(grabbedURL);
                                }
                            }
                            currentlist.removeAll(removeList);
                        }
                        catch (Exception ex) {
                            System.out.println("Exception with unique log: " + ex.toString());
                        }
                    }
                }
                if (randval.booleanValue()) {
                    Collections.shuffle(currentlist);
                }
                if (limit > 0) {
                    int sizeofvarlist = currentlist.size();
                    if (limit < sizeofvarlist) {
                        if (currentlist.size() >= limit) {
                            currentlist.subList(limit, sizeofvarlist).clear();
                        }
                        return currentlist;
                    }
                    return currentlist;
                }
                return currentlist;
            }
            return currentlist;
        }
        return currentlist;
    }

    public void AddURLToUniqueFileList(String thisURL) {
        this.Visitted_URL_List.add(thisURL);
    }

    public void ClearVisittedURLList() {
        this.Visitted_URL_List.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddURLListToUniqueFile(String fileOption) {
        String visited_list_file_path;
        File file;
        String file_name_to_write = "global";
        if (fileOption.equals("file")) {
            file_name_to_write = this.short_filename;
        }
        if ((file = new File(visited_list_file_path = this.UNIQUE_LOG_DIR + "browsermator_" + file_name_to_write + "_visited_url_log.xml")).exists()) {
            Document doc = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                String file_path = file.getAbsolutePath();
                doc = builder.parse(file_path);
                for (int x = 0; x < this.Visitted_URL_List.size(); ++x) {
                    String URL_To_Store = this.Visitted_URL_List.get(x);
                    NodeList theseElements = doc.getElementsByTagName("URLsVisited");
                    NodeList SettingsNodes = theseElements.item(0).getChildNodes();
                    String URL_FROM_FILE = "";
                    Boolean hasValue = false;
                    int node_match_index = 0;
                    for (int k = 0; k < SettingsNodes.getLength(); ++k) {
                        URL_FROM_FILE = SettingsNodes.item(k).getTextContent();
                        if (!URL_To_Store.equals(URL_FROM_FILE)) continue;
                        hasValue = true;
                        node_match_index = k;
                    }
                    if (hasValue.booleanValue() || "".equals(URL_To_Store)) continue;
                    Node root = doc.getFirstChild();
                    Element new_url = doc.createElement("URL");
                    new_url.setTextContent(URL_To_Store);
                    root.appendChild(new_url);
                }
                try {
                    XMLStreamWriter xmlfile = XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(file)));
                    try {
                        xmlfile.writeStartElement("URLsVisited");
                        NodeList urls_to_write = doc.getElementsByTagName("URL");
                        for (int k = 0; k < urls_to_write.getLength(); ++k) {
                            String thisSettingsNodeValue = urls_to_write.item(k).getTextContent();
                            xmlfile.writeStartElement("URL");
                            xmlfile.writeCharacters(thisSettingsNodeValue);
                            xmlfile.writeEndElement();
                        }
                        xmlfile.writeEndElement();
                    }
                    catch (Exception e) {
                        System.out.println("Write error:" + e.toString());
                    }
                    finally {
                        xmlfile.flush();
                        xmlfile.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("Write error:" + e.toString());
                }
            }
            catch (Exception e) {
                System.out.println("DocumentBuilder error(seleniumtesttoolline1039):" + e.toString());
                e.printStackTrace();
            }
        } else {
            try {
                XMLStreamWriter xmlfile = XMLOutputFactory.newInstance().createXMLStreamWriter(new BufferedOutputStream(new FileOutputStream(file)));
                try {
                    xmlfile.writeStartElement("URLsVisited");
                    for (String URL_To_Store : this.Visitted_URL_List) {
                        xmlfile.writeStartElement("URL");
                        xmlfile.writeCharacters(URL_To_Store);
                        xmlfile.writeEndElement();
                    }
                    xmlfile.writeEndElement();
                }
                catch (Exception e) {
                    System.out.println("Write error:" + e.toString());
                }
                finally {
                    xmlfile.flush();
                    xmlfile.close();
                }
            }
            catch (Exception e) {
                System.out.println("Write error:" + e.toString());
            }
        }
    }

    public void PromptForUserVarValues() {
        int counter = 0;
        UserSingleInputPanel[] UserSingleInputPanels = new UserSingleInputPanel[this.VarHashMap.size()];
        for (Map.Entry<String, String> entry : this.VarHashMap.entrySet()) {
            String key = entry.getKey();
            UserSingleInputPanel thisUserSingleInputPanel = new UserSingleInputPanel(key);
            thisUserSingleInputPanel.CreatePanel();
            UserSingleInputPanels[counter] = thisUserSingleInputPanel;
            ++counter;
        }
        UserSingleInputFrame newInputFrame = new UserSingleInputFrame(UserSingleInputPanels, this.VarHashMap);
        newInputFrame.InitializeFrame();
        newInputFrame.addLastPanelActionListener();
        while (newInputFrame.isVisible()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                System.out.println("pause exception: " + e.toString());
            }
        }
    }
}

