/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import browsermator4.com.ActionSettings;
import browsermator4.com.ActionView;
import browsermator4.com.BMAction;
import browsermator4.com.BrowserMatorConfig;
import browsermator4.com.ExtensionFileFilter;
import browsermator4.com.Procedure;
import browsermator4.com.ProcedureView;
import browsermator4.com.SeleniumTestToolData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SeleniumTestTool
extends JInternalFrame {
    JLabel jLabelInsertionPoint;
    JComboBox jComboBoxAtIndex;
    String filename;
    String short_filename;
    JPanel BugPanel;
    SeleniumTestToolData STAppData;
    ArrayList<ProcedureView> BugViewArray;
    String undoTempFile = "";
    private JTextField JTextFieldProgress;
    public JScrollPane MainScrollPane;
    private JButton jButtonBrowseForFireFoxExe;
    private JButton jButtonClearEmailSettings;
    private JButton jButtonDoStuff;
    private JButton jButtonFlattenFile;
    private JButton jButtonGutsView;
    private JButton jButtonLoadEmailSettings;
    private JButton jButtonNewBug;
    private JButton jButtonNewDataLoop;
    private JButton jButtonPlaceStoredVariable;
    private JCheckBox jCheckBoxEmailReport;
    private JCheckBox jCheckBoxEmailReportFail;
    private JCheckBox jCheckBoxEnableMultiSession;
    private JCheckBox jCheckBoxExitAfter;
    private JCheckBox jCheckBoxIncludeScreenshots;
    private JCheckBox jCheckBoxOSTypeLinux32;
    private JCheckBox jCheckBoxOSTypeLinux64;
    private JCheckBox jCheckBoxOSTypeMac;
    private JCheckBox jCheckBoxOSTypeWindows32;
    private JCheckBox jCheckBoxOSTypeWindows64;
    private JCheckBox jCheckBoxPromptToClose;
    private JCheckBox jCheckBoxShowReport;
    private JCheckBox jCheckBoxUniqueURLs;
    private JComboBox<String> jComboBoxStoredVariables;
    private JComboBox jComboBoxTargetBrowser;
    private JLabel jLabelSessions;
    private JLabel jLabelStoredVariables;
    private JLabel jLabelTasks;
    private JRadioButton jRadioButtonUniqueGlobal;
    private JRadioButton jRadioButtonUniquePerFile;
    private JSpinner jSpinnerEcTimeout;
    private JSpinner jSpinnerSessions;
    private JSpinner jSpinnerWaitTime;
    private JTextField jTextFieldEmailFrom;
    private JTextField jTextFieldEmailLoginName;
    private JPasswordField jTextFieldEmailPassword;
    private JTextField jTextFieldEmailTo;
    private JTextField jTextFieldSMTPHostName;
    private JTextField jTextFieldSubject;
    JButton jButtonPause;
    JButton jButtonContinue;
    JButton jButtonCancel;
    JButton jButtonClearUniqueList;
    JPanel SouthButtonPanel;
    JLabel jLabelWaitForLoad;
    JComboBox jComboBoxWaitForLoad;
    JLabel jLabelPromptBehavior;
    JComboBox jComboBoxPromptBehavior;
    public final String USERDIR = System.getProperty("user.home") + File.separator + "BrowsermatorAppFolder";
    public final String UNIQUE_LOG_DIR = this.USERDIR + File.separator + "BrowsermatorUniqueLogFolder" + File.separator;

    public SeleniumTestTool(SeleniumTestToolData in_STAppData) {
        this.STAppData = in_STAppData;
        this.BugPanel = new JPanel();
        this.filename = this.STAppData.filename;
        this.short_filename = this.STAppData.short_filename;
        this.BugViewArray = new ArrayList();
        this.setIconifiable(true);
        this.initializeComponents();
        this.JTextFieldProgress.setVisible(false);
        this.jLabelTasks.setVisible(false);
        this.SouthButtonPanel.setVisible(false);
        this.jButtonPlaceStoredVariable.setFocusable(false);
        this.jComboBoxStoredVariables.setFocusable(false);
    }

    public void addJButtonCancelActionListener(ActionListener listener) {
        this.jButtonCancel.addActionListener(listener);
    }

    public void addJButtonPauseActionListener(ActionListener listener) {
        this.jButtonPause.addActionListener(listener);
    }

    public void addJButtonContinueActionListener(ActionListener listener) {
        this.jButtonContinue.addActionListener(listener);
    }

    public void Pause() {
        this.jButtonPause.setEnabled(false);
        this.jButtonContinue.setEnabled(true);
        this.jButtonCancel.setEnabled(false);
    }

    public void Continue() {
        this.jButtonPause.setEnabled(true);
        this.jButtonContinue.setEnabled(false);
        this.jButtonCancel.setEnabled(true);
    }

    public void refreshjComboBoxAtIndex() {
        int bugindex = 0;
        this.jComboBoxAtIndex.removeAllItems();
        for (ProcedureView PV : this.BugViewArray) {
            this.jComboBoxAtIndex.addItem(++bugindex);
        }
        this.jComboBoxAtIndex.addItem(bugindex + 1);
        this.jComboBoxAtIndex.setSelectedItem(bugindex + 1);
    }

    public void refreshjComboBoxMoveToIndex() {
        int bugindex = 0;
        int bugviewarraysize = this.BugViewArray.size();
        if (bugviewarraysize > 0) {
            int[] indexes = new int[bugviewarraysize];
            for (int x = 0; x < bugviewarraysize; ++x) {
                indexes[x] = 0;
            }
            for (ProcedureView PV : this.BugViewArray) {
                indexes[bugindex] = PV.index;
                ++bugindex;
            }
            for (ProcedureView PV : this.BugViewArray) {
                PV.jComboBoxMoveToIndex.removeAllItems();
                PV.jComboBoxMoveToIndex.addItem("Move To Index:");
                for (int thisindex : indexes) {
                    if (PV.index == thisindex || thisindex == 0) continue;
                    PV.jComboBoxMoveToIndex.addItem(thisindex);
                }
            }
        }
    }

    public int getInsertionPoint() {
        int ret_val = 1;
        if (this.jComboBoxAtIndex.getItemCount() > 0) {
            ret_val = (Integer)this.jComboBoxAtIndex.getSelectedItem();
        }
        return ret_val;
    }

    public void initializeDisplay() {
        this.setjSpinnerEcTimeout(this.STAppData.getEcTimeout());
        this.setOSType(this.STAppData.getOSType());
        this.setTargetBrowserView(this.STAppData.getTargetBrowser());
        this.setWaitForLoadView(this.STAppData.getWaitForLoad());
        this.setPromptBehaviorView(this.STAppData.getPromptBehavior());
        this.setFilename(this.STAppData.getFilename());
        this.setShortFilename(this.STAppData.getShortFilename());
        this.setPromptToClose(this.STAppData.getPromptToClose());
        this.setUniqueFileOptionView(this.STAppData.getUniqueFileOption());
        this.setShowReportView(this.STAppData.getShowReport());
        this.setIncludeScreenShotView(this.STAppData.getIncludeScreenshots());
        this.setSMTPHostname(this.STAppData.getSMTPHostname());
        this.setEmailLoginName(this.STAppData.getEmailLoginName());
        this.setEmailPassword(this.STAppData.getEmailPassword());
        this.setEmailTo(this.STAppData.getEmailTo());
        this.setEmailFrom(this.STAppData.getEmailFrom());
        this.setSubject(this.STAppData.getEmailSubject());
        this.setExitAfterView(this.STAppData.getExitAfter());
        this.setjSpinnerWaitTime(this.STAppData.getWaitTime());
        this.setjSpinnerSessions(this.STAppData.getSessions());
        this.setUniqueListView(this.STAppData.getUniqueList());
        this.setEmailReportView(this.STAppData.getEmailReport());
        this.setEmailReportFailView(this.STAppData.getEmailReportFail());
        this.jButtonCancel.setEnabled(false);
        if (this.STAppData.getTargetBrowser().equals("Firefox") || this.STAppData.getTargetBrowser().equals("Chrome")) {
            this.setOSTypeActive(true);
        }
        this.populateSelectURLListPulldowns();
    }

    public void refreshStoredArrayPulldown(ProcedureView PV) {
        PV.JComboBoxStoredArrayLists.removeAllItems();
        PV.JComboBoxStoredArrayLists.addItem("Select a stored URL List");
        for (String keyname : this.STAppData.VarLists.keySet()) {
            PV.JComboBoxStoredArrayLists.addItem(keyname);
        }
    }

    public void updateSelectedVariableName(String oldname, String newname) {
        if (!this.STAppData.VarHashMap.containsKey(newname)) {
            this.STAppData.VarHashMap.put(newname, "");
        }
        if (this.STAppData.VarHashMap.containsKey(oldname)) {
            this.RemoveOldNameIfNotUsedVarHashMap(oldname);
        }
    }

    public void RemoveOldNameIfNotUsedVarHashMap(String _oldname) {
        boolean oldNameStillThere = false;
        for (Procedure PROC : this.STAppData.BugArray) {
            for (BMAction thisAct : PROC.ActionsList) {
                if (!thisAct.Variable2.equals(_oldname)) continue;
                oldNameStillThere = true;
            }
        }
        if (!oldNameStillThere) {
            this.STAppData.VarHashMap.remove(_oldname);
        }
    }

    public void RemoveOldNameIfNotUsedVarlist(String _oldname) {
        boolean oldNameStillThere = false;
        for (Procedure PROC : this.STAppData.BugArray) {
            for (BMAction thisAct : PROC.ActionsList) {
                if (!thisAct.Variable2.equals(_oldname)) continue;
                oldNameStillThere = true;
            }
        }
        if (!oldNameStillThere) {
            this.STAppData.VarLists.remove(_oldname);
        }
    }

    public void updateSelectedArrayName(String oldname, String newname) {
        if (this.STAppData.VarLists.containsKey(newname)) {
            int bugindex = 0;
            for (Procedure PROC : this.STAppData.BugArray) {
                if ("Dataloop".equals(PROC.Type) && PROC.URLListName.equals(oldname) && "urllist".equals(this.STAppData.BugArray.get((int)bugindex).DataLoopSource)) {
                    PROC.setURLListName(newname);
                    this.refreshStoredArrayPulldown(this.BugViewArray.get(bugindex));
                    this.STAppData.BugArray.get(bugindex).setURLListName(newname);
                    this.BugViewArray.get(bugindex).setURLListName(newname);
                }
                ++bugindex;
            }
        } else {
            this.STAppData.VarLists.put(newname, new ArrayList());
            int bugindex = 0;
            for (Procedure PROC : this.STAppData.BugArray) {
                if ("Dataloop".equals(PROC.Type) && PROC.URLListName.equals(oldname) && "urllist".equals(this.STAppData.BugArray.get((int)bugindex).DataLoopSource)) {
                    PROC.setURLListName(newname);
                    this.refreshStoredArrayPulldown(this.BugViewArray.get(bugindex));
                    this.STAppData.BugArray.get(bugindex).setURLListName(newname);
                    this.BugViewArray.get(bugindex).setURLListName(newname);
                    this.BugViewArray.get((int)bugindex).JComboBoxStoredArrayLists.removeItem(oldname);
                }
                ++bugindex;
            }
        }
        if (this.STAppData.VarLists.containsKey(oldname)) {
            this.RemoveOldNameIfNotUsedVarlist(oldname);
        }
    }

    public void updateStoredURLListIndexes(ProcedureView thisBugView) {
        int actionindex = 0;
        for (ActionView AV : thisBugView.ActionsViewList) {
            String newname;
            String oldname;
            String bugdashactionindex;
            String stringbugindex;
            String stringactionindex;
            if ("StoreLinksAsURLListByXPATH".equals(AV.ActionType)) {
                this.STAppData.setHasStoredArray(true);
                stringactionindex = Integer.toString(actionindex + 1);
                stringbugindex = Integer.toString(thisBugView.index);
                bugdashactionindex = stringbugindex + "-" + stringactionindex;
                oldname = AV.JTextFieldVariable2.getText();
                newname = bugdashactionindex;
                if (oldname.equals(newname)) {
                    this.STAppData.VarLists.put(newname, new ArrayList());
                } else if ("".equals(oldname)) {
                    this.STAppData.addSelectedArrayName(bugdashactionindex);
                } else {
                    this.updateSelectedArrayName(oldname, newname);
                }
                AV.JTextFieldVariable2.setText(newname);
            }
            if ("StoreLinkAsVarByXPATH".equals(AV.ActionType)) {
                this.STAppData.setHasStoredVar(true);
                stringactionindex = Integer.toString(actionindex + 1);
                stringbugindex = Integer.toString(thisBugView.index);
                bugdashactionindex = stringbugindex + "-" + stringactionindex;
                oldname = AV.JTextFieldVariable2.getText();
                newname = bugdashactionindex;
                if (oldname.equals(newname)) {
                    this.STAppData.VarHashMap.put(newname, "");
                } else if ("".equals(oldname)) {
                    this.addSelectedVariableName(bugdashactionindex);
                } else {
                    this.updateSelectedVariableName(oldname, newname);
                }
                AV.JTextFieldVariable2.setText(newname);
            }
            ++actionindex;
        }
    }

    public void populateSelectURLListPulldowns() {
        for (ProcedureView BV : this.BugViewArray) {
            if (!"Dataloop".equals(BV.Type)) continue;
            String selecteditem = BV.JComboBoxStoredArrayLists.getSelectedItem().toString();
            BV.JComboBoxStoredArrayLists.setEnabled(false);
            BV.JComboBoxStoredArrayLists.removeAllItems();
            BV.JComboBoxStoredArrayLists.addItem("Select a stored URL List");
            BV.JComboBoxStoredArrayLists.addItem("MASTER");
            for (String keyname : this.STAppData.VarLists.keySet()) {
                int bugindex;
                String[] parts;
                String leftpart;
                if (!keyname.contains("-") || "".equals(leftpart = (parts = keyname.split("-"))[0]) || (bugindex = Integer.parseInt(leftpart)) >= BV.index) continue;
                BV.JComboBoxStoredArrayLists.addItem(keyname);
            }
            if ("".equals(selecteditem)) {
                selecteditem = "Select a stored URL List";
            }
            BV.JComboBoxStoredArrayLists.setSelectedItem(selecteditem);
            BV.JComboBoxStoredArrayLists.setEnabled(true);
        }
    }

    public void setFilenames() {
        this.setShortFilename(this.STAppData.short_filename);
        this.setFilename(this.STAppData.filename);
    }

    public void setShortFilename(String in_short_filename) {
        this.short_filename = in_short_filename;
        this.setTitle(in_short_filename);
        this.repaint();
    }

    public void setOSType(String in_OSType) {
        switch (in_OSType) {
            case "Windows": {
                this.jCheckBoxOSTypeWindows32.setSelected(true);
                this.jCheckBoxOSTypeWindows64.setSelected(false);
                this.jCheckBoxOSTypeMac.setSelected(false);
                this.jCheckBoxOSTypeLinux32.setSelected(false);
                this.jCheckBoxOSTypeLinux64.setSelected(false);
                break;
            }
            case "Windows32": {
                this.jCheckBoxOSTypeWindows32.setSelected(true);
                this.jCheckBoxOSTypeWindows64.setSelected(false);
                this.jCheckBoxOSTypeMac.setSelected(false);
                this.jCheckBoxOSTypeLinux32.setSelected(false);
                this.jCheckBoxOSTypeLinux64.setSelected(false);
                break;
            }
            case "Windows64": {
                this.jCheckBoxOSTypeWindows64.setSelected(true);
                this.jCheckBoxOSTypeWindows32.setSelected(false);
                this.jCheckBoxOSTypeMac.setSelected(false);
                this.jCheckBoxOSTypeLinux32.setSelected(false);
                this.jCheckBoxOSTypeLinux64.setSelected(false);
                break;
            }
            case "Mac": {
                this.jCheckBoxOSTypeMac.setSelected(true);
                this.jCheckBoxOSTypeWindows32.setSelected(false);
                this.jCheckBoxOSTypeWindows64.setSelected(false);
                this.jCheckBoxOSTypeLinux32.setSelected(false);
                this.jCheckBoxOSTypeLinux64.setSelected(false);
                break;
            }
            case "Linux-32": {
                this.jCheckBoxOSTypeLinux32.setSelected(true);
                this.jCheckBoxOSTypeWindows32.setSelected(false);
                this.jCheckBoxOSTypeWindows64.setSelected(false);
                this.jCheckBoxOSTypeMac.setSelected(false);
                this.jCheckBoxOSTypeLinux64.setSelected(false);
                break;
            }
            case "Linux-64": {
                this.jCheckBoxOSTypeLinux64.setSelected(true);
                this.jCheckBoxOSTypeWindows32.setSelected(false);
                this.jCheckBoxOSTypeWindows64.setSelected(false);
                this.jCheckBoxOSTypeMac.setSelected(false);
                this.jCheckBoxOSTypeLinux32.setSelected(false);
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String in_filename) {
        this.filename = in_filename;
    }

    public File ChangeCSVFile() {
        JFileChooser CSVFileChooser = new JFileChooser();
        BrowserMatorConfig theseProps = new BrowserMatorConfig();
        String lastused_datafile_dir = theseProps.getKeyValue("lastused_datafile_dir");
        if (lastused_datafile_dir != null) {
            CSVFileChooser.setCurrentDirectory(new File(lastused_datafile_dir));
        }
        CSVFileChooser.addChoosableFileFilter(new ExtensionFileFilter(new String[]{".CSV"}, "Data File (*.CSV)"));
        CSVFileChooser.addChoosableFileFilter(new ExtensionFileFilter(new String[]{".CSV"}, "Comma Delimited File (*.CSV)"));
        CSVFileChooser.setAcceptAllFileFilterUsed(false);
        CSVFileChooser.setPreferredSize(new Dimension(800, 600));
        int returnVal = CSVFileChooser.showOpenDialog(this);
        File chosenDir = CSVFileChooser.getCurrentDirectory();
        theseProps.setKeyValue("lastused_datafile_dir", chosenDir.getAbsolutePath());
        if (returnVal == 0) {
            File file = CSVFileChooser.getSelectedFile();
            return file;
        }
        return null;
    }

    public void hideTaskGUI() {
        this.jLabelTasks.setVisible(false);
        this.JTextFieldProgress.setVisible(false);
        this.SouthButtonPanel.setVisible(false);
    }

    public void showTaskGUI() {
        this.jLabelTasks.setVisible(true);
        this.JTextFieldProgress.setVisible(true);
        this.SouthButtonPanel.setVisible(true);
    }

    public void setCurrentlySelectedFieldToStoredVariable(String fieldindex, int fieldnum) {
        String[] indexes = fieldindex.split("-");
        String bugindex = indexes[0];
        String actionindex = indexes[1];
        int bugindexnum = Integer.parseInt(bugindex) - 1;
        int actionindexnum = Integer.parseInt(actionindex) - 1;
        if (actionindexnum >= 0) {
            this.BugViewArray.get((int)bugindexnum).ActionsViewList.get(actionindexnum).setFieldToStoredVariable(this.jComboBoxStoredVariables.getSelectedItem().toString(), fieldnum);
        }
    }

    public String getSelectedVariableName() {
        String ret_val = "";
        ret_val = (String)this.jComboBoxStoredVariables.getSelectedItem();
        if (ret_val == "Select a stored variable") {
            ret_val = "";
        }
        return ret_val;
    }

    public void addSelectedVariableNameView(String varname) {
        if (((DefaultComboBoxModel)this.jComboBoxStoredVariables.getModel()).getIndexOf(varname) == -1) {
            this.jComboBoxStoredVariables.addItem(varname);
            int newitemindex = this.jComboBoxStoredVariables.getItemCount() - 1;
            this.jComboBoxStoredVariables.setSelectedIndex(newitemindex);
        }
    }

    public void MoveActionView(ProcedureView thisBugView, int toMoveIndex, int Direction) {
        this.saveState();
        int SwapIndex = toMoveIndex + Direction;
        if (Direction == 1 && toMoveIndex < thisBugView.ActionsViewList.size() - 1) {
            Collections.swap(thisBugView.ActionsViewList, toMoveIndex, SwapIndex);
            thisBugView.ActionsViewList.get(toMoveIndex).SetIndexes(thisBugView.index, toMoveIndex + 1);
            thisBugView.ActionsViewList.get(SwapIndex).SetIndexes(thisBugView.index, SwapIndex + 1);
        }
        if (Direction == -1 && toMoveIndex != 0) {
            Collections.swap(thisBugView.ActionsViewList, toMoveIndex, SwapIndex);
            thisBugView.ActionsViewList.get(toMoveIndex).SetIndexes(thisBugView.index, toMoveIndex + 1);
            thisBugView.ActionsViewList.get(SwapIndex).SetIndexes(thisBugView.index, SwapIndex + 1);
        }
    }

    public void addSelectedVariableName(String varname) {
        if (((DefaultComboBoxModel)this.jComboBoxStoredVariables.getModel()).getIndexOf(varname) == -1) {
            this.jComboBoxStoredVariables.addItem(varname);
            int newitemindex = this.jComboBoxStoredVariables.getItemCount() - 1;
            this.jComboBoxStoredVariables.setSelectedIndex(newitemindex);
        }
    }

    public void updateStoredVarPulldownView() {
        this.jComboBoxStoredVariables.removeAllItems();
        this.jComboBoxStoredVariables.addItem("Select a stored variable");
        for (String keyname : this.STAppData.VarHashMap.keySet()) {
            this.jComboBoxStoredVariables.addItem(keyname);
        }
    }

    public void updateStoredListsPulldownView(String olditem, String selecteditem, HashMap<String, String[]> VarLists) {
        for (ProcedureView BV : this.BugViewArray) {
            if (!"Dataloop".equals(BV.Type) || !"urllist".equals(BV.DataLoopSource)) continue;
            BV.JComboBoxStoredArrayLists.setEnabled(false);
            BV.JComboBoxStoredArrayLists.removeAllItems();
            BV.JComboBoxStoredArrayLists.addItem("Select a stored URL List");
            for (String keyname : VarLists.keySet()) {
                int bugindex;
                String[] parts = keyname.split("-");
                String leftpart = parts[0];
                if ("".equals(leftpart) || (bugindex = Integer.parseInt(leftpart)) >= BV.index + 1) continue;
                BV.JComboBoxStoredArrayLists.addItem(keyname);
            }
            if ("".equals(selecteditem)) {
                selecteditem = "Select a stored URL List";
            }
            BV.JComboBoxStoredArrayLists.setSelectedItem(selecteditem);
            BV.updatePlacedLoopVars(selecteditem);
            ArrayList<String> blanklist = new ArrayList<String>();
            BV.setJTableSourceToURLList(blanklist, selecteditem);
            BV.JComboBoxStoredArrayLists.setEnabled(true);
        }
    }

    public void ShowStoredVarControls(Boolean showhideval) {
        if (showhideval.booleanValue()) {
            this.jButtonPlaceStoredVariable.setVisible(true);
            this.jButtonPlaceStoredVariable.setEnabled(false);
            this.jLabelStoredVariables.setVisible(true);
            this.jComboBoxStoredVariables.setVisible(true);
        } else {
            this.jButtonPlaceStoredVariable.setVisible(false);
            this.jComboBoxStoredVariables.setVisible(false);
            this.jLabelStoredVariables.setVisible(false);
        }
    }

    public void ShowPlaceStoredVariableButton(Boolean showhideval, int bugindex, int actionindex, final int fieldnum) {
        if (showhideval.booleanValue()) {
            this.jButtonPlaceStoredVariable.setVisible(true);
            this.jButtonPlaceStoredVariable.setEnabled(true);
            String stringactionindex = Integer.toString(++actionindex);
            String stringbugindex = Integer.toString(bugindex);
            String bugdashactionindex = stringbugindex + "-" + stringactionindex;
            this.jButtonPlaceStoredVariable.setActionCommand(bugdashactionindex);
            this.removejButtonPlaceStoredVariableActionListener();
            this.addjButtonPlaceStoredVariableActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String ACommand = evt.getActionCommand();
                    SeleniumTestTool.this.setCurrentlySelectedFieldToStoredVariable(ACommand, fieldnum);
                }
            });
        } else {
            this.jButtonPlaceStoredVariable.setEnabled(false);
        }
    }

    public boolean getExitAfter() {
        boolean checked = this.jCheckBoxExitAfter.isSelected();
        return checked;
    }

    public boolean getEmailReport() {
        boolean checked = this.jCheckBoxEmailReport.isSelected();
        return checked;
    }

    public boolean getIncludeScreenshots() {
        boolean checked = this.jCheckBoxIncludeScreenshots.isSelected();
        if (!this.getShowReport()) {
            checked = false;
        }
        return checked;
    }

    public boolean getEmailReportFail() {
        boolean checked = this.jCheckBoxEmailReportFail.isSelected();
        return checked;
    }

    public void setPromptToClose(Boolean prompttoclose) {
        this.jCheckBoxPromptToClose.setSelected(prompttoclose);
    }

    public boolean getPromptToClose() {
        boolean checked = this.jCheckBoxPromptToClose.isSelected();
        return checked;
    }

    public boolean getShowReport() {
        boolean checked = this.jCheckBoxShowReport.isSelected();
        return checked;
    }

    public int GetWaitTime() {
        int fallbackValue = 1;
        try {
            this.jSpinnerWaitTime.commitEdit();
        }
        catch (ParseException pe) {
            JComponent editor = this.jSpinnerWaitTime.getEditor();
            if (editor instanceof JSpinner.DefaultEditor) {
                ((JSpinner.DefaultEditor)editor).getTextField().setValue(this.jSpinnerWaitTime.getValue());
            }
            this.jSpinnerWaitTime.setValue(fallbackValue);
        }
        int wait = (Integer)this.jSpinnerWaitTime.getValue();
        return wait;
    }

    public int getEcTimeout() {
        int fallbackValue = 1;
        try {
            this.jSpinnerEcTimeout.commitEdit();
        }
        catch (ParseException pe) {
            JComponent editor = this.jSpinnerEcTimeout.getEditor();
            if (editor instanceof JSpinner.DefaultEditor) {
                ((JSpinner.DefaultEditor)editor).getTextField().setValue(this.jSpinnerEcTimeout.getValue());
            }
            this.jSpinnerEcTimeout.setValue(fallbackValue);
        }
        int wait = (Integer)this.jSpinnerEcTimeout.getValue();
        return wait;
    }

    public int getSessions() {
        int fallbackValue = 1;
        try {
            this.jSpinnerSessions.commitEdit();
        }
        catch (ParseException pe) {
            JComponent editor = this.jSpinnerSessions.getEditor();
            if (editor instanceof JSpinner.DefaultEditor) {
                ((JSpinner.DefaultEditor)editor).getTextField().setValue(this.jSpinnerSessions.getValue());
            }
            this.jSpinnerSessions.setValue(fallbackValue);
        }
        int wait = (Integer)this.jSpinnerSessions.getValue();
        return wait;
    }

    public void disableAdds() {
        this.jButtonNewBug.setEnabled(false);
        this.jButtonNewDataLoop.setEnabled(false);
        for (ProcedureView PV : this.BugViewArray) {
            PV.JComboBoxDoActions.setEnabled(false);
            PV.JComboBoxPassFailActions.setEnabled(false);
            PV.JButtonGoAction.setEnabled(false);
            PV.JButtonClickAtXPATH.setEnabled(false);
            PV.JButtonTypeAtXPATH.setEnabled(false);
            PV.JButtonFindXPATHPassFail.setEnabled(false);
            PV.JButtonDoNotFindXPATHPassFail.setEnabled(false);
            PV.JButtonYesNoPromptPassFail.setEnabled(false);
        }
    }

    public void DeleteActionView(ProcedureView thisBugView, int atIndex) {
        String stringactionindex = Integer.toString(atIndex + 1);
        String stringbugindex = Integer.toString(thisBugView.index);
        String bugdashactionindex = stringbugindex + "-" + stringactionindex;
        if (this.STAppData.VarHashMap.containsKey(bugdashactionindex)) {
            this.STAppData.VarHashMap.remove(bugdashactionindex);
        }
        if (this.STAppData.VarLists.containsKey(bugdashactionindex)) {
            this.STAppData.VarLists.remove(bugdashactionindex);
        }
        thisBugView.ActionsViewList.remove(atIndex);
        for (int BugViewIndex = 0; BugViewIndex < thisBugView.ActionsViewList.size(); ++BugViewIndex) {
            if (BugViewIndex < atIndex) continue;
            --thisBugView.ActionsViewList.get((int)BugViewIndex).index;
        }
        this.updateStoredURLListIndexes(thisBugView);
        this.UpdateScrollPane(thisBugView);
        thisBugView.refreshjComboBoxAddAtPosition();
    }

    public void DeleteBugView(int BugIndex) {
        this.BugViewArray.remove(BugIndex - 1);
        this.ResetBugIndexes();
        this.ChangeURLListPulldowns();
        this.RefreshStoredLists();
    }

    public void RefreshStoredLists() {
        ArrayList<String> ExistingLists = new ArrayList<String>();
        ArrayList<String> ExistingVars = new ArrayList<String>();
        for (ProcedureView procedureView : this.BugViewArray) {
            for (ActionView AV : procedureView.ActionsViewList) {
                if ("StoreLinksAsURLListByXPATH".equals(AV.ActionType)) {
                    ExistingLists.add(AV.JTextFieldVariable2.getText());
                }
                if (!"StoreLinkAsVarByXPATH".equals(AV.ActionType)) continue;
                ExistingVars.add(AV.JTextFieldVariable2.getText());
            }
        }
        ArrayList<String> removeFromVarlistsKeys = new ArrayList<String>();
        for (String keyname : this.STAppData.VarLists.keySet()) {
            if (ExistingLists.contains(keyname)) continue;
            removeFromVarlistsKeys.add(keyname);
        }
        for (String keynameToRemove : removeFromVarlistsKeys) {
            this.STAppData.VarLists.remove(keynameToRemove);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String keyname : this.STAppData.VarHashMap.keySet()) {
            if (ExistingVars.contains(keyname)) continue;
            arrayList.add(keyname);
        }
        for (String keynameToRemove : arrayList) {
            this.STAppData.VarHashMap.remove(keynameToRemove);
        }
    }

    public void ResetBugIndexes() {
        int newindex = 1;
        for (ProcedureView procview : this.BugViewArray) {
            procview.SetIndex(newindex);
            ++newindex;
        }
        newindex = 1;
        for (Procedure PROC : this.STAppData.BugArray) {
            PROC.setIndex(newindex);
            ++newindex;
        }
        this.refreshjComboBoxAtIndex();
        this.refreshjComboBoxMoveToIndex();
    }

    public void ChangeURLListPulldowns() {
        for (ProcedureView PV : this.BugViewArray) {
            for (ActionView AV : PV.ActionsViewList) {
                String newname;
                if (!"StoreLinksAsURLListByXPATH".equals(AV.ActionType)) continue;
                this.STAppData.setHasStoredArray(true);
                String stringactionindex = Integer.toString(AV.index);
                String stringbugindex = Integer.toString(PV.index);
                String bugdashactionindex = stringbugindex + "-" + stringactionindex;
                String oldname = AV.JTextFieldVariable2.getText();
                if (oldname.equals(newname = bugdashactionindex)) continue;
                this.updateSelectedArrayName(oldname, newname);
            }
            this.updateStoredURLListIndexes(PV);
        }
        this.RemoveUpdateStoredPulldowns();
    }

    public void RemoveUpdateStoredPulldowns() {
        this.UpdateURLListPulldowns();
        this.updateStoredVarPulldownView();
        this.UpdateDisplay();
    }

    public void UpdateURLListPulldowns() {
        int procedureindex = 0;
        for (ProcedureView PV : this.BugViewArray) {
            if ("Dataloop".equals(PV.Type) && "urllist".equals(PV.DataLoopSource)) {
                String selecteditem = PV.JComboBoxStoredArrayLists.getSelectedItem().toString();
                PV.JComboBoxStoredArrayLists.removeAllItems();
                PV.JComboBoxStoredArrayLists.addItem("Select a stored URL List");
                boolean hasSelecteditem = false;
                for (String keyname : this.STAppData.VarLists.keySet()) {
                    if (keyname.equals(selecteditem)) {
                        hasSelecteditem = true;
                    }
                    PV.JComboBoxStoredArrayLists.addItem(keyname);
                }
                ArrayList<String> blanklist = new ArrayList<String>();
                if (hasSelecteditem) {
                    PV.setURLListName(selecteditem);
                    this.STAppData.BugArray.get(procedureindex).setURLListName(selecteditem);
                } else {
                    PV.JComboBoxStoredArrayLists.setSelectedIndex(0);
                    PV.setURLListName("");
                    PV.setJTableSourceToURLList(blanklist, "");
                    this.STAppData.BugArray.get(procedureindex).setURLListName("");
                }
            }
            ++procedureindex;
        }
    }

    public void disableRemoves() {
        for (ProcedureView PV : this.BugViewArray) {
            PV.JButtonDeleteBug.setEnabled(false);
            for (ActionView AV : PV.ActionsViewList) {
                AV.JButtonDelete.setEnabled(false);
            }
        }
    }

    public void enableRemoves() {
        for (ProcedureView PV : this.BugViewArray) {
            PV.JButtonDeleteBug.setEnabled(true);
            for (ActionView AV : PV.ActionsViewList) {
                AV.JButtonDelete.setEnabled(true);
            }
        }
    }

    public void enableAdds() {
        this.jButtonNewBug.setEnabled(true);
        this.jButtonNewDataLoop.setEnabled(true);
        for (ProcedureView PV : this.BugViewArray) {
            PV.JComboBoxDoActions.setEnabled(true);
            PV.JComboBoxPassFailActions.setEnabled(true);
            PV.JButtonGoAction.setEnabled(true);
            PV.JButtonClickAtXPATH.setEnabled(true);
            PV.JButtonTypeAtXPATH.setEnabled(true);
            PV.JButtonFindXPATHPassFail.setEnabled(true);
            PV.JButtonDoNotFindXPATHPassFail.setEnabled(true);
            PV.JButtonYesNoPromptPassFail.setEnabled(true);
        }
    }

    public void resetRunButtons() {
        for (ProcedureView PV : this.BugViewArray) {
            PV.JButtonRunTest.setText("Run");
        }
    }

    public void clearPassFailColors() {
        for (ProcedureView PV : this.BugViewArray) {
            PV.JLabelPass.setText("");
            for (ActionView TAV : PV.ActionsViewList) {
                TAV.JButtonDragIt.setBackground(new JButton().getBackground());
            }
        }
    }

    public void clearProcedurePassFailColors(ProcedureView PV) {
        PV.JLabelPass.setText("");
        for (ActionView TAV : PV.ActionsViewList) {
            TAV.JButtonDragIt.setBackground(new JButton().getBackground());
        }
    }

    public void setRunButtonEnabled(Boolean enabled_value) {
        this.jButtonDoStuff.setEnabled(enabled_value);
    }

    public void setFlattenFileButtonName(String newtext) {
        this.jButtonFlattenFile.setText(newtext);
    }

    public void RefreshViewData() {
        for (ProcedureView procview : this.BugViewArray) {
            if (!"Dataloop".equals(procview.Type)) continue;
            procview.refreshURLListRunTimeEntries();
        }
        for (Procedure PROC : this.STAppData.BugArray) {
            if (!"file".equals(PROC.Type)) continue;
            PROC.RunTimeFileSet.clear();
        }
    }

    public File BrowseForJSFileAction() {
        JFileChooser CSVFileChooser = new JFileChooser();
        BrowserMatorConfig theseProps = new BrowserMatorConfig();
        String lastJSOpenDir = theseProps.getKeyValue("lastused_js_open_dir");
        if (lastJSOpenDir != null) {
            CSVFileChooser.setCurrentDirectory(new File(lastJSOpenDir));
        }
        FileNameExtensionFilter filefilter = new FileNameExtensionFilter("Javascript file (*.js)", "js");
        CSVFileChooser.setFileFilter(filefilter);
        CSVFileChooser.setPreferredSize(new Dimension(800, 600));
        int returnVal = CSVFileChooser.showOpenDialog(this);
        File chosenDir = CSVFileChooser.getCurrentDirectory();
        theseProps.setKeyValue("lastused_js_open_dir", chosenDir.getAbsolutePath());
        if (returnVal == 0) {
            File file = CSVFileChooser.getSelectedFile();
            if (!file.getAbsoluteFile().getName().contains(".js")) {
                File newfile;
                String path = file.getAbsolutePath();
                file = newfile = new File(path + ".js");
            }
            return file;
        }
        return null;
    }

    public void setJButtonFlattenFileEnabled(boolean enable) {
        this.jButtonFlattenFile.setEnabled(enable);
    }

    public void saveState() {
    }

    public void Undo() {
        try {
            File lastUndoFile = new File(this.undoTempFile);
            if (lastUndoFile.exists()) {
                FileInputStream fis = new FileInputStream(this.undoTempFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                ArrayList loadedBugArray = (ArrayList)ois.readObject();
                ois.close();
                fis.close();
                this.saveState();
                this.STAppData.BugArray.clear();
                for (Procedure PROC : loadedBugArray) {
                    this.STAppData.BugArray.add(PROC);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Exception loading undo file: " + ex.toString());
        }
    }

    public void UpdateDisplay() {
        this.MainScrollPane.setVisible(false);
        this.BugPanel.setVisible(false);
        GridBagLayout buglayout = new GridBagLayout();
        GridBagConstraints bugConstraints = new GridBagConstraints();
        bugConstraints.anchor = 11;
        bugConstraints.fill = 2;
        bugConstraints.gridx = 0;
        bugConstraints.weightx = 1.0;
        bugConstraints.weighty = 1.0;
        this.BugPanel.removeAll();
        this.populateSelectURLListPulldowns();
        this.BugPanel.setLayout(buglayout);
        int bugindex = 0;
        for (ProcedureView BV : this.BugViewArray) {
            bugConstraints.gridy = bugindex;
            BV.SetIndex(bugindex + 1);
            this.BugPanel.add((Component)BV.JPanelBug, bugConstraints);
            JPanel ActionPanel = new JPanel();
            BV.ActionScrollPane.setViewportView(ActionPanel);
            this.UpdateScrollPane(BV);
            ++bugindex;
        }
        this.BugPanel.setVisible(true);
        this.MainScrollPane.setViewportView(this.BugPanel);
        this.MainScrollPane.setVisible(true);
        this.validate();
        this.updateStoredVarPulldownView();
    }

    public void setJTextFieldProgress(String value) {
        this.jButtonCancel.setEnabled(true);
        this.JTextFieldProgress.setText(value);
    }

    public void UpdateScrollPane(ProcedureView newbugview) {
        JPanel ActionPanel = (JPanel)newbugview.ActionScrollPane.getViewport().getView();
        ActionPanel.removeAll();
        GridBagLayout ActionLayout = new GridBagLayout();
        int actionindex = 0;
        GridBagConstraints ActionConstraints = new GridBagConstraints();
        ActionConstraints.anchor = 17;
        ActionConstraints.gridx = 0;
        ActionConstraints.fill = 2;
        ActionConstraints.weightx = 1.0;
        ActionPanel.setLayout(ActionLayout);
        for (ActionView AV : newbugview.ActionsViewList) {
            ActionConstraints.gridy = actionindex;
            AV.SetIndexes(newbugview.index, actionindex + 1);
            for (ActionSettings theseSettings : AV.theseActionSettings) {
                GridBagConstraints ActionPanelConstraints = new GridBagConstraints();
                ActionPanelConstraints.insets = new Insets(2, 2, 2, 2);
                ActionPanelConstraints.fill = 2;
                ActionPanelConstraints.anchor = theseSettings.GridBagAnchor;
                ActionPanelConstraints.gridx = theseSettings.gridx;
                ActionPanelConstraints.gridy = actionindex;
                ActionPanelConstraints.gridwidth = theseSettings.width;
                ActionPanelConstraints.gridheight = 1;
                ActionPanelConstraints.weightx = theseSettings.weightX;
                AV.JPanelAction.add(theseSettings.comp, ActionPanelConstraints);
                ActionPanel.add((Component)AV.JPanelAction, ActionConstraints);
            }
            ++actionindex;
        }
        if (actionindex < 8) {
            newbugview.ActionScrollPane.setPreferredSize(new Dimension(950, 36 * actionindex + 20));
        } else {
            newbugview.ActionScrollPane.setPreferredSize(new Dimension(950, 236));
        }
        newbugview.ActionScrollPane.setVisible(true);
        newbugview.ActionScrollPane.setViewportView(ActionPanel);
    }

    public void AddNewBugView() {
        ProcedureView newbugview = new ProcedureView();
        newbugview.setType("Procedure");
        this.BugViewArray.add(newbugview);
        int thissize = this.BugViewArray.size();
        this.BugViewArray.get(thissize - 1).SetIndex(thissize);
        this.refreshjComboBoxAtIndex();
        this.refreshjComboBoxMoveToIndex();
    }

    public void AddNewBugView(int atindex) {
        ProcedureView newbugview = new ProcedureView();
        newbugview.setType("Procedure");
        this.BugViewArray.add(--atindex, newbugview);
        this.ResetBugIndexes();
        this.ChangeURLListPulldowns();
    }

    public void AddNewDataLoopView() {
        ProcedureView newdataloopview = new ProcedureView();
        newdataloopview.setType("Dataloop");
        newdataloopview.setDataLoopSource("none");
        this.AddDataLoopProcView(newdataloopview);
    }

    public void AddNewDataLoopView(int atindex) {
        ProcedureView newdataloopview = new ProcedureView();
        newdataloopview.setType("Dataloop");
        newdataloopview.setDataLoopSource("none");
        this.AddDataLoopProcView(newdataloopview, atindex);
    }

    public void AddDataLoopProcView(ProcedureView newdataloopview) {
        this.BugViewArray.add(newdataloopview);
        int thissize = this.BugViewArray.size();
        this.BugViewArray.get(thissize - 1).SetIndex(thissize);
        this.ResetBugIndexes();
    }

    public void AddDataLoopProcView(ProcedureView newdataloopview, int atindex) {
        this.BugViewArray.add(--atindex, newdataloopview);
        this.ResetBugIndexes();
        this.ChangeURLListPulldowns();
    }

    public void AddNewDataLoopURLListView(String in_listname) {
        ProcedureView newdataloopview = new ProcedureView();
        newdataloopview.setType("Dataloop");
        newdataloopview.setDataLoopSource("urllist");
        newdataloopview.setURLListName(in_listname);
        ArrayList<String> blanklist = new ArrayList<String>();
        newdataloopview.setJTableSourceToURLList(blanklist, in_listname);
        this.AddDataLoopProcView(newdataloopview);
    }

    public void AddNewDataLoopURLListView(String in_listname, int at_index) {
        ProcedureView newdataloopview = new ProcedureView();
        newdataloopview.setType("Dataloop");
        newdataloopview.setDataLoopSource("urllist");
        newdataloopview.setURLListName(in_listname);
        ArrayList<String> blanklist = new ArrayList<String>();
        newdataloopview.setJTableSourceToURLList(blanklist, in_listname);
        this.AddDataLoopProcView(newdataloopview, at_index);
    }

    public void AddNewDataLoopFileView(File CSVFile) {
        String canon_path = "";
        ProcedureView newdataloopview = new ProcedureView();
        newdataloopview.setType("Dataloop");
        newdataloopview.setDataLoopSource("file");
        List<String[]> dataset_to_send = new ArrayList<String[]>();
        if (CSVFile.exists()) {
            try {
                canon_path = CSVFile.getCanonicalPath();
            }
            catch (IOException ex) {
                System.out.println("Exception getting data file path: " + ex.toString());
            }
            newdataloopview.setDataFile(canon_path);
            dataset_to_send = this.STAppData.getDataSetByFileName(canon_path);
        }
        newdataloopview.setJComboBoxStoredArraylists("Select a stored URL List");
        newdataloopview.setJTableSourceToDataSet(dataset_to_send, canon_path);
        this.AddDataLoopProcView(newdataloopview);
    }

    public void AddNewDataLoopFileView(File CSVFile, int at_index) {
        String canon_path = "";
        ProcedureView newdataloopview = new ProcedureView();
        newdataloopview.setType("Dataloop");
        newdataloopview.setDataLoopSource("file");
        if (CSVFile.exists()) {
            try {
                canon_path = CSVFile.getCanonicalPath();
            }
            catch (IOException ex) {
                System.out.println("Exception getting data file path: " + ex.toString());
            }
            newdataloopview.setDataFile(canon_path);
            List<String[]> dataset_to_send = this.STAppData.getDataSetByFileName(canon_path);
            newdataloopview.setJComboBoxStoredArraylists("Select a stored URL List");
            newdataloopview.setJTableSourceToDataSet(dataset_to_send, canon_path);
        }
        this.AddDataLoopProcView(newdataloopview, at_index);
    }

    public void DisableProcedure(ProcedureView thisbugview, Procedure thisbug) {
        thisbugview.Disable();
        thisbug.Disable();
    }

    public void EnableProcedure(ProcedureView thisbugview, Procedure thisbug) {
        thisbugview.Enable();
        thisbug.Enable();
    }

    public void ScrollActionPaneDown(ProcedureView bugview) {
        JComponent component = (JComponent)bugview.ActionScrollPane.getViewport().getView();
        int last_added_action_index = bugview.getJComboBoxAddAtPosition();
        if (last_added_action_index > 0) {
            --last_added_action_index;
        }
        Rectangle bounds = bugview.ActionsViewList.get((int)last_added_action_index).JPanelAction.getBounds();
        component.scrollRectToVisible(bounds);
    }

    public void RefreshActionViewIndexes(ArrayList<ActionView> actionviewlist) {
        for (int x = 0; x < actionviewlist.size(); ++x) {
            actionviewlist.get((int)x).index = x;
        }
    }

    public void AddActionViewToArray(ActionView actionview, ProcedureView newbugview) {
        int at_index = newbugview.getJComboBoxAddAtPosition();
        if (at_index > 0) {
            newbugview.ActionsViewList.add(--at_index, actionview);
            actionview.index = at_index;
            this.RefreshActionViewIndexes(newbugview.ActionsViewList);
        } else {
            newbugview.ActionsViewList.add(actionview);
            actionview.index = newbugview.ActionsViewList.size();
        }
        actionview.SetIndexes(newbugview.index, actionview.index);
        if ("StoreLinksAsURLListByXPATH".equals(actionview.ActionType)) {
            this.UpdateURLListPulldowns();
        }
        if ("StoreLinkAsVarByXPATH".equals(actionview.ActionType)) {
            this.updateStoredVarPulldownView();
        }
        this.UpdateScrollPane(newbugview);
    }

    public void ClearEmailSettings() {
        this.setSMTPHostname("");
        this.setEmailLoginName("");
        this.setEmailPassword("");
        this.setEmailTo("");
        this.setEmailFrom("");
        this.setSubject("");
    }

    private void initializeComponents() {
        JPanel jPanelNorth = new JPanel();
        JPanel jPanelSouth = new JPanel();
        JPanel jPanelEast = new JPanel();
        this.jButtonDoStuff = new JButton();
        this.jButtonNewBug = new JButton();
        this.jLabelInsertionPoint = new JLabel("Add at position: ");
        this.jComboBoxAtIndex = new JComboBox();
        this.MainScrollPane = new JScrollPane();
        this.jSpinnerWaitTime = new JSpinner();
        this.jSpinnerEcTimeout = new JSpinner();
        JLabel jLabelEcTimeout = new JLabel();
        JLabel jLabelPauseTime = new JLabel();
        this.jCheckBoxEmailReport = new JCheckBox();
        JLabel jLabelSMTPHostname = new JLabel();
        this.jTextFieldSMTPHostName = new JTextField();
        JLabel jLabelEmailLoginName = new JLabel();
        this.jTextFieldEmailLoginName = new JTextField();
        JLabel jLabelEmailLoginPassword = new JLabel();
        JLabel jLabelEmailTo = new JLabel();
        this.jTextFieldEmailTo = new JTextField();
        JLabel jLabelEmailFrom = new JLabel();
        this.jTextFieldEmailFrom = new JTextField();
        JLabel jLabelTitleSubject = new JLabel();
        this.jTextFieldSubject = new JTextField();
        this.jCheckBoxShowReport = new JCheckBox();
        this.jCheckBoxExitAfter = new JCheckBox();
        this.jTextFieldEmailPassword = new JPasswordField();
        this.jCheckBoxEmailReportFail = new JCheckBox();
        this.jCheckBoxPromptToClose = new JCheckBox();
        JLabel jLabelTargetBrowser = new JLabel();
        this.jComboBoxTargetBrowser = new JComboBox();
        this.jCheckBoxOSTypeWindows32 = new JCheckBox();
        this.jCheckBoxOSTypeMac = new JCheckBox();
        this.jCheckBoxOSTypeLinux32 = new JCheckBox();
        this.jCheckBoxOSTypeLinux64 = new JCheckBox();
        this.jButtonClearEmailSettings = new JButton();
        this.jButtonNewDataLoop = new JButton();
        this.jButtonBrowseForFireFoxExe = new JButton();
        this.jButtonFlattenFile = new JButton();
        this.jButtonLoadEmailSettings = new JButton();
        this.jButtonGutsView = new JButton();
        this.jComboBoxStoredVariables = new JComboBox();
        this.jButtonPlaceStoredVariable = new JButton();
        this.jLabelStoredVariables = new JLabel();
        this.jCheckBoxOSTypeWindows64 = new JCheckBox();
        this.jCheckBoxIncludeScreenshots = new JCheckBox();
        this.jSpinnerSessions = new JSpinner();
        this.jLabelSessions = new JLabel();
        this.jCheckBoxEnableMultiSession = new JCheckBox();
        JLabel jLabelIENote = new JLabel();
        this.jCheckBoxUniqueURLs = new JCheckBox();
        this.jRadioButtonUniquePerFile = new JRadioButton();
        this.jRadioButtonUniqueGlobal = new JRadioButton();
        this.JTextFieldProgress = new JTextField();
        this.jLabelTasks = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(1280, 800));
        this.jButtonDoStuff.setText("Run All Procedures");
        this.jButtonDoStuff.setActionCommand("AddAction");
        this.jButtonNewBug.setText("Add Procedure ");
        this.MainScrollPane.setHorizontalScrollBarPolicy(31);
        this.MainScrollPane.setVerticalScrollBarPolicy(22);
        this.MainScrollPane.setName("");
        jLabelEcTimeout.setText("EC Timeout:");
        this.setjSpinnerEcTimeout(this.STAppData.getEcTimeout());
        jLabelPauseTime.setText("Pause time (seconds)");
        this.jCheckBoxEmailReport.setText("Email Report");
        jLabelSMTPHostname.setText("SMTPHostname:");
        jLabelEmailLoginName.setText("Email Login Name:");
        jLabelEmailLoginPassword.setText("Email Login Password:");
        jLabelEmailTo.setText("E-mail To:");
        jLabelEmailFrom.setText("E-mail From:");
        jLabelTitleSubject.setText("Title/Subject:");
        this.jCheckBoxShowReport.setText("Show Report");
        this.jCheckBoxExitAfter.setText("Exit After Running");
        this.jCheckBoxEmailReportFail.setText("Email Fail Report Only");
        this.jCheckBoxEmailReportFail.setActionCommand("EmailReportIfFail");
        this.jCheckBoxPromptToClose.setText("Prompt to Close WebDriver/Browser");
        jLabelTargetBrowser.setText("Target Browser:");
        String[] BugIndexes = new String[]{};
        this.jComboBoxTargetBrowser.setModel(new DefaultComboBoxModel<String>(new String[]{"Chrome", "Firefox", "Internet Explorer-32", "Internet Explorer-64", "Edge", "Silent Mode (HTMLUnit)", "Firefox/IE/Chrome"}));
        this.jCheckBoxOSTypeWindows32.setText("Windows - 32");
        this.jCheckBoxOSTypeWindows32.setEnabled(false);
        this.jCheckBoxOSTypeMac.setText("Mac");
        this.jCheckBoxOSTypeMac.setEnabled(false);
        this.jCheckBoxOSTypeLinux32.setText("Linux - 32");
        this.jCheckBoxOSTypeLinux32.setEnabled(false);
        this.jCheckBoxOSTypeLinux64.setText("Linux - 64");
        this.jCheckBoxOSTypeLinux64.setEnabled(false);
        this.jButtonClearEmailSettings.setText("Clear Email Settings");
        this.jButtonNewDataLoop.setText("Add Data Loop Procedure ");
        this.jButtonBrowseForFireFoxExe.setText("...");
        this.jButtonBrowseForFireFoxExe.setEnabled(false);
        this.jButtonFlattenFile.setText("Flatten to New File");
        this.jButtonFlattenFile.setEnabled(false);
        this.jButtonLoadEmailSettings.setText("Load Default Settings");
        this.jButtonGutsView.setText("View Guts");
        this.jComboBoxStoredVariables.setModel(new DefaultComboBoxModel<String>(new String[]{"Select a stored variable"}));
        this.jButtonPlaceStoredVariable.setText("Place Variable");
        this.jLabelStoredVariables.setText("Stored Variables");
        this.jCheckBoxOSTypeWindows64.setText("Windows - 64");
        this.jCheckBoxOSTypeWindows64.setEnabled(false);
        this.jCheckBoxIncludeScreenshots.setText("Include Screenshots");
        this.jCheckBoxIncludeScreenshots.setEnabled(false);
        this.jSpinnerSessions.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.jSpinnerSessions.setEnabled(false);
        this.jLabelSessions.setText("Number of Sessions:");
        this.jCheckBoxEnableMultiSession.setText("Enable Multi-Session");
        jLabelIENote.setText("*To use Internet Explorer all security zones must have Enable Protected Mode checked.");
        this.jCheckBoxUniqueURLs.setText("Unique Random URLs Only");
        this.jCheckBoxUniqueURLs.setToolTipText("");
        this.jRadioButtonUniquePerFile.setText("Per File");
        this.jRadioButtonUniquePerFile.setEnabled(false);
        this.jRadioButtonUniqueGlobal.setText("Global");
        this.jRadioButtonUniqueGlobal.setEnabled(false);
        JLabel jLabelOSType = new JLabel();
        jLabelOSType.setText("Set OS:");
        this.jLabelTasks.setText("Running Tasks:");
        this.jLabelWaitForLoad = new JLabel("Wait for Page Load:");
        this.jComboBoxWaitForLoad = new JComboBox();
        this.jComboBoxWaitForLoad.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No", "Local DOM Only"}));
        this.jLabelPromptBehavior = new JLabel("Unhandled Prompts:");
        this.jComboBoxPromptBehavior = new JComboBox();
        this.jComboBoxPromptBehavior.setModel(new DefaultComboBoxModel<String>(new String[]{"Dismiss", "Accept", "Fail"}));
        jPanelNorth.add(this.jButtonNewBug);
        jPanelNorth.add(this.jButtonNewDataLoop);
        jPanelNorth.add(this.jLabelInsertionPoint);
        jPanelNorth.add(this.jComboBoxAtIndex);
        jPanelNorth.add(this.jLabelStoredVariables);
        jPanelNorth.add(this.jComboBoxStoredVariables);
        jPanelNorth.add(this.jButtonPlaceStoredVariable);
        jPanelNorth.add(this.jButtonGutsView);
        jPanelSouth.setLayout(new BoxLayout(jPanelSouth, 2));
        jPanelSouth.add(Box.createHorizontalGlue());
        jPanelSouth.add(this.jButtonDoStuff);
        jPanelSouth.add(jLabelPauseTime);
        jPanelSouth.add(this.jSpinnerWaitTime);
        jPanelSouth.add(jLabelEcTimeout);
        jPanelSouth.add(this.jSpinnerEcTimeout);
        jPanelSouth.add(jLabelTargetBrowser);
        jPanelSouth.add(this.jComboBoxTargetBrowser);
        jPanelSouth.add(this.jButtonBrowseForFireFoxExe);
        jPanelSouth.add(this.jLabelWaitForLoad);
        jPanelSouth.add(this.jComboBoxWaitForLoad);
        jPanelSouth.add(this.jLabelPromptBehavior);
        jPanelSouth.add(this.jComboBoxPromptBehavior);
        jPanelSouth.add(this.jCheckBoxPromptToClose);
        JPanel jPanelSouth2 = new JPanel();
        jPanelSouth.setLayout(new BoxLayout(jPanelSouth, 2));
        jPanelSouth2.add(this.jLabelTasks);
        this.jButtonPause = new JButton("Pause");
        this.jButtonContinue = new JButton("Continue");
        this.jButtonContinue.setEnabled(false);
        this.jButtonCancel = new JButton("Cancel");
        this.jButtonClearUniqueList = new JButton("Clear Unique List");
        this.SouthButtonPanel = new JPanel();
        this.SouthButtonPanel.add(this.jButtonContinue);
        this.SouthButtonPanel.add(this.jButtonPause);
        this.SouthButtonPanel.add(this.jButtonCancel);
        this.JTextFieldProgress.setPreferredSize(new Dimension(600, 30));
        jPanelSouth2.add(this.JTextFieldProgress);
        JPanel jPanelAllSouth = new JPanel();
        jPanelAllSouth.setLayout(new BoxLayout(jPanelAllSouth, 1));
        jPanelAllSouth.add(jPanelSouth);
        jPanelAllSouth.add(jPanelSouth2);
        jPanelAllSouth.add(this.SouthButtonPanel);
        this.add((Component)this.MainScrollPane, "Center");
        this.add((Component)jPanelAllSouth, "South");
        jPanelEast.setLayout(new BoxLayout(jPanelEast, 1));
        jPanelEast.add(this.jCheckBoxShowReport);
        jPanelEast.add(this.jCheckBoxIncludeScreenshots);
        jPanelEast.add(this.jCheckBoxExitAfter);
        JSeparator separator2 = new JSeparator(0);
        separator2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        jPanelEast.add(separator2);
        jPanelEast.add(jLabelOSType);
        jPanelEast.add(this.jCheckBoxOSTypeWindows32);
        jPanelEast.add(this.jCheckBoxOSTypeWindows64);
        jPanelEast.add(this.jCheckBoxOSTypeLinux32);
        jPanelEast.add(this.jCheckBoxOSTypeLinux64);
        jPanelEast.add(this.jCheckBoxOSTypeMac);
        JSeparator separator3 = new JSeparator(0);
        separator3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        jPanelEast.add(separator3);
        jPanelEast.add(this.jCheckBoxUniqueURLs);
        jPanelEast.add(this.jRadioButtonUniquePerFile);
        jPanelEast.add(this.jRadioButtonUniqueGlobal);
        jPanelEast.add(this.jButtonClearUniqueList);
        JSeparator separator30 = new JSeparator(0);
        separator30.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        jPanelEast.add(separator30);
        jPanelEast.add(this.jCheckBoxEmailReport);
        jPanelEast.add(this.jCheckBoxEmailReportFail);
        jPanelEast.add(jLabelSMTPHostname);
        this.jTextFieldSMTPHostName.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jTextFieldEmailLoginName.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jTextFieldEmailPassword.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jTextFieldEmailTo.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jTextFieldEmailFrom.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jTextFieldSubject.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        jPanelEast.add(this.jTextFieldSMTPHostName);
        jPanelEast.add(jLabelEmailLoginName);
        jPanelEast.add(this.jTextFieldEmailLoginName);
        jPanelEast.add(jLabelEmailLoginPassword);
        jPanelEast.add(this.jTextFieldEmailPassword);
        jPanelEast.add(jLabelEmailTo);
        jPanelEast.add(this.jTextFieldEmailTo);
        jPanelEast.add(jLabelEmailFrom);
        jPanelEast.add(this.jTextFieldEmailFrom);
        jPanelEast.add(jLabelTitleSubject);
        jPanelEast.add(this.jTextFieldSubject);
        jPanelEast.add(this.jButtonLoadEmailSettings);
        jPanelEast.add(this.jButtonClearEmailSettings);
        JSeparator separator4 = new JSeparator(0);
        separator4.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        jPanelEast.add(separator4);
        jPanelEast.add(this.jButtonFlattenFile);
        this.add((Component)jPanelEast, "West");
        JSeparator separator5 = new JSeparator(0);
        separator5.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10));
        this.add((Component)jPanelNorth, "North");
        this.pack();
        String visited_list_file_path = this.UNIQUE_LOG_DIR + "browsermator_" + this.STAppData.short_filename + "_visited_url_log.xml";
        File fileCheck = new File(visited_list_file_path);
        if (!fileCheck.exists()) {
            this.jButtonClearUniqueList.setEnabled(false);
        }
    }

    public void setUniqueFileOptionView(String option) {
        if (option.equals("file")) {
            this.jRadioButtonUniquePerFile.setSelected(true);
            this.jRadioButtonUniqueGlobal.setSelected(false);
        }
        if (option.equals("global")) {
            this.jRadioButtonUniquePerFile.setSelected(false);
            this.jRadioButtonUniqueGlobal.setSelected(true);
        }
    }

    public void setOSTypeActive(Boolean Active) {
        if (Active.booleanValue()) {
            this.jCheckBoxOSTypeWindows32.setEnabled(true);
            this.jCheckBoxOSTypeWindows64.setEnabled(true);
            this.jCheckBoxOSTypeMac.setEnabled(true);
            this.jCheckBoxOSTypeLinux32.setEnabled(true);
            this.jCheckBoxOSTypeLinux64.setEnabled(true);
        } else {
            this.jCheckBoxOSTypeWindows32.setEnabled(false);
            this.jCheckBoxOSTypeWindows64.setEnabled(false);
            this.jCheckBoxOSTypeMac.setEnabled(false);
            this.jCheckBoxOSTypeLinux32.setEnabled(false);
            this.jCheckBoxOSTypeLinux64.setEnabled(false);
        }
    }

    public void setjRadioButtonUniqueGlobalSelected(boolean selected) {
        this.jRadioButtonUniqueGlobal.setSelected(selected);
    }

    public boolean getjRadioButtonUniquePerFile() {
        return this.jRadioButtonUniquePerFile.isSelected();
    }

    public boolean getjCheckBoxEmailReportSelected() {
        return this.jCheckBoxEmailReport.isSelected();
    }

    public void addjCheckBoxIncludeScreenshotsActionListener(ActionListener listener) {
        this.jCheckBoxIncludeScreenshots.addActionListener(listener);
    }

    public void addjCheckBoxEmailReportActionListener(ActionListener listener) {
        this.jCheckBoxEmailReport.addActionListener(listener);
    }

    public void setjCheckBoxEmailReportSelected(boolean selected) {
        this.jCheckBoxEmailReport.setSelected(selected);
    }

    public boolean getjCheckBoxOSTypeLinux64Selected() {
        return this.jCheckBoxOSTypeLinux64.isSelected();
    }

    public void addjCheckBoxOSTypeLinux64ActionListener(ActionListener listener) {
        this.jCheckBoxOSTypeLinux64.addActionListener(listener);
    }

    public boolean getjCheckBoxOSTypeLinux32Selected() {
        return this.jCheckBoxOSTypeLinux32.isSelected();
    }

    public void addjCheckBoxOSTypeLinux32ActionListener(ActionListener listener) {
        this.jCheckBoxOSTypeLinux32.addActionListener(listener);
    }

    public boolean getjCheckBoxOSTypeMacSelected() {
        return this.jCheckBoxOSTypeMac.isSelected();
    }

    public void addjCheckBoxOSTypeMacActionListener(ActionListener listener) {
        this.jCheckBoxOSTypeMac.addActionListener(listener);
    }

    public void setjCheckBoxOSTypeWindows32Selected(boolean selected) {
        this.jCheckBoxOSTypeWindows32.setSelected(selected);
    }

    public boolean getjCheckBoxOSTypeWindows64Selected() {
        return this.jCheckBoxOSTypeWindows64.isSelected();
    }

    public boolean getjCheckBoxOSTypeWindows32Selected() {
        return this.jCheckBoxOSTypeWindows32.isSelected();
    }

    public void addjCheckBoxOSTypeWindows64ActionListener(ActionListener listener) {
        this.jCheckBoxOSTypeWindows64.addActionListener(listener);
    }

    public void setjCheckBoxOSTypeLinux64Selected(boolean selected) {
        this.jCheckBoxOSTypeLinux64.setSelected(selected);
    }

    public void setjCheckBoxOSTypeLinux32Selected(boolean selected) {
        this.jCheckBoxOSTypeLinux32.setSelected(selected);
    }

    public void setjCheckBoxOSTypeMacSelected(boolean selected) {
        this.jCheckBoxOSTypeMac.setSelected(selected);
    }

    public void setjCheckBoxOSTypeWindows64Selected(boolean selected) {
        this.jCheckBoxOSTypeWindows64.setSelected(selected);
    }

    public void setjCheckBoxShowReportSelected(boolean selected) {
        this.jCheckBoxShowReport.setSelected(selected);
    }

    public void addjCheckBoxOSTypeWindows32ActionListener(ActionListener listener) {
        this.jCheckBoxOSTypeWindows32.addActionListener(listener);
    }

    public boolean getjCheckBoxEmailReportFailSelected() {
        return this.jCheckBoxEmailReportFail.isSelected();
    }

    public void addjCheckBoxEmailReportFailActionListener(ActionListener listener) {
        this.jCheckBoxEmailReportFail.addActionListener(listener);
    }

    public void setjSpinnerSessionsEnabled(boolean enabled) {
        this.jSpinnerSessions.setEnabled(enabled);
    }

    public boolean getjCheckBoxEnableMultiSessionSelected() {
        return this.jCheckBoxEnableMultiSession.isSelected();
    }

    public boolean getjRadioButtonUniquePerFileSelected() {
        return this.jRadioButtonUniquePerFile.isSelected();
    }

    public void addjCheckBoxEnableMultiSessionActionListener(ActionListener listener) {
        this.jCheckBoxEnableMultiSession.addActionListener(listener);
    }

    public void setjCheckBoxEmailReportFailSelected(boolean selected) {
        this.jCheckBoxEmailReportFail.setSelected(selected);
    }

    public void setjRadioButtonUniquePerFileEnabled(boolean enabled) {
        this.jRadioButtonUniquePerFile.setEnabled(enabled);
    }

    public void setjRadioButtonUniqueGlobalEnabled(boolean enabled) {
        this.jRadioButtonUniqueGlobal.setEnabled(enabled);
    }

    public boolean getjCheckBoxUniqueURLsSelected() {
        return this.jCheckBoxUniqueURLs.isSelected();
    }

    public void addjCheckBoxUniqueURLsActionListener(ActionListener listener) {
        this.jCheckBoxUniqueURLs.addActionListener(listener);
    }

    public boolean getjRadioButtonUniqueGlobalSelected() {
        return this.jRadioButtonUniqueGlobal.isSelected();
    }

    public void setjRadioButtonUniquePerFileSelected(boolean selected) {
        this.jRadioButtonUniquePerFile.setSelected(selected);
    }

    public void addjRadioButtonUniqueGlobalActionListener(ActionListener listener) {
        this.jRadioButtonUniqueGlobal.addActionListener(listener);
    }

    public void addjRadioButtonUniquePerFileActionListener(ActionListener listener) {
        this.jRadioButtonUniquePerFile.addActionListener(listener);
    }

    public boolean getjCheckBoxExitAfter() {
        return this.jCheckBoxExitAfter.isSelected();
    }

    public void addjCheckBoxExitAfterActionListener(ActionListener listener) {
        this.jCheckBoxExitAfter.addActionListener(listener);
    }

    public boolean getjCheckBoxPromptToClose() {
        return this.jCheckBoxPromptToClose.isSelected();
    }

    public void setjCheckBoxExitAfterEnabled(boolean enabled) {
        this.jCheckBoxExitAfter.setEnabled(enabled);
    }

    public void setjCheckBoxEmailReportEnabled(boolean enabled) {
        this.jCheckBoxEmailReport.setEnabled(enabled);
    }

    public void setjCheckBoxIncludeScreenshotsEnabled(boolean enabled) {
        this.jCheckBoxIncludeScreenshots.setEnabled(enabled);
    }

    public Boolean getjCheckBoxShowReport() {
        return this.jCheckBoxShowReport.isSelected();
    }

    public void addjCheckBoxShowReportActionListener(ActionListener listener) {
        this.jCheckBoxShowReport.addActionListener(listener);
    }

    public void addjCheckBoxPromptToCloseActionListener(ActionListener listener) {
        this.jCheckBoxPromptToClose.addActionListener(listener);
    }

    public void addjComboBoxWaitForLoadItemListener(ItemListener listener) {
        this.jComboBoxWaitForLoad.addItemListener(listener);
    }

    public void addjComboBoxPromptBehaviorItemListener(ItemListener listener) {
        this.jComboBoxPromptBehavior.addItemListener(listener);
    }

    public void addTargetBrowserItemListener(ItemListener listener) {
        this.jComboBoxTargetBrowser.addItemListener(listener);
    }

    public void addjButtonBrowseForFireFoxExeActionListener(ActionListener listener) {
        this.jButtonBrowseForFireFoxExe.addActionListener(listener);
    }

    public void addjButtonPlaceStoredVariableActionListener(ActionListener listener) {
        this.jButtonPlaceStoredVariable.addActionListener(listener);
    }

    public void removejButtonPlaceStoredVariableActionListener() {
        ActionListener[] theseListeners = this.jButtonPlaceStoredVariable.getActionListeners();
        if (theseListeners.length > 0) {
            this.jButtonPlaceStoredVariable.removeActionListener(theseListeners[0]);
        }
    }

    public void addjButtonNewBugActionListener(ActionListener listener) {
        this.jButtonNewBug.addActionListener(listener);
    }

    public void addjButtonNewDataLoopActionListener(ActionListener listener) {
        this.jButtonNewDataLoop.addActionListener(listener);
    }

    public void addjButtonDoStuffActionListener(ActionListener listener) {
        this.jButtonDoStuff.addActionListener(listener);
    }

    public void enablejButtonDoStuff(boolean enable_it) {
        this.jButtonDoStuff.setEnabled(enable_it);
    }

    public void addjButtonFlattenFileActionListener(ActionListener listener) {
        this.jButtonFlattenFile.addActionListener(listener);
    }

    public void addjButtonClearEmailSettingsListener(ActionListener listener) {
        this.jButtonClearEmailSettings.addActionListener(listener);
    }

    public void addjButtonLoadEmailSettingsListener(ActionListener listener) {
        this.jButtonLoadEmailSettings.addActionListener(listener);
    }

    public void addjButtonGutsViewActionListener(ActionListener listener) {
        this.jButtonGutsView.addActionListener(listener);
    }

    public void addjSpinnerEcTimeoutTimeChangeListener(ChangeListener listener) {
        this.jSpinnerEcTimeout.addChangeListener(listener);
    }

    public void addjSpinnerWaitTimeChangeListener(ChangeListener listener) {
        this.jSpinnerWaitTime.addChangeListener(listener);
    }

    public void addjSpinnerSessionsChangeListener(ChangeListener listener) {
        this.jSpinnerSessions.addChangeListener(listener);
    }

    public void addjButtonClearUniqueListActionListener(ActionListener listener) {
        this.jButtonClearUniqueList.addActionListener(listener);
    }

    public void clearEmailSettings() {
        this.setSMTPHostname("");
        this.setEmailLoginName("");
        this.setEmailPassword("");
        this.setEmailTo("");
        this.setEmailFrom("");
        this.setSubject("");
    }

    public void setEmailSettings(SeleniumTestToolData in_appdata) {
        String smtp_hostname = in_appdata.SMTPHostName;
        String login_name = in_appdata.EmailLoginName;
        String password = in_appdata.EmailPassword;
        String to = in_appdata.EmailTo;
        String from = in_appdata.EmailFrom;
        String subject = in_appdata.EmailSubject;
        this.setSMTPHostname(smtp_hostname);
        this.setEmailLoginName(login_name);
        this.setEmailPassword(password);
        this.setEmailTo(to);
        this.setEmailFrom(from);
        this.setSubject(subject);
    }

    public void setGutsViewButtonName(String button_name) {
        this.jButtonGutsView.setText(button_name);
    }

    public String getSMTPHostname() {
        String SMTPHostname = this.jTextFieldSMTPHostName.getText();
        return SMTPHostname;
    }

    public String getEmailLoginName() {
        String EmailLoginName = this.jTextFieldEmailLoginName.getText();
        return EmailLoginName;
    }

    public String getEmailPassword() {
        String Password = "";
        char[] temp = this.jTextFieldEmailPassword.getPassword();
        for (int x = 0; x < temp.length; ++x) {
            Password = Password + temp[x];
        }
        return Password;
    }

    public String getEmailTo() {
        String EmailTo = this.jTextFieldEmailTo.getText();
        return EmailTo;
    }

    public String getEmailFrom() {
        String EmailFrom = this.jTextFieldEmailFrom.getText();
        return EmailFrom;
    }

    public String getSubject() {
        String Subject = this.jTextFieldSubject.getText();
        return Subject;
    }

    public void setSMTPHostname(String SMTPHostName) {
        this.jTextFieldSMTPHostName.setText(SMTPHostName);
    }

    public void setEmailLoginName(String EmailLoginName) {
        this.jTextFieldEmailLoginName.setText(EmailLoginName);
    }

    public void setEmailPassword(String EmailPassword) {
        this.jTextFieldEmailPassword.setText(EmailPassword);
    }

    public void setEmailTo(String EmailPassword) {
        this.jTextFieldEmailTo.setText(EmailPassword);
    }

    public void setEmailFrom(String EmailFrom) {
        this.jTextFieldEmailFrom.setText(EmailFrom);
    }

    public void setSubject(String Subject) {
        this.jTextFieldSubject.setText(Subject);
    }

    public void setExitAfterView(Boolean exitafter) {
        this.jCheckBoxExitAfter.setSelected(exitafter);
        if (exitafter.booleanValue()) {
            this.jCheckBoxShowReport.setSelected(false);
        }
    }

    public void setShowReportView(Boolean showreport) {
        this.jCheckBoxShowReport.setSelected(showreport);
        if (!showreport.booleanValue()) {
            this.jCheckBoxIncludeScreenshots.setEnabled(false);
        } else {
            this.jCheckBoxEmailReportFail.setSelected(false);
            this.jCheckBoxEmailReport.setSelected(false);
            this.jCheckBoxIncludeScreenshots.setEnabled(true);
            this.jCheckBoxExitAfter.setSelected(false);
        }
    }

    public void setjSpinnerEcTimeout(int WaitTime) {
        this.jSpinnerEcTimeout.setValue(WaitTime);
    }

    public void setjSpinnerWaitTime(int WaitTime) {
        this.jSpinnerWaitTime.setValue(WaitTime);
    }

    public void setjSpinnerSessions(int Sessions) {
        this.jSpinnerSessions.setValue(Sessions);
    }

    public void setIncludeScreenshotsView(Boolean includescreenshots) {
        this.jCheckBoxIncludeScreenshots.setSelected(includescreenshots);
    }

    public void setEmailReportView(Boolean emailreport) {
        this.jCheckBoxEmailReport.setSelected(emailreport);
        if (emailreport.booleanValue()) {
            this.jCheckBoxIncludeScreenshots.setEnabled(false);
            this.jCheckBoxShowReport.setSelected(false);
            this.jCheckBoxIncludeScreenshots.setSelected(false);
            this.jCheckBoxIncludeScreenshots.setEnabled(false);
            this.jCheckBoxEmailReportFail.setSelected(false);
        }
    }

    public void setIncludeScreenShotView(Boolean include_screenshots) {
        this.jCheckBoxIncludeScreenshots.setSelected(include_screenshots);
    }

    public void setEmailReportFailView(Boolean emailreportfail) {
        this.jCheckBoxEmailReportFail.setSelected(emailreportfail);
        if (emailreportfail.booleanValue()) {
            this.jCheckBoxIncludeScreenshots.setEnabled(false);
            this.jCheckBoxShowReport.setSelected(false);
            this.jCheckBoxEmailReport.setSelected(false);
        }
    }

    public void setWaitForLoadView(String in_waitForLoad) {
        this.jComboBoxWaitForLoad.setSelectedItem(in_waitForLoad);
    }

    public void setPromptBehaviorView(String in_PromptBehavior) {
        this.jComboBoxPromptBehavior.setSelectedItem(in_PromptBehavior);
    }

    public void setTargetBrowserView(String targetbrowser) {
        if ("Firefox-Marionette".equals(targetbrowser)) {
            targetbrowser = "Firefox";
        }
        this.jComboBoxTargetBrowser.setSelectedItem(targetbrowser);
        switch (targetbrowser) {
            case "Firefox": {
                this.jButtonBrowseForFireFoxExe.setEnabled(true);
                this.setOSTypeActive(true);
                break;
            }
            case "Internet Explorer-32": {
                this.jButtonBrowseForFireFoxExe.setEnabled(false);
                break;
            }
            case "Internet Explorer-64": {
                this.jButtonBrowseForFireFoxExe.setEnabled(false);
                break;
            }
            case "Chrome": {
                this.jButtonBrowseForFireFoxExe.setEnabled(true);
                this.setOSTypeActive(true);
                break;
            }
            case "Chrome 49": {
                this.jButtonBrowseForFireFoxExe.setEnabled(true);
                this.setOSTypeActive(true);
                break;
            }
            case "Silent Mode (HTMLUnit)": {
                this.jButtonBrowseForFireFoxExe.setEnabled(false);
                break;
            }
            default: {
                this.jButtonBrowseForFireFoxExe.setEnabled(false);
                this.setOSTypeActive(true);
            }
        }
    }

    public String getWaitForLoad() {
        return this.jComboBoxWaitForLoad.getSelectedItem().toString();
    }

    public String getPromptBehavior() {
        return this.jComboBoxPromptBehavior.getSelectedItem().toString();
    }

    public String getTargetBrowser() {
        return this.jComboBoxTargetBrowser.getSelectedItem().toString();
    }

    public String getOSType() {
        if (this.jCheckBoxOSTypeWindows32.isSelected()) {
            return "Windows32";
        }
        if (this.jCheckBoxOSTypeWindows64.isSelected()) {
            return "Windows64";
        }
        if (this.jCheckBoxOSTypeMac.isSelected()) {
            return "Mac";
        }
        if (this.jCheckBoxOSTypeLinux32.isSelected()) {
            return "Linux-32";
        }
        if (this.jCheckBoxOSTypeLinux64.isSelected()) {
            return "Linux-64";
        }
        return "Windows32";
    }

    public void setOSTypeView(String OSType2) {
        if ("Windows".equals(OSType2)) {
            OSType2 = "Windows32";
        }
        switch (OSType2) {
            case "Windows": {
                this.jCheckBoxOSTypeWindows32.setSelected(true);
                break;
            }
            case "Windows32": {
                this.jCheckBoxOSTypeWindows32.setSelected(true);
                break;
            }
            case "Windows64": {
                this.jCheckBoxOSTypeWindows64.setSelected(true);
                break;
            }
            case "Mac": {
                this.jCheckBoxOSTypeMac.setSelected(true);
                break;
            }
            case "Linux-32": {
                this.jCheckBoxOSTypeLinux32.setSelected(true);
                break;
            }
            case "Linux-64": {
                this.jCheckBoxOSTypeLinux64.setSelected(true);
            }
        }
    }

    public void setUniqueListView(boolean unique) {
        this.jCheckBoxUniqueURLs.setSelected(unique);
        this.jRadioButtonUniquePerFile.setEnabled(unique);
        this.jRadioButtonUniqueGlobal.setEnabled(unique);
    }

    public boolean getUniqueList() {
        boolean checked = this.jCheckBoxUniqueURLs.isSelected();
        return checked;
    }
}

