/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import browsermator4.com.BMAction;
import browsermator4.com.BrowserMatorReport;
import browsermator4.com.DataLoopVarParser;
import browsermator4.com.DriverFactory;
import browsermator4.com.ListenerTask;
import browsermator4.com.LoudCall;
import browsermator4.com.Procedure;
import browsermator4.com.ProcedureView;
import browsermator4.com.ProgressFrame;
import browsermator4.com.PromptToClose;
import browsermator4.com.SeleniumTestTool;
import browsermator4.com.SeleniumTestToolData;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class RunAllTests
extends SwingWorker<String, Integer> {
    DriverFactory driverFactory;
    SeleniumTestToolData STAppData;
    SeleniumTestTool STAppFrame;
    WebDriver driver;
    BrowserMatorReport BrowserMatorReport;
    Boolean RUNWITHGUI;
    Boolean paused = false;
    Boolean RunAgain = false;
    String BrowsermatorAppFolder;
    ProgressFrame popOutFrame;
    int EcTimeout;

    public RunAllTests(SeleniumTestTool in_STAppFrame, SeleniumTestToolData in_STAppData) {
        this.driverFactory = new DriverFactory(in_STAppData);
        this.STAppData = in_STAppData;
        this.STAppFrame = in_STAppFrame;
        this.STAppFrame.RefreshViewData();
        this.STAppData.RefreshData();
        this.STAppFrame.UpdateDisplay();
        this.RUNWITHGUI = true;
        this.STAppData.cancelled = false;
        this.EcTimeout = 10;
        this.STAppFrame.showTaskGUI();
        this.setProgressListeners();
    }

    public RunAllTests(SeleniumTestToolData in_SiteTest) {
        this.driverFactory = new DriverFactory(in_SiteTest);
        this.BrowsermatorAppFolder = System.getProperty("user.home") + File.separator + "BrowsermatorAppFolder" + File.separator;
        this.STAppData = in_SiteTest;
        this.STAppData.RefreshData();
        this.RUNWITHGUI = false;
        this.STAppData.cancelled = false;
        this.EcTimeout = 10;
        this.popOutFrame = new ProgressFrame(in_SiteTest.short_filename);
        this.setProgressListeners(this.popOutFrame);
    }

    public synchronized void Pause() {
        if (this.RUNWITHGUI.booleanValue()) {
            this.STAppFrame.Pause();
        } else {
            this.popOutFrame.Pause();
        }
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Continue() {
        if (this.RUNWITHGUI.booleanValue()) {
            this.STAppFrame.Continue();
        } else {
            this.popOutFrame.Continue();
        }
        this.paused = false;
        RunAllTests runAllTests = this;
        synchronized (runAllTests) {
            this.notifyAll();
        }
    }

    protected synchronized void waitWhenPaused() {
        while (this.paused.booleanValue()) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public void setProgressListeners() {
        this.STAppFrame.addJButtonCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoudCall<Void, String> procMethod = new LoudCall<Void, String>(){

                    @Override
                    public Void call() throws Exception {
                        this.shoutOut("cancel");
                        Thread.sleep(100L);
                        return null;
                    }
                };
                new ListenerTask<Void, String>((LoudCall)procMethod){

                    @Override
                    protected void process(List<String> chunks) {
                        RunAllTests.this.STAppData.cancelled = true;
                        RunAllTests.this.STAppFrame.jButtonCancel.setText("Cancelling...");
                        RunAllTests.this.STAppFrame.enablejButtonDoStuff(false);
                    }
                }.execute();
            }
        });
        this.STAppFrame.addJButtonContinueActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoudCall<Void, String> procMethod = new LoudCall<Void, String>(){

                    @Override
                    public Void call() throws Exception {
                        this.shoutOut("continue");
                        Thread.sleep(100L);
                        return null;
                    }
                };
                new ListenerTask<Void, String>((LoudCall)procMethod){

                    @Override
                    protected void process(List<String> chunks) {
                        RunAllTests.this.Continue();
                    }
                }.execute();
            }
        });
        this.STAppFrame.addJButtonPauseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoudCall<Void, String> procMethod = new LoudCall<Void, String>(){

                    @Override
                    public Void call() throws Exception {
                        this.shoutOut("pause");
                        Thread.sleep(100L);
                        return null;
                    }
                };
                new ListenerTask<Void, String>((LoudCall)procMethod){

                    @Override
                    protected void process(List<String> chunks) {
                        RunAllTests.this.Pause();
                    }
                }.execute();
            }
        });
    }

    public void setProgressListeners(ProgressFrame popFrame) {
        popFrame.initFrame();
        popFrame.addJButtonCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoudCall<Void, String> procMethod = new LoudCall<Void, String>(){

                    @Override
                    public Void call() throws Exception {
                        this.shoutOut("cancel");
                        Thread.sleep(100L);
                        return null;
                    }
                };
                new ListenerTask<Void, String>((LoudCall)procMethod){

                    @Override
                    protected void process(List<String> chunks) {
                        RunAllTests.this.STAppData.cancelled = true;
                        RunAllTests.this.popOutFrame.jButtonCancel.setText("Cancelling...");
                    }
                }.execute();
            }
        });
        popFrame.addJButtonContinueActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoudCall<Void, String> procMethod = new LoudCall<Void, String>(){

                    @Override
                    public Void call() throws Exception {
                        this.shoutOut("continue");
                        Thread.sleep(100L);
                        return null;
                    }
                };
                new ListenerTask<Void, String>((LoudCall)procMethod){

                    @Override
                    protected void process(List<String> chunks) {
                        RunAllTests.this.Continue();
                    }
                }.execute();
            }
        });
        popFrame.addJButtonPauseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoudCall<Void, String> procMethod = new LoudCall<Void, String>(){

                    @Override
                    public Void call() throws Exception {
                        this.shoutOut("pause");
                        Thread.sleep(100L);
                        return null;
                    }
                };
                new ListenerTask<Void, String>((LoudCall)procMethod){

                    @Override
                    protected void process(List<String> chunks) {
                        RunAllTests.this.Pause();
                    }
                }.execute();
            }
        });
    }

    @Override
    public String doInBackground() {
        String ret_val = "";
        if (this.RUNWITHGUI.booleanValue()) {
            this.STAppFrame.clearPassFailColors();
            this.STAppFrame.disableAdds();
            this.STAppFrame.disableRemoves();
            this.STAppFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.STAppFrame.setRunButtonEnabled(false);
        }
        if (this.STAppData.hasSentStoredVars) {
            this.STAppData.PromptForUserVarValues();
        }
        this.STAppData.testRunning = true;
        if (this.RUNWITHGUI.booleanValue()) {
            for (ProcedureView thisbugview : this.STAppFrame.BugViewArray) {
                thisbugview.JLabelPass.setVisible(false);
            }
        }
        this.RunAllActions(this.STAppFrame, this.STAppData);
        ret_val = "Run All Procedures";
        return ret_val;
    }

    @Override
    protected void done() {
        if (this.RUNWITHGUI.booleanValue()) {
            this.STAppData.setSMTPHostname(this.STAppFrame.getSMTPHostname());
            this.STAppData.setEmailLoginName(this.STAppFrame.getEmailLoginName());
            this.STAppData.setEmailPassword(this.STAppFrame.getEmailPassword());
            this.STAppData.setEmailTo(this.STAppFrame.getEmailTo());
            this.STAppData.setEmailFrom(this.STAppFrame.getEmailFrom());
            this.STAppData.setSubject(this.STAppFrame.getSubject());
            if (this.STAppFrame.getjCheckBoxUniqueURLsSelected()) {
                this.STAppFrame.jButtonClearUniqueList.setEnabled(true);
            }
            this.STAppFrame.enablejButtonDoStuff(true);
            this.STAppFrame.enableAdds();
            this.STAppFrame.enableRemoves();
            this.STAppFrame.hideTaskGUI();
            this.STAppFrame.resetRunButtons();
            this.STAppFrame.setJTextFieldProgress("");
            this.STAppFrame.jButtonCancel.setText("Cancel");
        } else {
            this.popOutFrame.mainFrame.dispose();
        }
        this.STAppData.testRunning = false;
        if (this.RUNWITHGUI.booleanValue()) {
            try {
                this.STAppFrame.setCursor(Cursor.getDefaultCursor());
                this.STAppFrame.setRunButtonEnabled(true);
            }
            catch (Exception ex) {
                System.out.println("exception setting cursor: " + ex.toString());
                this.STAppFrame.setRunButtonEnabled(true);
            }
        }
        try {
            if (this.driver != null) {
                this.driver.quit();
            }
        }
        catch (Exception ex) {
            System.out.println("Exception when quitting driver: " + ex.toString());
        }
        this.FillReport();
        if (this.STAppData.getExitAfter()) {
            System.exit(0);
        }
        this.BrowserMatorReport = new BrowserMatorReport(this.STAppData);
        if (this.STAppData.getShowReport()) {
            if (this.STAppData.getIncludeScreenshots()) {
                this.BrowserMatorReport.ShowHTMLReport();
            } else {
                this.BrowserMatorReport.ShowTextReport();
            }
        }
        if (this.STAppData.getEmailReportFail() && !this.STAppData.AllTestsPassed.booleanValue()) {
            this.BrowserMatorReport.EmailReport();
        }
        if (this.STAppData.getEmailReport()) {
            this.BrowserMatorReport.EmailReport();
        }
        if (this.STAppFrame == null) {
            System.exit(0);
        }
        if (this.STAppData.getExitAfter()) {
            System.exit(0);
        }
    }

    @Override
    protected void process(List<Integer> bugindex) {
        if (this.RUNWITHGUI.booleanValue()) {
            this.STAppFrame.BugViewArray.get((int)bugindex.get((int)0).intValue()).JButtonRunTest.setText("Run");
            if (this.STAppData.BugArray.get((int)bugindex.get((int)0).intValue()).Pass.booleanValue()) {
                this.STAppFrame.BugViewArray.get((int)bugindex.get((int)0).intValue()).JLabelPass.setBackground(Color.GREEN);
                this.STAppFrame.BugViewArray.get((int)bugindex.get((int)0).intValue()).JLabelPass.setText("Passed");
                this.STAppFrame.BugViewArray.get((int)bugindex.get((int)0).intValue()).JLabelPass.setVisible(true);
            } else {
                this.STAppFrame.BugViewArray.get((int)bugindex.get((int)0).intValue()).JLabelPass.setBackground(Color.RED);
                this.STAppFrame.BugViewArray.get((int)bugindex.get((int)0).intValue()).JLabelPass.setText("Failed");
                this.STAppFrame.BugViewArray.get((int)bugindex.get((int)0).intValue()).JLabelPass.setVisible(true);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void RunAllActions(final SeleniumTestTool STAppFrame, final SeleniumTestToolData STAppData) {
        this.driver = this.driverFactory.buildDriver();
        STAppData.TimeOfRun = LocalDateTime.now();
        STAppData.initVarLists();
        WaitTime = 0;
        ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        defaultScreen = ge.getDefaultScreenDevice();
        graphicsConfigurationBounds = ge.getMaximumWindowBounds();
        desiredWidth = graphicsConfigurationBounds.width - 400;
        desiredHeight = graphicsConfigurationBounds.height;
        this.driver.manage().window().setPosition(new Point(0, 0));
        this.driver.manage().window().setSize(new Dimension(desiredWidth, desiredHeight));
        WaitTime = STAppData.getWaitTime();
        this.EcTimeout = STAppData.getEcTimeout();
        totalpause = WaitTime * 1000;
        thisbugindex = 0;
        for (Procedure thisbug : STAppData.BugArray) {
            block112: {
                block111: {
                    bugtitle = STAppData.BugArray.get(thisbugindex).getBugTitle();
                    if (this.RUNWITHGUI.booleanValue()) {
                        procMethod /* !! */  = new LoudCall<Void, String>(){

                            @Override
                            public Void call() throws Exception {
                                this.shoutOut(bugtitle);
                                Thread.sleep(100L);
                                return null;
                            }
                        };
                        new ListenerTask<Void, String>((LoudCall)procMethod /* !! */ ){

                            @Override
                            protected void process(List<String> chunks) {
                                STAppFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                            }
                        }.execute();
                        STAppFrame.BugViewArray.get((int)thisbugindex).JButtonRunTest.setText("Running...");
                    } else {
                        procMethod /* !! */  = new LoudCall<Void, String>(){

                            @Override
                            public Void call() throws Exception {
                                this.shoutOut(bugtitle);
                                Thread.sleep(100L);
                                return null;
                            }
                        };
                        new ListenerTask<Void, String>((LoudCall)procMethod /* !! */ ){

                            @Override
                            protected void process(List<String> chunks) {
                                RunAllTests.this.popOutFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                            }
                        }.execute();
                    }
                    bug_INT = thisbugindex + 1;
                    bug_ID = Integer.toString(bug_INT);
                    action_INT = 0;
                    action_ID = "";
                    if ("Dataloop".equals(thisbug.Type)) break block111;
                    action_INT = 0;
                    for (Object ThisAction : thisbug.ActionsList) {
                        if (STAppData.cancelled) {
                            this.publish(new Integer[]{thisbugindex});
                            break;
                        }
                        this.waitWhenPaused();
                        action_ID = Integer.toString(++action_INT);
                        if (!ThisAction.Locked.booleanValue()) {
                            ThisAction.setEcTimeout(this.EcTimeout);
                            if (this.RUNWITHGUI.booleanValue()) {
                                action_title = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                actMethod /* !! */  = new LoudCall<Void, String>(){

                                    @Override
                                    public Void call() throws Exception {
                                        this.shoutOut(action_title);
                                        Thread.sleep(100L);
                                        return null;
                                    }
                                };
                                new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                    @Override
                                    protected void process(List<String> chunks) {
                                        if (chunks.size() > 0) {
                                            STAppFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                        }
                                    }
                                }.execute();
                            } else {
                                action_title = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                actMethod /* !! */  = new LoudCall<Void, String>(){

                                    @Override
                                    public Void call() throws Exception {
                                        this.shoutOut(action_title);
                                        Thread.sleep(100L);
                                        return null;
                                    }
                                };
                                new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                    @Override
                                    protected void process(List<String> chunks) {
                                        if (chunks.size() > 0) {
                                            RunAllTests.this.popOutFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                        }
                                    }
                                }.execute();
                            }
                            if (totalpause > 0) {
                                try {
                                    Thread.sleep(totalpause);
                                }
                                catch (Exception ex) {
                                    System.out.println("Exception when sleeping: " + ex.toString());
                                    ThisAction.Pass = false;
                                    if (!this.RUNWITHGUI.booleanValue()) break;
                                    thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                                    thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.Pass);
                                    this.publish(new Integer[]{thisbugindex});
                                    break;
                                }
                            }
                            varfieldname = "";
                            if (ThisAction.Variable2.contains("[stored_varname-start]") || ThisAction.Variable1.contains("[stored_varname-start]")) {
                                if (ThisAction.Variable2.contains("[stored_varname-start]")) {
                                    varfieldname = ThisAction.Variable2;
                                    split_testfield_end = varfieldname.split("\\[stored_varname\\-end\\]");
                                    fieldname = split_testfield_end[0].substring(22);
                                    ThisAction.Variable2 = STAppData.GetStoredVariableValue(fieldname);
                                    ThisAction.RunAction(this.driver);
                                    ThisAction.Variable2 = "[stored_varname-start]" + fieldname + "[stored_varname-end]";
                                } else if (ThisAction.Variable1.contains("[stored_varname-start]")) {
                                    varfieldname = ThisAction.Variable1;
                                    split_testfield_end = varfieldname.split("\\[stored_varname\\-end\\]");
                                    fieldname = split_testfield_end[0].substring(22);
                                    ThisAction.Variable1 = STAppData.GetStoredVariableValue(fieldname);
                                    ThisAction.RunAction(this.driver);
                                    ThisAction.Variable1 = "[stored_varname-start]" + fieldname + "[stored_varname-end]";
                                }
                            } else {
                                if ("Pause with Continue Button".equals(ThisAction.Type)) {
                                    split_testfield_end = ThisAction.RunAction(this.driver, "Actions Paused...", STAppData, 0, 0);
                                } else if ("Switch Driver".equals(ThisAction.Type)) {
                                    ThisAction.RunAction(this);
                                } else {
                                    ThisAction.RunAction(this.driver);
                                }
                                if (this.RUNWITHGUI.booleanValue()) {
                                    thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                                    thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.Pass);
                                }
                            }
                            if (!"".equals(ThisAction.tostore_varvalue)) {
                                STAppData.VarHashMap.put(ThisAction.tostore_varname, ThisAction.tostore_varvalue);
                            }
                            if (ThisAction.tostore_varlist.size() > 0) {
                                STAppData.VarLists.put(ThisAction.Variable2, ThisAction.tostore_varlist);
                            }
                            if (STAppData.getIncludeScreenshots()) {
                                try {
                                    full_scrn = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
                                    full_scrn.deleteOnExit();
                                    ThisAction.ScreenshotBase64 = "<img src=\"file:///" + full_scrn.getAbsolutePath() + "\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\" style = \"display: none;\" class = \"report_screenshots\"></img>";
                                }
                                catch (Exception ex) {
                                    ThisAction.ScreenshotBase64 = "Screenshot Failed";
                                }
                            } else {
                                ThisAction.ScreenshotBase64 = "";
                            }
                        } else {
                            ThisAction.ScreenshotBase64 = "";
                            ThisAction.Pass = true;
                        }
                        if (!this.RUNWITHGUI.booleanValue()) continue;
                        thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                        thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.Pass);
                    }
                    actionspassed = 0;
                    ThisAction = thisbug.ActionsList.iterator();
                    while (ThisAction.hasNext()) {
                        thisaction = (BMAction)ThisAction.next();
                        passvalue = thisaction.Pass;
                        if (!passvalue.booleanValue()) continue;
                        ++actionspassed;
                    }
                    sizeof = thisbug.ActionsList.size();
                    thisbug.Pass = actionspassed == sizeof ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    break block112;
                }
                number_of_rows = 0;
                if ("urllist".equals(thisbug.DataLoopSource)) {
                    if (thisbug.getLimit() > 0 || thisbug.getRandom()) {
                        if (thisbug.URLListName.equals("MASTER")) {
                            masterList = new ArrayList<String>();
                            for (List<String> thisList : STAppData.VarLists.values()) {
                                for (String thisString : thisList) {
                                    masterList.add(thisString);
                                }
                            }
                            STAppData.VarLists.put("MASTER", masterList);
                        }
                        thisbug.setURListRunTimeData(STAppData.RandomizeAndLimitURLList(thisbug.URLListName, thisbug.getLimit(), thisbug.getRandom()), thisbug.URLListName);
                    } else {
                        if (thisbug.URLListName.equals("MASTER")) {
                            masterList = new ArrayList<String>();
                            for (List<String> thisList : STAppData.VarLists.values()) {
                                for (String thisString : thisList) {
                                    masterList.add(thisString);
                                }
                            }
                            STAppData.VarLists.put("MASTER", masterList);
                        }
                        thisbug.setURListRunTimeData(STAppData.VarLists.get(thisbug.URLListName), thisbug.URLListName);
                    }
                    if (thisbug.URLListRunTimeEntries != null) {
                        number_of_rows = thisbug.URLListRunTimeEntries.size();
                    }
                    if (this.RUNWITHGUI.booleanValue() && number_of_rows > 0) {
                        thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                        thisbugview.setJTableSourceToURLList(thisbug.URLListRunTimeEntries, thisbug.URLListName);
                    }
                } else if ("file".equals(thisbug.DataLoopSource)) {
                    if (thisbug.getLimit() > 0 || thisbug.getRandom()) {
                        if (STAppData.getDataSetByFileName(thisbug.DataFile).size() > 0) {
                            randomList = STAppData.RandomizeAndLimitFileList(STAppData.getDataSetByFileName(thisbug.DataFile), thisbug.getLimit(), thisbug.getRandom());
                            thisbug.setRunTimeFileSet(randomList);
                        }
                    } else {
                        thisbug.setRunTimeFileSet(STAppData.getDataSetByFileName(thisbug.DataFile));
                    }
                    number_of_rows = thisbug.RunTimeFileSet.size();
                }
                for (BMAction ThisAction : thisbug.ActionsList) {
                    ThisAction.InitializeLoopTestVars(number_of_rows);
                }
                for (x = 0; x < number_of_rows; ++x) {
                    changex = -1;
                    action_INT = 0;
                    for (BMAction ThisAction : thisbug.ActionsList) {
                        block110: {
                            if (STAppData.cancelled) {
                                this.publish(new Integer[]{thisbugindex});
                                break;
                            }
                            this.waitWhenPaused();
                            action_ID = Integer.toString(++action_INT) + "-" + Integer.toString(x);
                            original_value1 = ThisAction.Variable1;
                            original_value2 = ThisAction.Variable2;
                            if (ThisAction.Locked.booleanValue()) ** GOTO lbl354
                            ThisAction.setEcTimeout(this.EcTimeout);
                            var1Parser = new DataLoopVarParser(ThisAction.Variable1);
                            var2Parser = new DataLoopVarParser(ThisAction.Variable2);
                            if (!var1Parser.hasDataLoopVar.booleanValue() && !var2Parser.hasDataLoopVar.booleanValue()) {
                                if ("Pause with Continue Button".equals(ThisAction.Type)) {
                                    pause_message = "Paused at record " + (x + 1) + " of " + number_of_rows;
                                    changex = ThisAction.RunAction(this.driver, pause_message, STAppData, x, number_of_rows);
                                    ThisAction.loop_pass_values.set(x, ThisAction.Pass);
                                    ThisAction.loop_time_of_test.set(x, ThisAction.TimeOfTest);
                                    if (STAppData.getIncludeScreenshots()) {
                                        ThisAction.loop_ScreenshotsBase64.set(x, "<img id = \"Screenshot" + bug_ID + "-" + action_ID + "\" class = \"report_screenshots\" style = \"display: none;\" src=\"\"></img>");
                                    } else {
                                        ThisAction.loop_ScreenshotsBase64.set(x, "");
                                    }
                                } else {
                                    try {
                                        if (totalpause > 0) {
                                            try {
                                                Thread.sleep(totalpause);
                                            }
                                            catch (Exception ex) {
                                                System.out.println("Exception when sleeping: " + ex.toString());
                                                ThisAction.Pass = false;
                                                this.publish(new Integer[]{thisbugindex});
                                                if (!this.RUNWITHGUI.booleanValue()) break;
                                                thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                                                thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.Pass);
                                                break;
                                            }
                                        }
                                        varfieldname = "";
                                        if (ThisAction.Variable2.contains("[stored_varname-start]") || ThisAction.Variable1.contains("[stored_varname-start]")) {
                                            if (ThisAction.Variable2.contains("[stored_varname-start]")) {
                                                varfieldname = ThisAction.Variable1;
                                                split_testfield_end = varfieldname.split("\\[stored_varname\\-end\\]");
                                                fieldname = split_testfield_end[0].substring(22);
                                                ThisAction.Variable2 = STAppData.GetStoredVariableValue(fieldname);
                                                action_title3 = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                                if (this.RUNWITHGUI.booleanValue()) {
                                                    actMethod /* !! */  = new LoudCall<Void, String>(){

                                                        @Override
                                                        public Void call() throws Exception {
                                                            this.shoutOut(action_title3);
                                                            Thread.sleep(100L);
                                                            return null;
                                                        }
                                                    };
                                                    new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                                        @Override
                                                        protected void process(List<String> chunks) {
                                                            if (chunks.size() > 0) {
                                                                STAppFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                            }
                                                        }
                                                    }.execute();
                                                } else {
                                                    actMethod /* !! */  = new LoudCall<Void, String>(){

                                                        @Override
                                                        public Void call() throws Exception {
                                                            this.shoutOut(action_title3);
                                                            Thread.sleep(100L);
                                                            return null;
                                                        }
                                                    };
                                                    new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                                        @Override
                                                        protected void process(List<String> chunks) {
                                                            if (chunks.size() > 0) {
                                                                RunAllTests.this.popOutFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                            }
                                                        }
                                                    }.execute();
                                                }
                                                ThisAction.RunAction(this.driver);
                                                ThisAction.Variable2 = "[stored_varname-start]" + fieldname + "[stored_varname-end]";
                                            } else if (ThisAction.Variable1.contains("[stored_varname-start]")) {
                                                varfieldname = ThisAction.Variable1;
                                                split_testfield_end = varfieldname.split("\\[stored_varname\\-end\\]");
                                                fieldname = split_testfield_end[0].substring(22);
                                                ThisAction.Variable1 = STAppData.GetStoredVariableValue(fieldname);
                                                if (this.RUNWITHGUI.booleanValue()) {
                                                    action_title2 = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                                    actMethod /* !! */  = new LoudCall<Void, String>(){

                                                        @Override
                                                        public Void call() throws Exception {
                                                            this.shoutOut(action_title2);
                                                            Thread.sleep(100L);
                                                            return null;
                                                        }
                                                    };
                                                    new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                                        @Override
                                                        protected void process(List<String> chunks) {
                                                            if (chunks.size() > 0) {
                                                                STAppFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                            }
                                                        }
                                                    }.execute();
                                                } else {
                                                    action_title2 = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                                    actMethod /* !! */  = new LoudCall<Void, String>(){

                                                        @Override
                                                        public Void call() throws Exception {
                                                            this.shoutOut(action_title2);
                                                            Thread.sleep(100L);
                                                            return null;
                                                        }
                                                    };
                                                    new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                                        @Override
                                                        protected void process(List<String> chunks) {
                                                            if (chunks.size() > 0) {
                                                                RunAllTests.this.popOutFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                            }
                                                        }
                                                    }.execute();
                                                }
                                                ThisAction.RunAction(this.driver);
                                                ThisAction.Variable1 = "[stored_varname-start]" + fieldname + "[stored_varname-end]";
                                            }
                                        } else {
                                            if (this.RUNWITHGUI.booleanValue()) {
                                                action_title = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                                actMethod /* !! */  = new LoudCall<Void, String>(){

                                                    @Override
                                                    public Void call() throws Exception {
                                                        this.shoutOut(action_title);
                                                        Thread.sleep(100L);
                                                        return null;
                                                    }
                                                };
                                                new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                                    @Override
                                                    protected void process(List<String> chunks) {
                                                        if (chunks.size() > 0) {
                                                            STAppFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                        }
                                                    }
                                                }.execute();
                                            } else {
                                                action_title = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                                actMethod /* !! */  = new LoudCall<Void, String>(){

                                                    @Override
                                                    public Void call() throws Exception {
                                                        this.shoutOut(action_title);
                                                        Thread.sleep(100L);
                                                        return null;
                                                    }
                                                };
                                                new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                                    @Override
                                                    protected void process(List<String> chunks) {
                                                        if (chunks.size() > 0) {
                                                            RunAllTests.this.popOutFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                        }
                                                    }
                                                }.execute();
                                            }
                                            ThisAction.RunAction(this.driver);
                                        }
                                        if (!"".equals(ThisAction.tostore_varvalue)) {
                                            STAppData.VarHashMap.put(ThisAction.tostore_varname, ThisAction.tostore_varvalue);
                                        }
                                        ThisAction.loop_pass_values.set(x, ThisAction.Pass);
                                        ThisAction.loop_time_of_test.set(x, ThisAction.TimeOfTest);
                                    }
                                    catch (Exception ex) {
                                        ThisAction.loop_pass_values.set(x, false);
                                        ThisAction.loop_time_of_test.set(x, LocalDateTime.now());
                                        if (!this.RUNWITHGUI.booleanValue()) break;
                                        this.publish(new Integer[]{thisbugindex});
                                        thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                                        thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.loop_pass_values.get(x));
                                        break;
                                    }
                                    if (STAppData.getIncludeScreenshots()) {
                                        try {
                                            full_scrn = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
                                            full_scrn.deleteOnExit();
                                            ThisAction.loop_ScreenshotsBase64.set(x, "<img src=\"file:///" + full_scrn.getAbsolutePath() + "\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\" style = \"display: none;\" class = \"report_screenshots\"></img>");
                                        }
                                        catch (Exception ex) {
                                            ThisAction.loop_ScreenshotsBase64.set(x, "Screenshot Failed");
                                        }
                                    } else {
                                        ThisAction.loop_ScreenshotsBase64.set(x, "");
                                    }
                                }
                            } else {
                                concat_variable = "";
                                concat_variable2 = "";
                                if ("urllist".equals(thisbug.DataLoopSource)) {
                                    concat_variable = var1Parser.GetFullValueFromURLList(x, thisbug.URLListRunTimeEntries);
                                }
                                if ("file".equals(thisbug.DataLoopSource)) {
                                    concat_variable = var1Parser.GetFullValueFromFile(x, thisbug.RunTimeFileSet);
                                }
                                if (var1Parser.hasDataLoopVar.booleanValue()) {
                                    ThisAction.Variable1 = concat_variable;
                                    if ("".equals(ThisAction.Variable1)) {
                                        ThisAction.Variable1 = " ";
                                    }
                                }
                                if ("urllist".equals(thisbug.DataLoopSource)) {
                                    concat_variable2 = var2Parser.GetFullValueFromURLList(x, thisbug.URLListRunTimeEntries);
                                }
                                if ("file".equals(thisbug.DataLoopSource)) {
                                    concat_variable2 = var2Parser.GetFullValueFromFile(x, thisbug.RunTimeFileSet);
                                }
                                if (var2Parser.hasDataLoopVar.booleanValue()) {
                                    ThisAction.Variable2 = concat_variable2;
                                    if ("".equals(ThisAction.Variable2)) {
                                        ThisAction.Variable2 = " ";
                                    }
                                }
                                try {
                                    if (totalpause > 0) {
                                        try {
                                            Thread.sleep(totalpause);
                                        }
                                        catch (Exception ex) {
                                            System.out.println("Exception when sleeping: " + ex.toString());
                                            ThisAction.Pass = false;
                                            if (!this.RUNWITHGUI.booleanValue()) break;
                                            this.publish(new Integer[]{thisbugindex});
                                            thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                                            thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.loop_pass_values.get(x));
                                            break;
                                        }
                                    }
                                    if (this.RUNWITHGUI.booleanValue()) {
                                        action_title = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                        actMethod /* !! */  = new LoudCall<Void, String>(){

                                            @Override
                                            public Void call() throws Exception {
                                                this.shoutOut(action_title);
                                                Thread.sleep(100L);
                                                return null;
                                            }
                                        };
                                        new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                            @Override
                                            protected void process(List<String> chunks) {
                                                if (chunks.size() > 0) {
                                                    STAppFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                }
                                            }
                                        }.execute();
                                    } else {
                                        action_title = ThisAction.Type + ": " + ThisAction.Variable1 + " " + ThisAction.Variable2;
                                        actMethod /* !! */  = new LoudCall<Void, String>(){

                                            @Override
                                            public Void call() throws Exception {
                                                this.shoutOut(action_title);
                                                Thread.sleep(100L);
                                                return null;
                                            }
                                        };
                                        new ListenerTask<Void, String>((LoudCall)actMethod /* !! */ ){

                                            @Override
                                            protected void process(List<String> chunks) {
                                                if (chunks.size() > 0) {
                                                    RunAllTests.this.popOutFrame.setJTextFieldProgress(chunks.get(chunks.size() - 1));
                                                }
                                            }
                                        }.execute();
                                    }
                                    ThisAction.RunAction(this.driver);
                                    ThisAction.Variable1 = original_value1;
                                    ThisAction.Variable2 = original_value2;
                                    ThisAction.loop_pass_values.set(x, ThisAction.Pass);
                                    ThisAction.loop_time_of_test.set(x, ThisAction.TimeOfTest);
                                    if (STAppData.getIncludeScreenshots()) {
                                        try {
                                            full_scrn = (File)((TakesScreenshot)this.driver).getScreenshotAs(OutputType.FILE);
                                            full_scrn.deleteOnExit();
                                            ThisAction.loop_ScreenshotsBase64.set(x, "<img src=\"file:///" + full_scrn.getAbsolutePath() + "\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\" style = \"display: none;\" class = \"report_screenshots\"></img>");
                                        }
                                        catch (Exception ex) {
                                            ThisAction.loop_ScreenshotsBase64.set(x, "Screenshot Failed");
                                        }
                                    } else {
                                        ThisAction.loop_ScreenshotsBase64.set(x, "");
                                    }
                                    break block110;
                                }
                                catch (Exception ex) {
                                    ThisAction.Variable1 = original_value1;
                                    ThisAction.Variable2 = original_value2;
                                    ThisAction.loop_pass_values.set(x, false);
                                    ThisAction.loop_time_of_test.set(x, LocalDateTime.now());
                                    if (!this.RUNWITHGUI.booleanValue()) break;
                                    thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                                    thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.loop_pass_values.get(x));
                                    this.publish(new Integer[]{thisbugindex});
                                    break;
                                }
lbl354:
                                // 1 sources

                                ThisAction.Pass = true;
                                ThisAction.loop_pass_values.set(x, ThisAction.Pass);
                                ThisAction.loop_time_of_test.set(x, ThisAction.TimeOfTest);
                            }
                        }
                        if (!this.RUNWITHGUI.booleanValue()) continue;
                        thisbugview = STAppFrame.BugViewArray.get(thisbugindex);
                        thisbugview.ActionsViewList.get(ThisAction.index).setPassState(ThisAction.loop_pass_values.get(x));
                    }
                    if (changex == x || changex == -1) continue;
                    x = changex - 1;
                }
                actions_passed = 0;
                for (BMAction ThisAction : thisbug.ActionsList) {
                    ThisAction.Pass = false;
                    loop_actions_passed = 0;
                    if (ThisAction.loop_pass_values.size() > 0) {
                        for (Boolean passvalue : ThisAction.loop_pass_values) {
                            if (!passvalue.booleanValue()) continue;
                            ++loop_actions_passed;
                        }
                    }
                    if (loop_actions_passed == ThisAction.loop_pass_values.size()) {
                        ThisAction.Pass = true;
                    }
                    if (!ThisAction.Pass.booleanValue()) continue;
                    ++actions_passed;
                }
                sizeof = thisbug.ActionsList.size();
                thisbug.Pass = actions_passed == sizeof ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            this.publish(new Integer[]{thisbugindex});
            ++thisbugindex;
        }
        if (STAppData.getPromptToClose() && this.driver != null) {
            thisContinuePrompt = new PromptToClose(STAppData.short_filename + " - Prompt to close webdriver", "Close webdriver/browser?");
            thisContinuePrompt.addjButtonRunAgainActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    RunAllTests.this.RunAgain = true;
                    thisContinuePrompt.dispose();
                    try {
                        if (RunAllTests.this.driver != null) {
                            RunAllTests.this.driver.quit();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Exception when quitting driver: " + e.toString());
                    }
                    if (STAppData.getUniqueList()) {
                        String file_option = STAppData.getUniqueFileOption();
                        STAppData.AddURLListToUniqueFile(file_option);
                        STAppData.ClearVisittedURLList();
                    }
                }
            });
            thisContinuePrompt.addjButtonCloseActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    RunAllTests.this.RunAgain = false;
                    thisContinuePrompt.dispose();
                    if (STAppData.getUniqueList()) {
                        String file_option = STAppData.getUniqueFileOption();
                        STAppData.AddURLListToUniqueFile(file_option);
                        STAppData.ClearVisittedURLList();
                    }
                }
            });
            while (thisContinuePrompt.isVisible()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    System.out.println("pause exception: " + e.toString());
                }
            }
            if (this.RunAgain.booleanValue()) {
                this.RunAgain = false;
                if (this.RUNWITHGUI.booleanValue()) {
                    STAppFrame.clearPassFailColors();
                    STAppFrame.disableAdds();
                    STAppFrame.disableRemoves();
                    STAppFrame.setCursor(Cursor.getPredefinedCursor(3));
                    STAppFrame.setRunButtonEnabled(false);
                }
                if (STAppData.hasSentStoredVars) {
                    STAppData.PromptForUserVarValues();
                }
                STAppData.testRunning = true;
                if (this.RUNWITHGUI.booleanValue()) {
                    this.BrowsermatorAppFolder = System.getProperty("user.home") + File.separator + "BrowsermatorAppFolder" + File.separator;
                    STAppFrame.RefreshViewData();
                    STAppData.RefreshData();
                    STAppFrame.UpdateDisplay();
                    this.RUNWITHGUI = true;
                    this.STAppData.cancelled = false;
                    STAppFrame.jButtonCancel.setText("Cancel");
                    STAppFrame.showTaskGUI();
                    this.setProgressListeners();
                } else {
                    this.BrowsermatorAppFolder = System.getProperty("user.home") + File.separator + "BrowsermatorAppFolder" + File.separator;
                    STAppData.RefreshData();
                    this.RUNWITHGUI = false;
                    this.STAppData.cancelled = false;
                    this.popOutFrame.mainFrame.dispose();
                    this.popOutFrame = new ProgressFrame(STAppData.short_filename);
                    this.setProgressListeners(this.popOutFrame);
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception ex) {
                    System.out.println("Exception while sleeping before runagain:" + ex.toString());
                }
                this.RunAllActions(STAppFrame, STAppData);
            }
        }
    }

    public void FillReport() {
        int NumberOfTestsPassed = 0;
        int BugIndex = 0;
        Boolean BugPass = false;
        for (Procedure thisbug : this.STAppData.BugArray) {
            ArrayList<BMAction> ActionsToLoop = thisbug.ActionsList;
            int NumberOfActionsPassed = 0;
            if (!"Dataloop".equals(thisbug.Type)) {
                int ActionIndex = 0;
                for (BMAction TheseActions : ActionsToLoop) {
                    LocalDateTime stringtime;
                    TheseActions.TimeOfTest = stringtime = LocalDateTime.now();
                    boolean TestState = TheseActions.Pass;
                    if (TestState) {
                        ++NumberOfActionsPassed;
                    }
                    ++ActionIndex;
                }
                BugPass = NumberOfActionsPassed == this.STAppData.BugArray.get((int)BugIndex).ActionsList.size() ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else {
                int number_of_rows = 0;
                if ("urllist".equals(thisbug.DataLoopSource) && this.STAppData.BugArray.get((int)BugIndex).URLListRunTimeEntries != null) {
                    number_of_rows = this.STAppData.BugArray.get((int)BugIndex).URLListRunTimeEntries.size();
                }
                if ("file".equals(thisbug.DataLoopSource)) {
                    number_of_rows = this.STAppData.BugArray.get((int)BugIndex).RunTimeFileSet.size();
                }
                if (number_of_rows == 0) {
                    int ActionIndex = 0;
                    for (BMAction TheseActions : ActionsToLoop) {
                        TheseActions.Pass = false;
                        ++ActionIndex;
                    }
                }
                for (int x = 0; x < number_of_rows; ++x) {
                    for (BMAction TheseActions : ActionsToLoop) {
                        LocalDateTime stringtime;
                        TheseActions.TimeOfTest = stringtime = LocalDateTime.now();
                        boolean TestState = TheseActions.loop_pass_values.get(x);
                        if (!TestState) continue;
                        String URL_TO_WRITE = "";
                        if ("Go to URL".equals(TheseActions.Type)) {
                            DataLoopVarParser var1Parser = new DataLoopVarParser(TheseActions.Variable1);
                            if (var1Parser.hasDataLoopVar.booleanValue()) {
                                String concat_variable = "";
                                if ("urllist".equals(thisbug.DataLoopSource)) {
                                    concat_variable = var1Parser.GetFullValueFromURLList(x, thisbug.URLListRunTimeEntries);
                                }
                                if ("file".equals(thisbug.DataLoopSource)) {
                                    concat_variable = var1Parser.GetFullValueFromFile(x, thisbug.RunTimeFileSet);
                                }
                                URL_TO_WRITE = concat_variable;
                                this.STAppData.AddURLToUniqueFileList(URL_TO_WRITE);
                            }
                        }
                        ++NumberOfActionsPassed;
                    }
                }
                BugPass = NumberOfActionsPassed == this.STAppData.BugArray.get((int)BugIndex).ActionsList.size() * number_of_rows ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if (BugPass.equals(true)) {
                ++NumberOfTestsPassed;
            }
            if (this.RUNWITHGUI.booleanValue()) {
                // empty if block
            }
            ++BugIndex;
        }
        if (this.STAppData.getUniqueList()) {
            String file_option = this.STAppData.getUniqueFileOption();
            this.STAppData.AddURLListToUniqueFile(file_option);
            this.STAppData.ClearVisittedURLList();
        }
        this.STAppData.AllTestsPassed = NumberOfTestsPassed == this.STAppData.BugArray.size() ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }
}

