/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class Prompter
extends JFrame
implements ActionListener {
    JButton ContinueButton;
    JButton CancelButton;
    JLabel JLabelJumpTo = new JLabel("Skip to #: ");
    JComboBox JComboBoxJumpToValue;
    Boolean cancelled;
    Boolean hasCancelButton;
    int JumpToRecord = -1;
    int number_of_records = 0;
    JTextArea jTextAreaMessage;
    JLabel jLabelMessage;

    Prompter(String filename, String messagetodisplay, Boolean in_hascancel, int currentrecord, int number_of_records) {
        this.setResizable(true);
        if (number_of_records > 0) {
            this.JComboBoxJumpToValue = new JComboBox();
            for (int x = 0; x < number_of_records; ++x) {
                this.JComboBoxJumpToValue.addItem(x + 1);
            }
            this.JComboBoxJumpToValue.setSelectedItem(currentrecord + 1);
        }
        this.number_of_records = number_of_records;
        this.cancelled = false;
        this.hasCancelButton = in_hascancel;
        this.ContinueButton = new JButton("Continue");
        this.CancelButton = new JButton("Cancel");
        this.setDefaultCloseOperation(0);
        JPanel buttonpanel = new JPanel();
        buttonpanel.add(this.ContinueButton);
        JPanel messagepanel = new JPanel();
        if (this.hasCancelButton.booleanValue()) {
            this.setResizable(false);
            buttonpanel.add(this.CancelButton);
            this.jLabelMessage = new JLabel(messagetodisplay);
            messagepanel.add(this.jLabelMessage);
        } else {
            this.jTextAreaMessage = new JTextArea(messagetodisplay);
            this.jTextAreaMessage.setLineWrap(true);
            this.jTextAreaMessage.setColumns(40);
            messagepanel.add(this.jTextAreaMessage);
        }
        if (this.number_of_records > 0) {
            buttonpanel.add(this.JLabelJumpTo);
            buttonpanel.add(this.JComboBoxJumpToValue);
        }
        JPanel WholePrompt = new JPanel();
        WholePrompt.setLayout(new BorderLayout());
        WholePrompt.add((Component)messagepanel, "Center");
        WholePrompt.add((Component)buttonpanel, "South");
        this.setTitle(filename);
        this.add(WholePrompt);
        this.pack();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice defaultScreen = ge.getDefaultScreenDevice();
        Rectangle rect = defaultScreen.getDefaultConfiguration().getBounds();
        int x = (int)rect.getMaxX() - this.getWidth();
        this.setLocation(x, 0);
        this.setVisible(true);
        this.ContinueButton.addActionListener(this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.ContinueButton) {
            this.ClickedContinue();
        }
    }

    public void ClickedContinue() {
        if (this.number_of_records > 0) {
            this.JumpToRecord = this.JComboBoxJumpToValue.getSelectedIndex();
        }
        this.setVisible(false);
        this.dispose();
    }

    public void addJumpToItemListener(ItemListener listener) {
        this.JComboBoxJumpToValue.addItemListener(listener);
    }

    public void addCancelButtonActionListener(ActionListener listener) {
        this.CancelButton.addActionListener(listener);
    }
}

