/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import browsermator4.com.BrowserMatorConfig;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MainAppFrame
extends JFrame {
    BrowserMatorConfig appConfig;
    Properties newProps = new Properties();
    String filename = "";
    String short_filename = "";
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu editMenu;
    private JMenuItem undoMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem closeMenuItem;
    private JMenu helpMenu;
    private JMenuItem contentsMenuItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem newFileItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem uploadFileToCloudMenuItem;
    private JMenuItem browseCloudMenuItem;
    private JMenuItem importMenuItem;

    public MainAppFrame() {
        super("Browsermator");
    }

    public void addExitMenuActionListener(ActionListener listener) {
        this.exitMenuItem.addActionListener(listener);
    }

    public void addAboutMenuItemActionListener(ActionListener listener) {
        this.aboutMenuItem.addActionListener(listener);
    }

    public void setWindowProps(BrowserMatorConfig _appConfig) {
        this.appConfig = _appConfig;
        this.newProps = this.appConfig.applicationProps;
        int winLocY = Integer.parseInt(this.newProps.getProperty("main_window_locationY", "0"));
        int winLocX = Integer.parseInt(this.newProps.getProperty("main_window_locationX", "0"));
        int winWidth = Integer.parseInt(this.newProps.getProperty("main_window_sizeWidth", "1200"));
        int winHeight = Integer.parseInt(this.newProps.getProperty("main_window_sizeHeight", "802"));
        Point startPosition = new Point(winLocX, winLocY);
        if (MainAppFrame.isLocationInScreenBounds(startPosition)) {
            super.setLocation(startPosition);
            super.setSize(winWidth, winHeight);
        } else {
            int Width = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            int Height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            super.setSize(Width - 300, Height - 300);
            super.setLocation(0, 0);
            super.setExtendedState(super.getExtendedState() | 6);
        }
    }

    public static boolean isLocationInScreenBounds(Point location) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        Rectangle graphicsConfigurationBounds = new Rectangle();
        for (int j = 0; j < graphicsDevices.length; ++j) {
            GraphicsDevice graphicsDevice = graphicsDevices[j];
            graphicsConfigurationBounds.setRect(graphicsDevice.getDefaultConfiguration().getBounds());
            graphicsConfigurationBounds.setRect(graphicsConfigurationBounds.x, graphicsConfigurationBounds.y, graphicsConfigurationBounds.width, graphicsConfigurationBounds.height);
            if (!graphicsConfigurationBounds.contains(location.x, location.y)) continue;
            return true;
        }
        return false;
    }

    public void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.newFileItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.browseCloudMenuItem = new JMenuItem();
        this.uploadFileToCloudMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.importMenuItem = new JMenuItem();
        this.newFileItem.setMnemonic('n');
        this.newFileItem.setText("New");
        this.undoMenuItem.setText("Undo");
        this.openMenuItem.setMnemonic('o');
        this.undoMenuItem.setMnemonic('Z');
        this.openMenuItem.setText("Open");
        this.closeMenuItem.setText("Close");
        this.importMenuItem.setMnemonic('i');
        this.importMenuItem.setText("Import");
        this.editMenu.add(this.undoMenuItem);
        this.fileMenu.add(this.newFileItem);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.add(this.importMenuItem);
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.editMenu.setText("Edit");
        this.saveAsMenuItem.setText("Save As");
        this.saveAsMenuItem.setMnemonic('a');
        this.browseCloudMenuItem.setText("BrowserMator File Cloud");
        this.uploadFileToCloudMenuItem.setText("Upload to BrowserMator Cloud");
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.saveMenuItem.setMnemonic('s');
        this.saveMenuItem.setText("Save");
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.closeMenuItem);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.fileMenu.add(this.exitMenuItem);
        this.saveMenuItem.setMnemonic('s');
        this.saveMenuItem.setText("Save");
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.browseCloudMenuItem);
        this.fileMenu.add(this.uploadFileToCloudMenuItem);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.fileMenu.add(this.exitMenuItem);
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setMnemonic('c');
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    public void setSaveMenuItemEnabled(Boolean enable_it) {
        this.saveMenuItem.setEnabled(enable_it);
    }

    public void addFileMenuCloseActionListener(ActionListener listener) {
        this.closeMenuItem.addActionListener(listener);
    }

    public void addFileMenuNewActionListener(ActionListener listener) {
        this.newFileItem.addActionListener(listener);
    }

    public void addEditMenuUndoActionListener(ActionListener listener) {
        this.undoMenuItem.addActionListener(listener);
    }

    public void addFileMenuSaveActionListener(ActionListener listener) {
        this.saveMenuItem.addActionListener(listener);
    }

    public void addFileMenuSaveAsActionListener(ActionListener listener) {
        this.saveAsMenuItem.addActionListener(listener);
    }

    public void addFileMenuBrowseCloudMenuItemActionListener(ActionListener listener) {
        this.browseCloudMenuItem.addActionListener(listener);
    }

    public void addFileMenuuploadFileToCloudMenuItemActionListener(ActionListener listener) {
        this.uploadFileToCloudMenuItem.addActionListener(listener);
    }

    public void addFileMenuImportActionListener(ActionListener listener) {
        this.importMenuItem.addActionListener(listener);
    }

    public void addFileMenuOpenActionListener(ActionListener listener) {
        this.openMenuItem.addActionListener(listener);
    }

    public void showMainWindow(boolean visible) {
        this.setVisible(visible);
    }
}

