/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import browsermator4.com.ActionView;
import browsermator4.com.BMAction;
import browsermator4.com.MainAppFrame;
import browsermator4.com.Procedure;
import browsermator4.com.ProcedureView;
import browsermator4.com.Protector;
import browsermator4.com.STAppController;
import browsermator4.com.SeleniumTestTool;
import browsermator4.com.SeleniumTestToolData;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportFileThread
extends SwingWorker<String, Integer> {
    File[] files;
    ArrayList<SeleniumTestTool> MDIViewClasses;
    ArrayList<SeleniumTestToolData> MDIDataClasses;
    MainAppFrame mainApp;
    int calling_MDI_Index;
    STAppController mainAppController;
    SeleniumTestTool STAppFrame;
    SeleniumTestToolData STAppData;
    boolean RunIt;

    public ImportFileThread(MainAppFrame in_mainApp, STAppController in_STAppController, File[] files, int calling_MDI_Index) {
        this.mainApp = in_mainApp;
        this.files = files;
        this.calling_MDI_Index = calling_MDI_Index;
        this.mainAppController = in_STAppController;
        this.MDIViewClasses = this.mainAppController.MDIViewClasses;
        this.MDIDataClasses = this.mainAppController.MDIDataClasses;
        this.STAppFrame = this.MDIViewClasses.get(calling_MDI_Index);
        this.STAppData = this.MDIDataClasses.get(calling_MDI_Index);
    }

    @Override
    public String doInBackground() {
        this.mainAppController.MDIViewClasses.get(this.calling_MDI_Index).setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (int fileindex = 0; fileindex < this.files.length; ++fileindex) {
                this.ImportFile(this.files[fileindex], this.calling_MDI_Index);
            }
        }
        catch (Exception ex) {
            System.out.println("error opening file: " + ex.toString());
        }
        return "done";
    }

    @Override
    protected void done() {
        this.mainAppController.MDIViewClasses.get(this.calling_MDI_Index).setCursor(Cursor.getDefaultCursor());
        this.mainAppController.MDIViewClasses.get(this.calling_MDI_Index).UpdateDisplay();
    }

    @Override
    protected void process(List<Integer> bugindex) {
    }

    public void ImportNewWindow(Document doc, int MDI_INDEX) {
        int current_number_of_procedures = this.STAppFrame.BugViewArray.size();
        try {
            NodeList ProcedureList = doc.getElementsByTagName("Procedure");
            boolean hasDataloop = false;
            boolean hasURLList = false;
            for (int i = 0; i < ProcedureList.getLength(); ++i) {
                Procedure newbug = new Procedure();
                ProcedureView newbugview = new ProcedureView();
                Element Procedure2 = (Element)ProcedureList.item(i);
                String ProcType = "Procedure";
                if (Procedure2.hasAttribute("Type")) {
                    ProcType = Procedure2.getAttribute("Type");
                }
                String DataLoopSource = "urllist";
                if (Procedure2.hasAttribute("DataLoopSource")) {
                    DataLoopSource = Procedure2.getAttribute("DataLoopSource");
                }
                if ("Dataloop".equals(ProcType)) {
                    hasDataloop = true;
                    String DataFile = "";
                    if (Procedure2.hasAttribute("DataLoopFile") && (DataFile = Procedure2.getAttribute("DataLoopFile")).contains(File.separator)) {
                        DataLoopSource = "file";
                    }
                    if ("file".equals(DataLoopSource)) {
                        File DataFile_file = new File(DataFile);
                        this.STAppData.AddNewDataLoopFile(DataFile_file);
                        this.STAppFrame.AddNewDataLoopFileView(DataFile_file);
                    }
                    if ("urllist".equals(DataLoopSource)) {
                        String[] parts = DataFile.split("-");
                        String leftpart = parts[0];
                        String rightpart = "0";
                        if (parts.length > 1) {
                            rightpart = parts[1];
                        }
                        leftpart = !"".equals(leftpart) ? Integer.toString(current_number_of_procedures + Integer.parseInt(leftpart)) : "0";
                        String combinedDataFile = leftpart + "-" + rightpart;
                        this.STAppData.AddNewDataLoopURLList(combinedDataFile);
                        this.STAppFrame.AddNewDataLoopURLListView(combinedDataFile);
                    }
                } else {
                    this.STAppData.AddNewBug();
                    this.STAppFrame.AddNewBugView();
                }
                int last_added_bug_index = this.STAppFrame.BugViewArray.size() - 1;
                newbugview = this.STAppFrame.BugViewArray.get(last_added_bug_index);
                newbugview.populateJComboBoxStoredArrayLists(this.STAppData.VarLists);
                newbug = this.STAppData.BugArray.get(last_added_bug_index);
                this.mainAppController.AddNewHandlers(this.STAppFrame, this.STAppData, newbugview, newbug);
                if (Procedure2.hasAttribute("Random")) {
                    String stRand = Procedure2.getAttribute("Random");
                    Boolean Rand = false;
                    if (stRand.equals("true")) {
                        Rand = true;
                    }
                    newbug.setRandom(Rand);
                    newbugview.setRandom(Rand);
                }
                if (Procedure2.hasAttribute("Limit")) {
                    int limit = Integer.parseInt(Procedure2.getAttribute("Limit"));
                    newbug.setLimit(limit);
                    newbugview.setLimit(limit);
                }
                String BugTitle = "";
                if (Procedure2.hasAttribute("Title")) {
                    BugTitle = Procedure2.getAttribute("Title");
                }
                newbug.setBugTitle(BugTitle);
                newbugview.setBugTitle(BugTitle);
                String BugURL = "";
                if (Procedure2.hasAttribute("URL")) {
                    BugURL = Procedure2.getAttribute("URL");
                }
                newbug.setBugURL(BugURL);
                NodeList ActionsList = Procedure2.getElementsByTagName("Action");
                for (int j = 0; j < ActionsList.getLength(); ++j) {
                    ActionView thisActionViewToAdd;
                    Element Action2 = (Element)ActionsList.item(j);
                    NodeList ActionNodes = Action2.getChildNodes();
                    String thisActionNodeName = "none";
                    String thisActionNodeValue = "none";
                    String Variable1 = "";
                    String Variable2 = "";
                    String LOCKED = "false";
                    String BoolVal1 = "false";
                    String BoolVal2 = "false";
                    String ActionType = "none";
                    String Password = "";
                    Boolean RealBoolVal1 = false;
                    Boolean RealBoolVal2 = false;
                    Boolean boolLOCKED = false;
                    block28: for (int k = 0; k < ActionNodes.getLength(); ++k) {
                        thisActionNodeName = ActionNodes.item(k).getNodeName();
                        thisActionNodeValue = ActionNodes.item(k).getTextContent();
                        switch (thisActionNodeName) {
                            case "Pass": {
                                String ActionPass = thisActionNodeValue;
                                continue block28;
                            }
                            case "ActionIndex": {
                                String ActionIndex = thisActionNodeValue;
                                continue block28;
                            }
                            case "Type": {
                                ActionType = thisActionNodeValue;
                                continue block28;
                            }
                            case "Variable1": {
                                Variable1 = thisActionNodeValue;
                                continue block28;
                            }
                            case "Variable2": {
                                Variable2 = thisActionNodeValue;
                                continue block28;
                            }
                            case "BoolVal1": {
                                BoolVal1 = thisActionNodeValue;
                                if (!BoolVal1.equals("true")) continue block28;
                                RealBoolVal1 = true;
                                continue block28;
                            }
                            case "BoolVal2": {
                                BoolVal2 = thisActionNodeValue;
                                if (!BoolVal2.equals("true")) continue block28;
                                RealBoolVal2 = true;
                                continue block28;
                            }
                            case "LOCKED": {
                                LOCKED = thisActionNodeValue;
                                if (!LOCKED.equals("true")) continue block28;
                                boolLOCKED = true;
                                continue block28;
                            }
                            case "TimeOfTest": {
                                String string = thisActionNodeValue;
                            }
                        }
                    }
                    if (ActionType.contains("Password")) {
                        try {
                            Variable2 = Password = Protector.decrypt(Variable2);
                        }
                        catch (Exception k) {
                            // empty catch block
                        }
                    }
                    newbugview.ActionScrollPane.setViewportView(new JPanel());
                    if (this.mainAppController.NewActionsMaster.ActionHashMap.contains(ActionType)) {
                        BMAction thisActionToAdd = this.mainAppController.NewActionsMaster.CreateAction(ActionType);
                        thisActionViewToAdd = this.mainAppController.NewActionsMaster.CreateActionView(ActionType);
                        thisActionToAdd.SetVars(Variable1, Variable2, Password, RealBoolVal1, RealBoolVal2, boolLOCKED);
                        thisActionViewToAdd.SetVars(Variable1, Variable2, Password, RealBoolVal1, RealBoolVal2, boolLOCKED);
                        thisActionViewToAdd.AddListeners(thisActionToAdd, this.STAppFrame, this.STAppData, newbug, newbugview);
                        thisActionViewToAdd.AddLoopListeners(thisActionToAdd, this.STAppFrame, this.STAppData, newbug, newbugview);
                        this.STAppFrame.AddActionViewToArray(thisActionViewToAdd, newbugview);
                        this.STAppData.AddActionToArray(thisActionToAdd, newbug, newbugview);
                        newbugview.refreshjComboBoxAddAtPosition();
                    }
                    if (!this.mainAppController.NewActionsMaster.PassFailActionHashMap.contains(ActionType)) continue;
                    BMAction thisActionToAdd = this.mainAppController.NewActionsMaster.CreatePassFailAction(ActionType);
                    thisActionViewToAdd = this.mainAppController.NewActionsMaster.CreatePassFailActionView(ActionType);
                    thisActionToAdd.SetVars(Variable1, Variable2, Password, RealBoolVal1, RealBoolVal2, boolLOCKED);
                    thisActionViewToAdd.SetVars(Variable1, Variable2, Password, RealBoolVal1, RealBoolVal2, boolLOCKED);
                    thisActionViewToAdd.AddListeners(thisActionToAdd, this.STAppFrame, this.STAppData, newbug, newbugview);
                    thisActionViewToAdd.AddLoopListeners(thisActionToAdd, this.STAppFrame, this.STAppData, newbug, newbugview);
                    this.STAppFrame.AddActionViewToArray(thisActionViewToAdd, newbugview);
                    this.STAppData.AddActionToArray(thisActionToAdd, newbug, newbugview);
                    newbugview.refreshjComboBoxAddAtPosition();
                }
            }
            if (hasDataloop) {
                this.STAppFrame.setJButtonFlattenFileEnabled(true);
            }
        }
        catch (Exception e) {
            System.out.println("Exception parsing procedure node" + e.toString());
        }
        this.STAppFrame.UpdateDisplay();
        JScrollBar vertical = this.STAppFrame.MainScrollPane.getVerticalScrollBar();
        vertical.setValue(vertical.getMaximum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ImportFile(File file, int MDI_INDEX) {
        if (file.exists()) {
            Document doc = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(file.getAbsolutePath());
                this.ImportNewWindow(doc, MDI_INDEX);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                try {
                    System.out.println("DocumentBuilder error:" + e.toString());
                    this.ImportNewWindow(doc, MDI_INDEX);
                }
                catch (Throwable throwable) {
                    this.ImportNewWindow(doc, MDI_INDEX);
                    this.MDIDataClasses.get((int)MDI_INDEX).changes = true;
                    throw throwable;
                }
                this.MDIDataClasses.get((int)MDI_INDEX).changes = true;
            }
            this.MDIDataClasses.get((int)MDI_INDEX).changes = true;
        }
    }
}

