/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import browsermator4.com.BrowserMatorConfig;
import browsermator4.com.Prompter;
import browsermator4.com.SeleniumTestToolData;
import java.io.File;
import java.util.HashMap;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class DriverFactory {
    WebDriver driver;
    String targetbrowser;
    String WEBDRIVERSDIR;
    String BrowsermatorAppFolder;
    BrowserMatorConfig appConfig = new BrowserMatorConfig();
    String OSType;
    String firefox_path;
    String chrome_path;
    String chrome_main_path;
    PageLoadStrategy PageLoadConstant = PageLoadStrategy.NORMAL;
    UnexpectedAlertBehaviour promptBehaviorConstant = UnexpectedAlertBehaviour.DISMISS;
    String stringPageLoadConstant = "normal";
    String downloadDir = "";
    String waitForLoad;
    String promptBehavior;
    SeleniumTestToolData STAppData;
    HashMap<String, Object> prefs;

    public DriverFactory(SeleniumTestToolData in_STAppData) {
        this.STAppData = in_STAppData;
        this.targetbrowser = this.STAppData.TargetBrowser;
        this.waitForLoad = this.STAppData.waitForLoad;
        this.promptBehavior = this.STAppData.promptBehavior;
        this.OSType = this.STAppData.OSType;
        this.BrowsermatorAppFolder = System.getProperty("user.home") + File.separator + "BrowsermatorAppFolder" + File.separator;
        this.WEBDRIVERSDIR = this.BrowsermatorAppFolder + "Webdrivers" + File.separator;
        this.firefox_path = this.appConfig.getKeyValue("Firefox");
        this.chrome_path = this.appConfig.getKeyValue("Chrome 49");
        this.chrome_main_path = this.appConfig.getKeyValue("Chrome");
        this.downloadDir = this.appConfig.getKeyValue("downloaddir");
        this.firefox_path = this.appConfig.getKeyValue("Firefox");
        this.chrome_path = this.appConfig.getKeyValue("Chrome 49");
        this.chrome_main_path = this.appConfig.getKeyValue("Chrome");
        this.downloadDir = this.appConfig.getKeyValue("downloaddir");
        this.prefs = new HashMap();
        this.targetbrowser = this.STAppData.TargetBrowser;
        this.waitForLoad = this.STAppData.waitForLoad;
        this.OSType = this.STAppData.OSType;
        switch (this.waitForLoad) {
            case "Yes": {
                this.PageLoadConstant = PageLoadStrategy.NORMAL;
                this.stringPageLoadConstant = "normal";
                break;
            }
            case "No": {
                this.PageLoadConstant = PageLoadStrategy.NONE;
                this.stringPageLoadConstant = "none";
                break;
            }
            case "Local DOM Only": {
                this.PageLoadConstant = PageLoadStrategy.EAGER;
                this.stringPageLoadConstant = "eager";
            }
        }
    }

    public WebDriver buildDriver() {
        File thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-win32" + File.separator + "geckodriver.exe");
        System.setProperty("webdriver.chrome.disableBuildCheck", "true");
        switch (this.promptBehavior) {
            case "Dismiss": {
                this.promptBehaviorConstant = UnexpectedAlertBehaviour.DISMISS;
                break;
            }
            case "Accept": {
                this.promptBehaviorConstant = UnexpectedAlertBehaviour.ACCEPT;
                break;
            }
            case "Fail": {
                this.promptBehaviorConstant = UnexpectedAlertBehaviour.IGNORE;
            }
        }
        switch (this.waitForLoad) {
            case "Yes": {
                this.PageLoadConstant = PageLoadStrategy.NORMAL;
                this.stringPageLoadConstant = "normal";
                break;
            }
            case "No": {
                this.PageLoadConstant = PageLoadStrategy.NONE;
                this.stringPageLoadConstant = "none";
                break;
            }
            case "Local DOM Only": {
                this.PageLoadConstant = PageLoadStrategy.EAGER;
                this.stringPageLoadConstant = "eager";
            }
        }
        switch (this.targetbrowser) {
            case "Firefox-Marionette": {
                if ("Windows".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-win32" + File.separator + "geckodriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Windows32".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-win32" + File.separator + "geckodriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Windows64".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-win64" + File.separator + "geckodriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Mac".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-osx" + File.separator + "geckodriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Linux-32".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-linux32" + File.separator + "geckodriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Linux-64".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-linux64" + File.separator + "geckodriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if (this.firefox_path != null) {
                    System.setProperty("webdriver.firefox.bin", this.firefox_path);
                }
                try {
                    FirefoxOptions options = new FirefoxOptions();
                    if (!"".equals(this.downloadDir) && this.downloadDir != null) {
                        FirefoxProfile profile = new FirefoxProfile();
                        profile.setPreference("browser.download.dir", (Object)this.downloadDir);
                        profile.setPreference("browser.download.folderList", (Object)2);
                        profile.setPreference("browser.helperApps.neverAsk.saveToDisk", (Object)"...");
                        options.setProfile(profile);
                    }
                    options.addPreference("dom.webnotifications.enabled", (Object)false);
                    options.setUnhandledPromptBehaviour(this.promptBehaviorConstant);
                    options.setPageLoadStrategy(this.PageLoadConstant);
                    this.driver = new FirefoxDriver(options);
                }
                catch (Exception ex) {
                    System.out.println("Exception launching Marionette driver... browse for Firefox location?: " + ex.toString());
                    Prompter profile = new Prompter("Driver Error", "You may need to set Firefox binary location:" + ex.toString(), false, 0, 0);
                }
                break;
            }
            case "Firefox": {
                if ("Windows".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-win32" + File.separator + "geckodriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Windows32".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-win32" + File.separator + "geckodriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Windows64".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-win64" + File.separator + "geckodriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Mac".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-osx" + File.separator + "geckodriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Linux-32".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-linux32" + File.separator + "geckodriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if ("Linux-64".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "geckodriver-linux64" + File.separator + "geckodriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.gecko.driver", thisDriver.getAbsolutePath());
                }
                if (this.firefox_path != null) {
                    System.setProperty("webdriver.firefox.bin", this.firefox_path);
                }
                try {
                    FirefoxOptions options = new FirefoxOptions();
                    FirefoxProfile profile = new FirefoxProfile();
                    profile.setPreference("app.update.disabledForTesting", (Object)true);
                    if (!"".equals(this.downloadDir) && this.downloadDir != null) {
                        profile.setPreference("browser.download.dir", (Object)this.downloadDir);
                        profile.setPreference("browser.download.folderList", (Object)2);
                        profile.setPreference("browser.helperApps.neverAsk.saveToDisk", (Object)"...");
                        options.setProfile(profile);
                    }
                    options.addPreference("dom.webnotifications.enabled", (Object)false);
                    options.setUnhandledPromptBehaviour(this.promptBehaviorConstant);
                    options.setPageLoadStrategy(this.PageLoadConstant);
                    this.driver = new FirefoxDriver(options);
                }
                catch (Exception ex) {
                    System.out.println("Exception launching geckodriver... You may need to launch browsermator and set path to Firefox: " + ex.toString());
                    Prompter profile = new Prompter("Driver Error", "Could not launch the Firefox driver.  May need to browse for firefox executable: " + ex.toString(), false, 0, 0);
                }
                break;
            }
            case "Silent Mode (HTMLUnit)": {
                try {
                    this.driver = new HtmlUnitDriver();
                }
                catch (Exception ex) {
                    System.out.println("Exception launching HTMLUnit driver... possibly XP or missing msvcr110.dll: " + ex.toString());
                    Prompter profile = new Prompter("Driver Error", "Could not launch the Marionette driver: " + ex.toString(), false, 0, 0);
                }
                break;
            }
            case "Chrome": {
                ChromeOptions options = new ChromeOptions();
                if (this.chrome_main_path != null) {
                    options.setBinary(this.chrome_main_path);
                }
                options.setUnhandledPromptBehaviour(this.promptBehaviorConstant);
                options.setPageLoadStrategy(this.PageLoadConstant);
                options.addArguments(new String[]{"--dns-prefetch-disable"});
                options.addArguments(new String[]{"--remote-allow-origins=*"});
                this.prefs.put("profile.default_content_setting_values.notifications", 2);
                if (!"".equals(this.downloadDir) && this.downloadDir != null) {
                    this.prefs.put("download.default_directory", this.downloadDir);
                }
                options.setExperimentalOption("prefs", this.prefs);
                if ("Windows".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "chromedriver_win32" + File.separator + "chromedriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.chrome.driver", thisDriver.getAbsolutePath());
                }
                if ("Windows32".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "chromedriver_win32" + File.separator + "chromedriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.chrome.driver", thisDriver.getAbsolutePath());
                }
                if ("Windows64".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "chromedriver_win32" + File.separator + "chromedriver.exe");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.chrome.driver", thisDriver.getAbsolutePath());
                }
                if ("Mac".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "chromedriver_mac64" + File.separator + "chromedriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.chrome.driver", thisDriver.getAbsolutePath());
                }
                if ("Linux-32".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "chromedriver_linux32" + File.separator + "chromedriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.chrome.driver", thisDriver.getAbsolutePath());
                }
                if ("Linux-64".equals(this.OSType)) {
                    thisDriver = new File(this.WEBDRIVERSDIR + "chromedriver_linux64" + File.separator + "chromedriver");
                    this.setPermissions(thisDriver);
                    System.setProperty("webdriver.chrome.driver", thisDriver.getAbsolutePath());
                }
                try {
                    this.driver = new ChromeDriver(options);
                }
                catch (Exception ex) {
                    System.out.println("Problem launching Chromedriver: " + ex.toString());
                    Prompter prompter = new Prompter("Driver Error", "Could not launch the Chromedriver. May need to browse for Chrome executable: " + ex.toString(), false, 0, 0);
                }
                break;
            }
            case "Chrome 49": {
                ChromeOptions options49 = new ChromeOptions();
                this.prefs.put("profile.default_content_setting_values.notifications", 2);
                if (this.chrome_path != null) {
                    ChromeOptions chromeOptions = (ChromeOptions)options49.setBinary(this.chrome_path);
                }
                thisDriver = new File(this.WEBDRIVERSDIR + "chromedriver_win32" + File.separator + "chromedriver.exe");
                this.setPermissions(thisDriver);
                System.setProperty("webdriver.chrome.driver", thisDriver.getAbsolutePath());
                try {
                    this.driver = new ChromeDriver(options49);
                }
                catch (Exception ex) {
                    System.out.println("Problem launching Chromedriver 49: " + ex.toString());
                    Prompter prompter = new Prompter("Driver Error", "Could not launch the Chrome 49 driver." + ex.toString(), false, 0, 0);
                }
                break;
            }
            case "Edge": {
                String windir = System.getenv("windir");
                boolean is64bit = false;
                is64bit = System.getenv("ProgramFiles(x86)") != null;
                String edgeDriverPath = windir + "\\SysWOW64\\MicrosoftWebDriver.exe";
                if (!is64bit) {
                    edgeDriverPath = windir + "\\System32\\MicrosoftWebDriver.exe";
                }
                System.setProperty("webdriver.edge.driver", edgeDriverPath);
                EdgeOptions edgeOptions = new EdgeOptions();
                edgeOptions.setPageLoadStrategy(this.PageLoadConstant);
                try {
                    this.driver = new EdgeDriver(edgeOptions);
                    break;
                }
                catch (Exception ex) {
                    System.out.println("Problem launching EdgeDriver: " + ex.toString());
                    Prompter prompter = new Prompter("Driver Error", "Could not launch the Edge Driver. Location: " + edgeDriverPath + " Go to Settings > Update and Security > For Developer and then select Developer mode." + ex.toString(), false, 0, 0);
                }
            }
        }
        return this.driver;
    }

    public void setPermissions(File thisDriver) {
        if (!thisDriver.canExecute()) {
            Prompter cantexecuteprompt = new Prompter("Permissions Error", "The current user does not have permission to run the webdriver.  The Browsermator will attempt to set permissions now.  If this fails, you'll need to manually set permission to execute the following file: " + thisDriver.getAbsolutePath(), false, 0, 0);
            thisDriver.setExecutable(true, true);
        }
    }
}

