/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import browsermator4.com.Base64Encoder;
import browsermator4.com.BrowserMatorConfig;
import browsermator4.com.DataLoopVarParser;
import browsermator4.com.Prompter;
import browsermator4.com.SeleniumTestToolData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Properties;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;

public class BrowserMatorReport {
    JFrame ReportFrame;
    JEditorPane HTMLPane;
    JButton jButtonSaveFile;
    String HTMLReport;
    String HTMLReportForSave;
    String TextReport;
    BorderLayout thisLayout;
    JPanel mainPanel;
    SeleniumTestToolData STAppData;
    String LineBreak;
    String Header;
    String Footer;
    final JFXPanel fxPanel = new JFXPanel();
    WebView browser;
    WebEngine webEngine;
    Stage webStage;
    Boolean ReportDisplayed;
    File TEMP_HTML_FILE;

    public BrowserMatorReport(SeleniumTestToolData SiteTest2) {
        this.STAppData = SiteTest2;
        this.ReportDisplayed = false;
        this.TEMP_HTML_FILE = null;
        this.HTMLReport = "";
        this.TextReport = "";
    }

    public String GetTextReport() {
        this.HTMLReportForSave = this.TextReport = this.OutPutReport(false);
        return this.TextReport;
    }

    public String GetHTMLReport() {
        return this.HTMLReport;
    }

    public void EmailReport() {
        Properties applicationProps = new Properties();
        String login_name = this.STAppData.getEmailLoginName();
        String password = this.STAppData.getEmailPassword();
        String to = this.STAppData.getEmailTo();
        String from = this.STAppData.getEmailFrom();
        String subject = this.STAppData.getEmailSubject();
        subject = this.STAppData.AllTestsPassed.equals(true) ? subject + " - All Procedures PASSED" : subject + " - Some Procedures FAILED";
        applicationProps.put("mail.smtp.port", "587");
        applicationProps.put("mail.smtp.auth", "true");
        applicationProps.put("mail.smtp.starttls.enable", "true");
        applicationProps.put("mail.smtp.host", this.STAppData.getSMTPHostname());
        applicationProps.put("email_login_name", this.STAppData.getEmailLoginName());
        applicationProps.put("email_login_password", this.STAppData.getEmailPassword());
        applicationProps.put("email_to", this.STAppData.getEmailTo());
        applicationProps.put("email_from", this.STAppData.getEmailFrom());
        applicationProps.put("email_subject", this.STAppData.getEmailSubject());
        Session session = Session.getInstance((Properties)applicationProps, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom(from);
            msg.setRecipients(Message.RecipientType.TO, to);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.setText(this.GetTextReport());
            Transport.send((Message)msg, (String)login_name, (String)password);
        }
        catch (MessagingException mex) {
            Prompter prompter = new Prompter("Email Failure", "Sending Email has failed. Check settings: " + mex.toString(), false, 0, 0);
        }
    }

    public void ShowTextReport() {
        final String HTML_TO_SEND = this.GetTextReport();
        this.jButtonSaveFile = new JButton("Save and Open HTML Report");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserMatorReport.this.browser = new WebView();
                BrowserMatorReport.this.webEngine = BrowserMatorReport.this.browser.getEngine();
                BrowserMatorReport.this.webEngine.loadContent(HTML_TO_SEND);
                BrowserMatorReport.this.browser.setVisible(true);
                Scene scene = new Scene((Parent)BrowserMatorReport.this.browser);
                BrowserMatorReport.this.fxPanel.setScene(scene);
            }
        });
        this.fxPanel.setVisible(true);
        this.fxPanel.setSize(900, 920);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.jButtonSaveFile, "North");
        this.mainPanel.add((Component)this.fxPanel, "Center");
        this.mainPanel.setVisible(true);
        this.ReportFrame = new JFrame("Browsermator Report");
        this.jButtonSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserMatorReport.this.SaveAsHTMLFile();
            }
        });
        this.ReportFrame.add(this.mainPanel);
        this.ReportFrame.setSize(910, 920);
        this.ReportFrame.setVisible(true);
        this.ReportDisplayed = true;
    }

    public void ShowHTMLReport() {
        this.HTMLReport = "<HTML><HEAD></HEAD><BODY>Due to a memory problem in JavaFX, you'll need to save the report to view it.  Click the button above to save and open the file.</BODY></HTML>";
        this.jButtonSaveFile = new JButton("Save and Open HTML Report");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserMatorReport.this.HTMLReport != null) {
                    BrowserMatorReport.this.browser = new WebView();
                    BrowserMatorReport.this.webEngine = BrowserMatorReport.this.browser.getEngine();
                    BrowserMatorReport.this.webEngine.loadContent(BrowserMatorReport.this.HTMLReport);
                    BrowserMatorReport.this.browser.setVisible(true);
                    Scene scene = new Scene((Parent)BrowserMatorReport.this.browser);
                    BrowserMatorReport.this.fxPanel.setScene(scene);
                }
            }
        });
        this.fxPanel.setVisible(true);
        this.fxPanel.setSize(900, 920);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)this.jButtonSaveFile, "North");
        this.mainPanel.add((Component)this.fxPanel, "Center");
        this.mainPanel.setVisible(true);
        this.ReportFrame = new JFrame("Browsermator Report");
        this.jButtonSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserMatorReport.this.SaveAsHTMLFile(BrowserMatorReport.this.OutPutHTMLReportForSave());
            }
        });
        this.ReportFrame.add(this.mainPanel);
        this.ReportFrame.setSize(910, 920);
        this.ReportFrame.setVisible(true);
        this.ReportDisplayed = true;
    }

    public void OutPutReports() {
    }

    public String FileToBase64(String ThisScreenshotPath) {
        String Base64String = "";
        Path screen_path = Paths.get(ThisScreenshotPath, new String[0]);
        Base64Encoder enc_resized = new Base64Encoder();
        byte[] screenshot_in_bytes = null;
        try {
            screenshot_in_bytes = Files.readAllBytes(screen_path);
        }
        catch (Exception ex) {
            System.out.println("Exception reading temporary screenshot file: " + ex.toString());
        }
        Base64String = enc_resized.encode(screenshot_in_bytes);
        return Base64String;
    }

    public File OutPutHTMLReportForSave() {
        String ReportText = "<HTML></HTML>";
        this.LineBreak = "<BR>";
        this.Header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><HTML>\n<HEAD>\n<STYLE>#Report { height: 800; overflow-y: auto;}\n #Controls { }\n</STYLE>\n<SCRIPT>\nfunction ShowHideThisScreen(button_id)\n {var buttsize = button_id.length;\n var id_string = button_id.substring(14, buttsize);\n var img_id = \"Screenshot\" + id_string;\n\n var thisimg = document.getElementById(img_id);\n var button = document.getElementById(button_id);\n\n if (thisimg.style.display == \"inline\")\n     {\n         thisimg.style.display = \"none\";\n         button.innerHTML = \"Show Screenshot \" + id_string;\n         \n     }\n     else{\n         thisimg.style.display = \"inline\";\n         button.innerHTML = \"Hide Screenshot \" + id_string;\n     } }\nfunction ShowAllScreens()\n{   var allscreens = document.getElementsByClassName(\"report_screenshots\");\n for (x=0; x<allscreens.length; x++)\n   {\n      allscreens.item(x).style.display = \"inline\";\n      var thisid = allscreens.item(x).id;\n      var idsize = allscreens.item(x).id.length;\n     var id_string = allscreens.item(x).id.substring(10, idsize); \n var button = document.getElementById(\"ShowHideButton\" + id_string);\nbutton.innerHTML = \"Hide Screenshot \" + id_string;  }}\n function HideAllScreens()\n{  var allscreens = document.getElementsByClassName(\"report_screenshots\");\n for (x=0; x<allscreens.length; x++)\n   {\n      var idsize = allscreens.item(x).id.length;\n     var id_string = allscreens.item(x).id.substring(10, idsize);  \n var button = document.getElementById(\"ShowHideButton\" + id_string);\nbutton.innerHTML = \"Show Screenshot \" + id_string;      allscreens.item(x).style.display = \"none\";\n   }}\n</SCRIPT>\n</HEAD>\n<BODY>\n<DIV ID = \"Controls\">\n<BUTTON NAME = \"SHOWALLSCREENS\" ONCLICK=\"ShowAllScreens()\">Show All Screenshots</BUTTON> <BUTTON NAME = \"HIDEALLSCREENS\" ONCLICK=\"HideAllScreens()\">Hide All Screenshots</BUTTON>\n</DIV>\n<DIV ID=\"Report\">\n";
        this.Footer = "</DIV>\n</BODY>\n</HTML>";
        ReportText = "Procedure report: " + this.STAppData.filename + this.STAppData.TimeOfRun.toString() + this.LineBreak;
        int action_INT = 0;
        int bug_INT = 0;
        String bug_ID = "";
        String action_ID = "";
        BufferedWriter writer = null;
        File temp_report_file = null;
        String tempFileName = "report_results";
        try {
            temp_report_file = File.createTempFile(tempFileName, ".htm");
            temp_report_file.deleteOnExit();
            writer = new BufferedWriter(new FileWriter(temp_report_file));
        }
        catch (Exception ex) {
            System.out.println("Exception writing temp file for report: " + ex.toString());
        }
        if (writer != null) {
            try {
                writer.append(this.Header);
                writer.append(this.LineBreak);
                writer.append(ReportText);
            }
            catch (Exception ex) {
                System.out.println("Execpetion appending temp file: " + ex.toString());
            }
        }
        String to_write = "</html>";
        for (int BugIndex = 0; BugIndex < this.STAppData.BugArray.size(); ++BugIndex) {
            bug_INT = BugIndex + 1;
            bug_ID = Integer.toString(bug_INT);
            to_write = "Procedure " + this.STAppData.BugArray.get(BugIndex).getBugTitle() + " " + this.STAppData.BugArray.get(BugIndex).getPassText() + this.LineBreak;
            if (writer != null) {
                try {
                    writer.append(to_write);
                    to_write = "";
                }
                catch (Exception ex) {
                    System.out.println("Execpetion appending temp file: " + ex.toString());
                    to_write = "";
                }
            }
            int number_of_actions = this.STAppData.BugArray.get((int)BugIndex).ActionsList.size();
            int passvalueslength = 0;
            if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)0).loop_pass_values != null) {
                passvalueslength = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)0).loop_pass_values.size();
            }
            if (passvalueslength > 0) {
                for (int passindex = 0; passindex < passvalueslength; ++passindex) {
                    for (int ActionViewIndex = 0; ActionViewIndex < number_of_actions; ++ActionViewIndex) {
                        action_INT = ActionViewIndex + 1;
                        action_ID = Integer.toString(action_INT) + "-" + passindex;
                        if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Locked.booleanValue()) continue;
                        Boolean ThisPassValue = false;
                        LocalDateTime ThisTimeValue = LocalDateTime.now();
                        String ThisType = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type;
                        String ThisValue1 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1;
                        String ThisValue2 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2;
                        String ThisScreenshot = "";
                        String pass_string = " has failed at ";
                        DataLoopVarParser var1Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1);
                        DataLoopVarParser var2Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2);
                        ThisPassValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).loop_pass_values.get(passindex);
                        ThisTimeValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).loop_time_of_test.get(passindex);
                        ThisScreenshot = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).loop_ScreenshotsBase64.get(passindex);
                        int index_of_fileslashes = ThisScreenshot.indexOf("file:///") + 8;
                        int index_of_id = ThisScreenshot.indexOf("id") - 2;
                        if (index_of_fileslashes > 0 && index_of_id > index_of_fileslashes) {
                            ThisScreenshot = ThisScreenshot.substring(index_of_fileslashes, index_of_id);
                            ThisScreenshot = this.FileToBase64(ThisScreenshot);
                        } else {
                            ThisScreenshot = "";
                        }
                        if (!var1Parser.hasDataLoopVar.booleanValue() && !var2Parser.hasDataLoopVar.booleanValue()) {
                            if (ThisPassValue.booleanValue()) {
                                pass_string = " has passed at ";
                            }
                            to_write = to_write + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                            to_write = to_write + this.LineBreak;
                            if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type.contains("assword")) {
                                to_write = bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " ########" + pass_string + ThisTimeValue.toString() + this.LineBreak;
                                to_write = "null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot) ? to_write + this.LineBreak : to_write + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Hide Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + "<img src=\"data:image/png;base64," + ThisScreenshot + "\" style=\"display: inline;\" class = \"report_screenshots\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\"></img>" + this.LineBreak;
                            } else {
                                to_write = bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " " + ThisValue2 + pass_string + ThisTimeValue.toString() + this.LineBreak;
                                to_write = to_write + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                                to_write = to_write + this.LineBreak;
                                to_write = "null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot) ? to_write + this.LineBreak : to_write + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Hide Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + "<img src=\"data:image/png;base64," + ThisScreenshot + "\" style=\"display: inline;\" class = \"report_screenshots\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\"></img>" + this.LineBreak;
                            }
                            if (writer == null) continue;
                            try {
                                writer.append(to_write);
                                to_write = "";
                            }
                            catch (Exception ex) {
                                System.out.println("Execpetion appending temp file: " + ex.toString());
                                to_write = "";
                            }
                            continue;
                        }
                        if (ThisPassValue.booleanValue()) {
                            pass_string = " has passed at ";
                        }
                        to_write = to_write + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                        to_write = to_write + this.LineBreak;
                        String concat_variable = "";
                        String concat_variable2 = "";
                        if ("urllist".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable = var1Parser.GetFullValueFromURLList(passindex, this.STAppData.BugArray.get((int)BugIndex).URLListData);
                        }
                        if ("file".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable = var1Parser.GetFullValueFromFile(passindex, this.STAppData.BugArray.get((int)BugIndex).RunTimeFileSet);
                        }
                        if (!"".equals(concat_variable)) {
                            ThisValue1 = concat_variable;
                        }
                        if ("urllist".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable2 = var2Parser.GetFullValueFromURLList(passindex, this.STAppData.BugArray.get((int)BugIndex).URLListData);
                        }
                        if ("file".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable2 = var2Parser.GetFullValueFromFile(passindex, this.STAppData.BugArray.get((int)BugIndex).RunTimeFileSet);
                        }
                        if (!"".equals(concat_variable2)) {
                            ThisValue2 = concat_variable2;
                        }
                        if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type.contains("assword")) {
                            to_write = bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " ########" + pass_string + ThisTimeValue.toString() + this.LineBreak;
                            to_write = "null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot) ? to_write + this.LineBreak : to_write + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Hide Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + "<img src=\"data:image/png;base64," + ThisScreenshot + "\" style=\"display: inline;\" class = \"report_screenshots\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\"></img>" + this.LineBreak;
                        } else {
                            to_write = bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " " + ThisValue2 + pass_string + ThisTimeValue.toString() + this.LineBreak;
                            to_write = "null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot) ? to_write + this.LineBreak : to_write + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Hide Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + "<img src=\"data:image/png;base64," + ThisScreenshot + "\" style=\"display: inline;\" class = \"report_screenshots\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\"></img>" + this.LineBreak;
                        }
                        if (writer == null) continue;
                        try {
                            writer.append(to_write);
                            to_write = "";
                            continue;
                        }
                        catch (Exception ex) {
                            System.out.println("Execpetion appending temp file: " + ex.toString());
                            to_write = "";
                        }
                    }
                }
                continue;
            }
            for (int ActionViewIndex = 0; ActionViewIndex < number_of_actions; ++ActionViewIndex) {
                action_INT = ActionViewIndex + 1;
                action_ID = Integer.toString(action_INT);
                Boolean ThisPassValue = false;
                LocalDateTime ThisTimeValue = LocalDateTime.now();
                String ThisType = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type;
                String ThisValue1 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1;
                String ThisValue2 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2;
                String ThisScreenshot = "null";
                String pass_string = " has failed at ";
                DataLoopVarParser var1Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1);
                DataLoopVarParser var2Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2);
                ThisPassValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Pass;
                ThisTimeValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).TimeOfTest;
                ThisScreenshot = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).ScreenshotBase64;
                int index_of_fileslashes = ThisScreenshot.indexOf("file:///") + 8;
                int index_of_id = ThisScreenshot.indexOf("id") - 2;
                if (index_of_fileslashes > 0 && index_of_id > index_of_fileslashes) {
                    ThisScreenshot = ThisScreenshot.substring(index_of_fileslashes, index_of_id);
                    ThisScreenshot = this.FileToBase64(ThisScreenshot);
                } else {
                    ThisScreenshot = "";
                }
                if (ThisPassValue.booleanValue()) {
                    pass_string = " has passed at ";
                }
                to_write = to_write + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                to_write = to_write + this.LineBreak;
                if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type.contains("assword")) {
                    to_write = bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " ########" + pass_string + ThisTimeValue.toString() + this.LineBreak;
                    if ("null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot)) {
                        to_write = to_write + this.LineBreak;
                    } else {
                        to_write = to_write + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                        to_write = to_write + this.LineBreak;
                        to_write = to_write + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Hide Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + "<img src=\"data:image/png;base64," + ThisScreenshot + "\" style=\"display: inline;\" class = \"report_screenshots\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\"></img>" + this.LineBreak;
                    }
                    if (writer == null) continue;
                    try {
                        writer.append(to_write);
                        to_write = "";
                    }
                    catch (Exception ex) {
                        System.out.println("Execpetion appending temp file: " + ex.toString());
                        to_write = "";
                    }
                    continue;
                }
                to_write = bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " " + ThisValue2 + pass_string + ThisTimeValue.toString() + this.LineBreak;
                to_write = to_write + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                to_write = to_write + this.LineBreak;
                to_write = "null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot) ? to_write + this.LineBreak : to_write + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Hide Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + "<img src=\"data:image/png;base64," + ThisScreenshot + "\" style=\"display: inline;\" class = \"report_screenshots\" id = \"Screenshot" + bug_ID + "-" + action_ID + "\"></img>" + this.LineBreak;
                if (writer == null) continue;
                try {
                    writer.append(to_write);
                    writer.flush();
                    to_write = "";
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Execpetion appending temp file: " + ex.toString());
                    to_write = "";
                }
            }
        }
        if (writer != null) {
            try {
                writer.append(this.Footer);
                to_write = "";
            }
            catch (Exception ex) {
                System.out.println("Execpetion appending temp file: " + ex.toString());
                to_write = "";
            }
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception ex) {
                System.out.println("Exception closing writer: " + ex.toString());
            }
        }
        this.TEMP_HTML_FILE = temp_report_file;
        return temp_report_file;
    }

    public String OutPutReport(boolean includescreens) {
        if (includescreens) {
            this.LineBreak = "<BR>";
            this.Header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"><HTML>\n<HEAD>\n<STYLE>#Report { height: 800; overflow-y: auto;}\n #Controls { }\n</STYLE>\n<SCRIPT>\nfunction ShowHideThisScreen(button_id)\n {var buttsize = button_id.length;\n var id_string = button_id.substring(14, buttsize);\n var img_id = \"Screenshot\" + id_string;\n\n var thisimg = document.getElementById(img_id);\n var button = document.getElementById(button_id);\n\n if (thisimg.style.display == \"inline\")\n     {\n         thisimg.style.display = \"none\";\n         button.innerHTML = \"Show Screenshot \" + id_string;\n         \n     }\n     else{\n         thisimg.style.display = \"inline\";\n         button.innerHTML = \"Hide Screenshot \" + id_string;\n     } }\nfunction ShowAllScreens()\n{   var allscreens = document.getElementsByClassName(\"report_screenshots\");\n for (x=0; x<allscreens.length; x++)\n   {\n      allscreens.item(x).style.display = \"inline\";\n      var thisid = allscreens.item(x).id;\n      var idsize = allscreens.item(x).id.length;\n     var id_string = allscreens.item(x).id.substring(10, idsize); \n var button = document.getElementById(\"ShowHideButton\" + id_string);\nbutton.innerHTML = \"Hide Screenshot \" + id_string;  }}\n function HideAllScreens()\n{  var allscreens = document.getElementsByClassName(\"report_screenshots\");\n for (x=0; x<allscreens.length; x++)\n   {\n      var idsize = allscreens.item(x).id.length;\n     var id_string = allscreens.item(x).id.substring(10, idsize);  \n var button = document.getElementById(\"ShowHideButton\" + id_string);\nbutton.innerHTML = \"Show Screenshot \" + id_string;      allscreens.item(x).style.display = \"none\";\n   }}\n</SCRIPT>\n</HEAD>\n<BODY>\n<DIV ID = \"Controls\">\n<BUTTON NAME = \"SHOWALLSCREENS\" ONCLICK=\"ShowAllScreens()\">Show All Screenshots</BUTTON> <BUTTON NAME = \"HIDEALLSCREENS\" ONCLICK=\"HideAllScreens()\">Hide All Screenshots</BUTTON>\n</DIV>\n<DIV ID=\"Report\">\n";
            this.Footer = "</DIV>\n</BODY>\n</HTML>";
        } else {
            this.Header = "<HTML><BODY>";
            this.Footer = "</BODY></HTML>";
            if (this.STAppData.getEmailReport()) {
                this.LineBreak = "\n";
                this.Header = "";
                this.Footer = "";
            } else {
                this.LineBreak = "<br>";
            }
        }
        String ReportText = "Procedure report: " + this.STAppData.filename + this.STAppData.TimeOfRun.toString() + this.LineBreak;
        int action_INT = 0;
        int bug_INT = 0;
        String bug_ID = "";
        String action_ID = "";
        for (int BugIndex = 0; BugIndex < this.STAppData.BugArray.size(); ++BugIndex) {
            bug_INT = BugIndex + 1;
            bug_ID = Integer.toString(bug_INT);
            ReportText = ReportText + "Procedure " + this.STAppData.BugArray.get(BugIndex).getBugTitle() + " " + this.STAppData.BugArray.get(BugIndex).getPassText() + this.LineBreak;
            int number_of_actions = this.STAppData.BugArray.get((int)BugIndex).ActionsList.size();
            int passvalueslength = 0;
            if (number_of_actions > 0 && this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)0).loop_pass_values != null) {
                passvalueslength = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)0).loop_pass_values.size();
            }
            if (passvalueslength > 0) {
                for (int passindex = 0; passindex < passvalueslength; ++passindex) {
                    for (int ActionViewIndex = 0; ActionViewIndex < number_of_actions; ++ActionViewIndex) {
                        action_INT = ActionViewIndex + 1;
                        action_ID = Integer.toString(action_INT) + "-" + passindex;
                        if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Locked.booleanValue()) continue;
                        Boolean ThisPassValue = false;
                        LocalDateTime ThisTimeValue = LocalDateTime.now();
                        String ThisType = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type;
                        String ThisValue1 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1;
                        String ThisValue2 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2;
                        String ThisScreenshot = "";
                        String pass_string = " has failed at ";
                        DataLoopVarParser var1Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1);
                        DataLoopVarParser var2Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2);
                        ThisPassValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).loop_pass_values.get(passindex);
                        ThisTimeValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).loop_time_of_test.get(passindex);
                        ThisScreenshot = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).loop_ScreenshotsBase64.get(passindex);
                        if (!var1Parser.hasDataLoopVar.booleanValue() && !var2Parser.hasDataLoopVar.booleanValue()) {
                            if (ThisPassValue.booleanValue()) {
                                pass_string = " has passed at ";
                            }
                            if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type.contains("assword")) {
                                ReportText = ReportText + bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " ########" + pass_string + ThisTimeValue.toString() + this.LineBreak;
                                ReportText = ReportText + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                                ReportText = ReportText + this.LineBreak;
                                if (!includescreens) continue;
                                if ("null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot)) {
                                    ReportText = ReportText + this.LineBreak;
                                    continue;
                                }
                                ReportText = ReportText + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Show Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + ThisScreenshot + this.LineBreak;
                                continue;
                            }
                            ReportText = ReportText + bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " " + ThisValue2 + pass_string + ThisTimeValue.toString() + this.LineBreak;
                            ReportText = ReportText + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                            ReportText = ReportText + this.LineBreak;
                            if (!includescreens) continue;
                            if ("null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot)) {
                                ReportText = ReportText + this.LineBreak;
                                continue;
                            }
                            ReportText = ReportText + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Show Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + ThisScreenshot + this.LineBreak;
                            continue;
                        }
                        if (ThisPassValue.booleanValue()) {
                            pass_string = " has passed at ";
                        }
                        String concat_variable = "";
                        String concat_variable2 = "";
                        if ("urllist".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable = var1Parser.GetFullValueFromURLList(passindex, this.STAppData.BugArray.get((int)BugIndex).URLListData);
                        }
                        if ("file".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable = var1Parser.GetFullValueFromFile(passindex, this.STAppData.BugArray.get((int)BugIndex).RunTimeFileSet);
                        }
                        if (!"".equals(concat_variable)) {
                            ThisValue1 = concat_variable;
                        }
                        if ("urllist".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable2 = var2Parser.GetFullValueFromURLList(passindex, this.STAppData.BugArray.get((int)BugIndex).URLListData);
                        }
                        if ("file".equals(this.STAppData.BugArray.get((int)BugIndex).DataLoopSource)) {
                            concat_variable2 = var2Parser.GetFullValueFromFile(passindex, this.STAppData.BugArray.get((int)BugIndex).RunTimeFileSet);
                        }
                        if (!"".equals(concat_variable2)) {
                            ThisValue2 = concat_variable2;
                        }
                        if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type.contains("assword")) {
                            ReportText = ReportText + bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " ########" + pass_string + ThisTimeValue.toString() + this.LineBreak;
                            ReportText = ReportText + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                            ReportText = ReportText + this.LineBreak;
                            if (!includescreens) continue;
                            if ("null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot)) {
                                ReportText = ReportText + this.LineBreak;
                                continue;
                            }
                            ReportText = ReportText + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Show Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + ThisScreenshot + this.LineBreak;
                            continue;
                        }
                        ReportText = ReportText + bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " " + ThisValue2 + pass_string + ThisTimeValue.toString() + this.LineBreak;
                        ReportText = ReportText + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                        ReportText = ReportText + this.LineBreak;
                        if (!includescreens) continue;
                        ReportText = "null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot) ? ReportText + this.LineBreak : ReportText + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Show Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + ThisScreenshot + this.LineBreak;
                    }
                }
                continue;
            }
            for (int ActionViewIndex = 0; ActionViewIndex < number_of_actions; ++ActionViewIndex) {
                action_INT = ActionViewIndex + 1;
                action_ID = Integer.toString(action_INT);
                Boolean ThisPassValue = false;
                LocalDateTime ThisTimeValue = LocalDateTime.now();
                String ThisType = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type;
                String ThisValue1 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1;
                String ThisValue2 = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2;
                String ThisScreenshot = "null";
                String pass_string = " has failed at ";
                DataLoopVarParser var1Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable1);
                DataLoopVarParser var2Parser = new DataLoopVarParser(this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Variable2);
                ThisPassValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Pass;
                ThisTimeValue = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).TimeOfTest;
                ThisScreenshot = this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).ScreenshotBase64;
                if (ThisPassValue.booleanValue()) {
                    pass_string = " has passed at ";
                }
                if (this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Type.contains("assword")) {
                    ReportText = ReportText + bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " ########" + pass_string + ThisTimeValue.toString() + this.LineBreak;
                    ReportText = ReportText + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                    ReportText = ReportText + this.LineBreak;
                    if (!includescreens) continue;
                    if ("null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot)) {
                        ReportText = ReportText + this.LineBreak;
                        continue;
                    }
                    ReportText = ReportText + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Show Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + ThisScreenshot + this.LineBreak;
                    continue;
                }
                ReportText = ReportText + bug_ID + "-" + action_ID + " Action: " + ThisType + " " + ThisValue1 + " " + ThisValue2 + pass_string + ThisTimeValue.toString() + this.LineBreak;
                ReportText = ReportText + this.STAppData.BugArray.get((int)BugIndex).ActionsList.get((int)ActionViewIndex).Exception;
                ReportText = ReportText + this.LineBreak;
                if (!includescreens) continue;
                ReportText = "null".equals(ThisScreenshot) || "Screenshot Failed".equals(ThisScreenshot) ? ReportText + this.LineBreak : ReportText + "\n<BUTTON NAME =\"ShowHideButton\" onclick = \"ShowHideThisScreen(this.id)\" id = \"ShowHideButton" + bug_ID + "-" + action_ID + "\">Show Screenshot " + bug_ID + "-" + action_ID + "</BUTTON>" + this.LineBreak + ThisScreenshot + this.LineBreak;
            }
        }
        ReportText = this.Header + this.LineBreak + ReportText + this.Footer;
        return ReportText;
    }

    public void SaveAsHTMLFile() {
        JFileChooser fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                String filestring = f.toString();
                String[] left_side_of_dot = filestring.split("\\.");
                if ((f = new File(left_side_of_dot[0] + ".html")).exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(BrowserMatorReport.this.ReportFrame, "The file exists, overwrite?", "Existing file", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        File file = null;
        BrowserMatorConfig theseProps = new BrowserMatorConfig();
        String lastReportSaveDir = theseProps.getKeyValue("lastused_dir_save_report");
        FileNameExtensionFilter filefilter = new FileNameExtensionFilter("HTML file (*.html)", "html");
        fc.setFileFilter(filefilter);
        fc.setPreferredSize(new Dimension(800, 600));
        fc.setSelectedFile(file);
        if (lastReportSaveDir != null) {
            fc.setCurrentDirectory(new File(lastReportSaveDir));
        }
        fc.setPreferredSize(new Dimension(800, 600));
        int returnVal = fc.showSaveDialog(this.ReportFrame);
        if (returnVal == 0) {
            file = fc.getSelectedFile();
            String filestring = file.toString();
            String[] left_side_of_dot = filestring.split("\\.");
            file = new File(left_side_of_dot[0] + ".html");
            FileWriter fWriter = null;
            BufferedWriter writer = null;
            try {
                fWriter = new FileWriter(file);
                writer = new BufferedWriter(fWriter);
                writer.write(this.HTMLReportForSave);
                writer.newLine();
                writer.close();
            }
            catch (Exception ex) {
                System.out.println("Exception saving HTML file: " + ex.toString());
            }
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception ex) {
                    System.out.println("Exception opening HTML file: " + ex.toString());
                }
            }
        }
        File chosenDir = fc.getCurrentDirectory();
        theseProps.setKeyValue("lastused_dir_save_report", chosenDir.getAbsolutePath());
    }

    public void SaveAsHTMLFile(File sourceFile) {
        JFileChooser fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                String filestring = f.toString();
                String[] left_side_of_dot = filestring.split("\\.");
                if ((f = new File(left_side_of_dot[0] + ".html")).exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(BrowserMatorReport.this.ReportFrame, "The file exists, overwrite?", "Existing file", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        File file = null;
        BrowserMatorConfig theseProps = new BrowserMatorConfig();
        String lastReportSaveDir = theseProps.getKeyValue("lastused_dir_save_report");
        FileNameExtensionFilter filefilter = new FileNameExtensionFilter("HTML file (*.html)", "html");
        fc.setFileFilter(filefilter);
        if (lastReportSaveDir != null) {
            fc.setCurrentDirectory(new File(lastReportSaveDir));
        }
        fc.setSelectedFile(file);
        fc.setPreferredSize(new Dimension(800, 600));
        int returnVal = fc.showSaveDialog(this.ReportFrame);
        if (returnVal == 0) {
            file = fc.getSelectedFile();
            String filestring = file.toString();
            String[] left_side_of_dot = filestring.split("\\.");
            file = new File(left_side_of_dot[0] + ".html");
            if (sourceFile != null) {
                try {
                    FileUtils.copyFile((File)sourceFile, (File)file);
                }
                catch (Exception ex) {
                    System.out.println("Exception saving HTML file: " + ex.toString());
                }
            }
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception ex) {
                    System.out.println("Exception opening HTML file: " + ex.toString());
                }
            }
        }
        File chosenDir = fc.getCurrentDirectory();
        theseProps.setKeyValue("lastused_dir_save_report", chosenDir.getAbsolutePath());
    }
}

