/*
 * Decompiled with CFR 0.152.
 */
package browsermator4.com;

import com.sun.javafx.PlatformUtil;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class BrowserMatorConfig {
    Properties applicationProps;
    FileInputStream input;
    String userdir;
    FileWriter writer;
    String BrowsermatorAppFolder;
    JFileChooser BrowserBrowser;
    String OperatingSystem;

    BrowserMatorConfig() {
        String bits = System.getProperty("sun.arch.data.model");
        this.OperatingSystem = "Other";
        if (PlatformUtil.isWindows()) {
            this.OperatingSystem = "Windows64";
            boolean is64bit = false;
            is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").contains("64");
            if (!is64bit) {
                this.OperatingSystem = "Windows32";
            }
        }
        if (PlatformUtil.isMac()) {
            this.OperatingSystem = "Mac";
        }
        if (PlatformUtil.isLinux()) {
            this.OperatingSystem = "Linux-64";
            if ("32".equals(bits)) {
                this.OperatingSystem = "Linux-32";
            }
        }
        this.BrowsermatorAppFolder = System.getProperty("user.home") + File.separator + "BrowsermatorAppFolder" + File.separator;
        Boolean file_exists = false;
        File f = new File(this.BrowsermatorAppFolder + "browsermator_config.properties");
        if (f.exists() && !f.isDirectory()) {
            file_exists = true;
        }
        if (!file_exists.booleanValue()) {
            this.CreateConfigFile();
        }
        this.userdir = System.getProperty("user.home");
        this.applicationProps = new Properties();
        try (FileInputStream input = new FileInputStream(this.BrowsermatorAppFolder + "browsermator_config.properties");){
            this.applicationProps.load(input);
        }
        catch (Exception e) {
            System.out.println("error loading config:" + e.toString());
        }
    }

    public String getKeyValue(String key) {
        String value = "";
        value = this.applicationProps.getProperty(key);
        return value;
    }

    public void removeKey(String key) {
        this.applicationProps.remove(key);
        try {
            this.writer = new FileWriter(this.BrowsermatorAppFolder + "browsermator_config.properties");
            this.applicationProps.store(this.writer, "browsermator_settings");
            this.writer.close();
        }
        catch (Exception e) {
            System.out.println("Exception deleteing key: " + e.toString());
        }
    }

    public void setKeyValue(String key, String value) {
        this.applicationProps.setProperty(key, value);
        try {
            this.writer = new FileWriter(this.BrowsermatorAppFolder + "browsermator_config.properties");
            this.applicationProps.store(this.writer, "browsermator_settings");
            this.writer.close();
        }
        catch (Exception e) {
            System.out.println("Exception writing key: " + key + "value: " + value + "ex: " + e);
        }
    }

    public void BrowseforBrowserPath(String targetbrowser) {
        switch (targetbrowser) {
            case "Firefox": {
                this.BrowserBrowser = new JFileChooser("Browse for Firefox executable");
                this.BrowserBrowser.setDialogTitle("Browse for Firefox executable (If Selenium had a problem loading Firefox this may fix it.)");
                break;
            }
            case "Chrome": {
                this.BrowserBrowser = new JFileChooser("Browse for Chrome executable");
                this.BrowserBrowser.setDialogTitle("Browse for Chrome executable.");
            }
        }
        JPanel newJPanel = new JPanel();
        int returnVal = this.BrowserBrowser.showOpenDialog(newJPanel);
        if (returnVal == 0) {
            File file = this.BrowserBrowser.getSelectedFile();
            this.setKeyValue(targetbrowser, file.getAbsolutePath());
        }
    }

    public final void CreateConfigFile() {
        File newconfig = new File(this.BrowsermatorAppFolder + "browsermator_config.properties");
        Properties newProps = new Properties();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice defaultScreen = ge.getDefaultScreenDevice();
        Rectangle rect = defaultScreen.getDefaultConfiguration().getBounds();
        int x = (int)rect.getMaxX() - 1328;
        if (x < 0) {
            x = 0;
        }
        String stringX = Integer.toString(x);
        newProps.setProperty("main_window_locationY", "0");
        newProps.setProperty("main_window_locationX", stringX);
        newProps.setProperty("main_window_sizeWidth", "1328");
        newProps.setProperty("main_window_sizeHeight", "950");
        newProps.setProperty("email_subject", "");
        newProps.setProperty("email_to", "");
        newProps.setProperty("email_login_password", "");
        newProps.setProperty("email_from", "");
        newProps.setProperty("email_login_name", "");
        newProps.setProperty("smtp_hostname", "");
        newProps.setProperty("recentfiles", " , , , , , , , , , , ");
        try {
            FileWriter writer = new FileWriter(newconfig);
            newProps.store(writer, "browsermator_settings");
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Exception writing config: " + e);
        }
    }

    public String ReturnMachineSerialNumber() throws IOException {
        Process process = null;
        String ret_val = "";
        String sn = null;
        OutputStream os = null;
        InputStream is = null;
        Runtime runtime = Runtime.getRuntime();
        switch (this.OperatingSystem) {
            case "Mac": {
                try {
                    process = runtime.exec(new String[]{"/usr/sbin/system_profiler", "SPHardwareDataType"});
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                os = process.getOutputStream();
                is = process.getInputStream();
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                String marker = "Serial Number";
                try {
                    while ((line = br.readLine()) != null) {
                        if (!line.contains(marker)) continue;
                        sn = line.split(":")[1].trim();
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (sn == null) {
                    throw new RuntimeException("Cannot find computer SN");
                }
                ret_val = sn;
                break;
            }
            case "Linux": {
                String line = null;
                String marker = "Serial Number:";
                BufferedReader br = null;
                try {
                    br = BrowserMatorConfig.read("dmidecode -t system");
                    while ((line = br.readLine()) != null) {
                        if (!line.contains(marker)) continue;
                        sn = line.split(marker)[1].trim();
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if (sn == null) {
                    line = null;
                    marker = "system.hardware.serial =";
                    br = null;
                    try {
                        br = BrowserMatorConfig.read("lshal");
                        while ((line = br.readLine()) != null) {
                            if (!line.contains(marker)) continue;
                            sn = line.split(marker)[1].replaceAll("\\(string\\)|(\\')", "").trim();
                            break;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
                if (sn == null) {
                    sn = "";
                }
                ret_val = sn;
                break;
            }
            default: {
                String serial;
                process = Runtime.getRuntime().exec(new String[]{"wmic", "bios", "get", "serialnumber"});
                process.getOutputStream().close();
                Scanner sc = new Scanner(process.getInputStream());
                String property = sc.next();
                ret_val = serial = sc.next();
            }
        }
        return ret_val;
    }

    private static BufferedReader read(String command) {
        OutputStream os = null;
        InputStream is = null;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command.split(" "));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        os = process.getOutputStream();
        is = process.getInputStream();
        try {
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new BufferedReader(new InputStreamReader(is));
    }
}

