/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.locators;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.locators.CustomLocator;
import org.openqa.selenium.support.locators.RelativeLocatorScript;

@AutoService(value={CustomLocator.class})
public class RelativeLocatorServerSide
implements CustomLocator {
    @Override
    public String getLocatorName() {
        return "relative";
    }

    @Override
    public By createBy(Object usingParameter) {
        Require.nonNull("Using", usingParameter);
        return new RemoteRelative(usingParameter);
    }

    private static class RemoteRelative
    extends By {
        private final Object using;

        private RemoteRelative(Object usingParameter) {
            this.using = usingParameter;
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            JavascriptExecutor js = this.getJavascriptExecutor(context);
            WebDriver driver = this.getWebDriver(context);
            if (driver instanceof RemoteWebDriver) {
                Object converted = new JsonToWebElementConverter((RemoteWebDriver)driver).apply(this.using);
                List elements = (List)js.executeScript(RelativeLocatorScript.FIND_ELEMENTS, ImmutableMap.of("relative", converted));
                return elements;
            }
            throw new InvalidArgumentException("Unable to find element");
        }
    }
}

