/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.net.ConnectException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class RetryRequest
implements Filter {
    private static final Logger LOG = Logger.getLogger(RetryRequest.class.getName());
    private static final RetryPolicy<HttpResponse> connectionFailurePolicy = ((RetryPolicy)new RetryPolicy().handleIf(failure -> failure.getCause() instanceof ConnectException)).withBackoff(1L, 4L, ChronoUnit.SECONDS).withMaxRetries(3).withMaxDuration(Duration.ofSeconds(10L)).onRetry(e -> LOG.log(Level.WARNING, "Connection failure #{0}. Retrying.", e.getAttemptCount()));
    private static final RetryPolicy<HttpResponse> readTimeoutPolicy = ((RetryPolicy)new RetryPolicy().handle((Class<? extends Throwable>)((Class<Throwable>)TimeoutException.class))).withBackoff(1L, 4L, ChronoUnit.SECONDS).withMaxRetries(3).withMaxDuration(Duration.ofSeconds(10L)).onRetry(e -> LOG.log(Level.WARNING, "Read timeout #{0}. Retrying.", e.getAttemptCount()));
    private static final RetryPolicy<HttpResponse> serverErrorPolicy = ((RetryPolicy)((RetryPolicy)new RetryPolicy<HttpResponse>().handleResultIf(response -> response.getStatus() == 500 && Integer.parseInt(response.getHeader("Content-Length")) == 0)).handleResultIf(response -> response.getStatus() == 503)).withBackoff(1L, 2L, ChronoUnit.SECONDS).withMaxRetries(2).withMaxDuration(Duration.ofSeconds(3L)).onRetry(e -> LOG.log(Level.WARNING, "Failure due to server error #{0}. Retrying.", e.getAttemptCount()));

    @Override
    public HttpHandler apply(HttpHandler next) {
        return req -> Failsafe.with(connectionFailurePolicy, (Policy[])new RetryPolicy[]{readTimeoutPolicy, serverErrorPolicy}).get(() -> next.execute(req));
    }
}

