/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.WebClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriver;

public class HtmlUnitTimeouts
implements WebDriver.Timeouts {
    private long implicitWait = 0L;
    private long scriptTimeout = 0L;
    private long pageLoadTimeout = 0L;
    private WebClient webClient = null;

    public HtmlUnitTimeouts() {
    }

    public HtmlUnitTimeouts(WebClient webClient) {
        this.webClient = webClient;
    }

    @Override
    public Duration getImplicitWaitTimeout() {
        return Duration.ofMillis(this.implicitWait);
    }

    @Override
    @Deprecated
    public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
        this.implicitlyWait(Duration.ofMillis(TimeUnit.MILLISECONDS.convert(time, unit)));
        return this;
    }

    @Override
    public WebDriver.Timeouts implicitlyWait(Duration duration) {
        this.implicitWait = Math.max(0L, duration.toMillis());
        return this;
    }

    @Override
    public WebDriver.Timeouts scriptTimeout(Duration duration) {
        this.scriptTimeout = duration.toMillis();
        return this;
    }

    @Override
    @Deprecated
    public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
        this.scriptTimeout(Duration.ofMillis(TimeUnit.MILLISECONDS.convert(time, unit)));
        return this;
    }

    @Override
    public Duration getScriptTimeout() {
        return Duration.ofMillis(this.scriptTimeout);
    }

    @Override
    @Deprecated
    public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
        this.pageLoadTimeout(Duration.ofMillis(TimeUnit.MILLISECONDS.convert(time, unit)));
        return this;
    }

    @Override
    public WebDriver.Timeouts pageLoadTimeout(Duration duration) {
        this.pageLoadTimeout = duration.toMillis();
        HtmlUnitTimeouts.setPageLoadTimeoutForWebClient(this.webClient, this.pageLoadTimeout);
        return this;
    }

    @Override
    public Duration getPageLoadTimeout() {
        return Duration.ofMillis(this.pageLoadTimeout);
    }

    private static void setPageLoadTimeoutForWebClient(WebClient webClient, long timeout) {
        if (webClient != null) {
            webClient.getOptions().setTimeout(Math.max((int)timeout, 0));
        }
    }
}

