/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.html.DomElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitElementFinder;
import org.openqa.selenium.htmlunit.HtmlUnitWebElementFinder;

public class ElementConverter {
    private static Converter getConverter(By locator, Converter[] array) {
        return Arrays.stream(array).filter(Objects::nonNull).filter(f -> locator.getClass().equals(f.getMappedClass())).findFirst().orElseThrow(() -> new RuntimeException("Cannot find element object"));
    }

    public static enum HtmlUnitWebElementConverter implements Converter
    {
        ID(By.ById.class, HtmlUnitWebElementFinder.WebFindById.class),
        NAME(By.ByName.class, HtmlUnitWebElementFinder.WebFindByName.class),
        LINK_TEXT(By.ByLinkText.class, HtmlUnitWebElementFinder.WebFindByLinkText.class),
        PARTIAL_LINK_TEXT(By.ByPartialLinkText.class, HtmlUnitWebElementFinder.WebFindByPartialLinkText.class),
        CLASS_NAME(By.ByClassName.class, HtmlUnitWebElementFinder.WebFindByClassName.class),
        CSS_SELECTOR(By.ByCssSelector.class, HtmlUnitWebElementFinder.WebFindByCssSelector.class),
        TAG_NAME(By.ByTagName.class, HtmlUnitWebElementFinder.WebFindByTagName.class),
        XPATH(By.ByXPath.class, HtmlUnitWebElementFinder.WebFindByXPath.class);

        private final Class<? extends By> mappedClass;
        private final Class<? extends HtmlUnitElementFinder.ElementObject> targetClass;

        private HtmlUnitWebElementConverter(Class<? extends By> mappedClass, Class<? extends HtmlUnitElementFinder.ElementObject> targetClass) {
            this.mappedClass = mappedClass;
            this.targetClass = targetClass;
        }

        public static HtmlUnitElementFinder.ElementObject getElementObject(HtmlUnitDriver driver, DomElement element, By locator) {
            HtmlUnitWebElementConverter object = (HtmlUnitWebElementConverter)ElementConverter.getConverter(locator, HtmlUnitWebElementConverter.values());
            try {
                return object.getTargetClass().getConstructor(HtmlUnitDriver.class, DomElement.class).newInstance(driver, element);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return HtmlUnitElementConverter.getElementObject(driver, locator);
            }
        }

        @Override
        public Class<? extends By> getMappedClass() {
            return this.mappedClass;
        }

        @Override
        public Class<? extends HtmlUnitElementFinder.ElementObject> getTargetClass() {
            return this.targetClass;
        }
    }

    public static enum HtmlUnitElementConverter implements Converter
    {
        ID(By.ById.class, HtmlUnitElementFinder.FindByID.class),
        NAME(By.ByName.class, HtmlUnitElementFinder.FindByName.class),
        LINK_TEXT(By.ByLinkText.class, HtmlUnitElementFinder.FindByLinkText.class),
        PARTIAL_LINK_TEXT(By.ByPartialLinkText.class, HtmlUnitElementFinder.FindByPartialLinkText.class),
        CLASS_NAME(By.ByClassName.class, HtmlUnitElementFinder.FindByClassName.class),
        CSS_SELECTOR(By.ByCssSelector.class, HtmlUnitElementFinder.FindByCssSelector.class),
        TAG_NAME(By.ByTagName.class, HtmlUnitElementFinder.FindByTagName.class),
        XPATH(By.ByXPath.class, HtmlUnitElementFinder.FindByXPath.class);

        private final Class<? extends By> mappedClass;
        private final Class<? extends HtmlUnitElementFinder.ElementObject> targetClass;

        private HtmlUnitElementConverter(Class<? extends By> mappedClass, Class<? extends HtmlUnitElementFinder.ElementObject> targetClass) {
            this.mappedClass = mappedClass;
            this.targetClass = targetClass;
        }

        public static HtmlUnitElementFinder.ElementObject getElementObject(HtmlUnitDriver driver, By locator) {
            HtmlUnitElementConverter object = (HtmlUnitElementConverter)ElementConverter.getConverter(locator, HtmlUnitElementConverter.values());
            try {
                return object.getTargetClass().getConstructor(HtmlUnitDriver.class).newInstance(driver);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Cannot convert By instance to custom implementation", e);
            }
        }

        @Override
        public Class<? extends By> getMappedClass() {
            return this.mappedClass;
        }

        @Override
        public Class<? extends HtmlUnitElementFinder.ElementObject> getTargetClass() {
            return this.targetClass;
        }
    }

    static interface Converter {
        public Class<? extends By> getMappedClass();

        public Class<? extends HtmlUnitElementFinder.ElementObject> getTargetClass();
    }
}

