/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2;

import com.shapesecurity.salvation2.Constants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Utils {
    public static final Predicate<String> IS_BASE64_VALUE = Pattern.compile("[a-zA-Z0-9+/\\-_]+=?=?").asPredicate();

    static List<String> splitOnAsciiWhitespace(String input) {
        ArrayList<String> out = new ArrayList<String>();
        for (String value : input.split("[" + Constants.WHITESPACE_CHARS + "]")) {
            if (value.isEmpty()) continue;
            out.add(value);
        }
        return out;
    }

    static List<String> strictlySplit(@Nonnull String s2, char delim) {
        int next;
        int off = 0;
        ArrayList<String> list = new ArrayList<String>();
        while ((next = s2.indexOf(delim, off)) != -1) {
            list.add(s2.substring(off, next));
            off = next + 1;
        }
        list.add(s2.substring(off));
        return list;
    }

    static String decodeString(@Nonnull String s2) {
        try {
            return URLDecoder.decode(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s2;
        }
    }
}

