/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2;

import com.shapesecurity.salvation2.Constants;
import com.shapesecurity.salvation2.Directive;
import com.shapesecurity.salvation2.Directives.FrameAncestorsDirective;
import com.shapesecurity.salvation2.Directives.HostSourceDirective;
import com.shapesecurity.salvation2.Directives.PluginTypesDirective;
import com.shapesecurity.salvation2.Directives.ReportUriDirective;
import com.shapesecurity.salvation2.Directives.SandboxDirective;
import com.shapesecurity.salvation2.Directives.SourceExpressionDirective;
import com.shapesecurity.salvation2.FetchDirectiveKind;
import com.shapesecurity.salvation2.PolicyList;
import com.shapesecurity.salvation2.URLs.GUID;
import com.shapesecurity.salvation2.URLs.URI;
import com.shapesecurity.salvation2.URLs.URLWithScheme;
import com.shapesecurity.salvation2.Utils;
import com.shapesecurity.salvation2.Values.Hash;
import com.shapesecurity.salvation2.Values.Host;
import com.shapesecurity.salvation2.Values.MediaType;
import com.shapesecurity.salvation2.Values.RFC7230Token;
import com.shapesecurity.salvation2.Values.Scheme;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Policy {
    private List<NamedDirective> directives = new ArrayList<NamedDirective>();
    private SourceExpressionDirective baseUri = null;
    private boolean blockAllMixedContent = false;
    private SourceExpressionDirective formAction = null;
    private FrameAncestorsDirective frameAncestors = null;
    private SourceExpressionDirective navigateTo = null;
    private PluginTypesDirective pluginTypes;
    private RFC7230Token reportTo;
    private ReportUriDirective reportUri;
    private SandboxDirective sandbox = null;
    private boolean upgradeInsecureRequests = false;
    @Nonnull
    private final Map<FetchDirectiveKind, SourceExpressionDirective> fetchDirectives = new HashMap<FetchDirectiveKind, SourceExpressionDirective>();

    private Policy() {
    }

    @Nonnull
    public static PolicyList parseSerializedCSPList(String serialized, PolicyListErrorConsumer policyListErrorConsumer) {
        Policy.enforceAscii(serialized);
        ArrayList<Policy> policies = new ArrayList<Policy>();
        int[] index = new int[]{0};
        PolicyErrorConsumer policyErrorConsumer = (severity, message, directiveIndex, valueIndex) -> policyListErrorConsumer.add(severity, message, index[0], directiveIndex, valueIndex);
        for (String token : serialized.split(",")) {
            Policy policy = Policy.parseSerializedCSP(token, policyErrorConsumer);
            if (policy.directives.isEmpty()) {
                index[0] = index[0] + 1;
                continue;
            }
            policies.add(policy);
            index[0] = index[0] + 1;
        }
        return new PolicyList(policies);
    }

    @Nonnull
    public static Policy parseSerializedCSP(String serialized, PolicyErrorConsumer policyErrorConsumer) {
        Policy.enforceAscii(serialized);
        if (serialized.contains(",")) {
            throw new IllegalArgumentException("Serialized CSPs cannot contain commas - you may have wanted parseSerializedCSPList");
        }
        int[] index = new int[]{0};
        Directive.DirectiveErrorConsumer directiveErrorConsumer = (severity, message, valueIndex) -> policyErrorConsumer.add(severity, message, index[0], valueIndex);
        Policy policy = new Policy();
        for (String token : serialized.split(";")) {
            String strippedLeadingAndTrailingWhitespace = Policy.stripTrailingWhitespace(Policy.stripLeadingWhitespace(token));
            if (strippedLeadingAndTrailingWhitespace.isEmpty()) {
                index[0] = index[0] + 1;
                continue;
            }
            String directiveName = Policy.collect(strippedLeadingAndTrailingWhitespace, "[^'" + Constants.WHITESPACE_CHARS + "]+");
            String remainingToken = strippedLeadingAndTrailingWhitespace.substring(directiveName.length());
            List<String> directiveValues = Utils.splitOnAsciiWhitespace(remainingToken);
            policy.add(directiveName, directiveValues, directiveErrorConsumer);
            index[0] = index[0] + 1;
        }
        return policy;
    }

    public Directive add(String name, List<String> values, Directive.DirectiveErrorConsumer directiveErrorConsumer) {
        Directive newDirective;
        String lowcaseDirectiveName;
        Policy.enforceAscii(name);
        if (Directive.containsNonDirectiveCharacter.test(name)) {
            throw new IllegalArgumentException("directive names must not contain whitespace, ',', or ';'");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("directive names must not be empty");
        }
        boolean wasDupe = false;
        switch (lowcaseDirectiveName = name.toLowerCase(Locale.ENGLISH)) {
            case "base-uri": {
                SourceExpressionDirective thisDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                if (this.baseUri == null) {
                    this.baseUri = thisDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = thisDirective;
                break;
            }
            case "block-all-mixed-content": {
                if (!this.blockAllMixedContent) {
                    if (!values.isEmpty()) {
                        directiveErrorConsumer.add(Severity.Error, "The block-all-mixed-content directive does not support values", 0);
                    }
                    this.blockAllMixedContent = true;
                } else {
                    wasDupe = true;
                }
                newDirective = new Directive(values);
                break;
            }
            case "form-action": {
                SourceExpressionDirective thisDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                if (this.formAction == null) {
                    this.formAction = thisDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = thisDirective;
                break;
            }
            case "frame-ancestors": {
                FrameAncestorsDirective thisDirective = new FrameAncestorsDirective(values, directiveErrorConsumer);
                if (this.frameAncestors == null) {
                    this.frameAncestors = thisDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = thisDirective;
                break;
            }
            case "navigate-to": {
                SourceExpressionDirective thisDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                if (this.navigateTo == null) {
                    this.navigateTo = thisDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = thisDirective;
                break;
            }
            case "plugin-types": {
                PluginTypesDirective thisDirective = new PluginTypesDirective(values, directiveErrorConsumer);
                if (this.pluginTypes == null) {
                    this.pluginTypes = thisDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = thisDirective;
                break;
            }
            case "report-to": {
                if (this.reportTo == null) {
                    if (values.size() == 0) {
                        directiveErrorConsumer.add(Severity.Error, "The report-to directive requires a value", -1);
                    } else if (values.size() == 1) {
                        String token = values.get(0);
                        Optional<RFC7230Token> matched = RFC7230Token.parseRFC7230Token(token);
                        if (matched.isPresent()) {
                            this.reportTo = matched.get();
                        } else {
                            directiveErrorConsumer.add(Severity.Error, "Expecting RFC 7230 token but found \"" + token + "\"", 0);
                        }
                    } else {
                        directiveErrorConsumer.add(Severity.Error, "The report-to directive requires exactly one value (found " + values.size() + ")", 1);
                    }
                } else {
                    wasDupe = true;
                }
                newDirective = new Directive(values);
                break;
            }
            case "report-uri": {
                directiveErrorConsumer.add(Severity.Warning, "The report-uri directive has ben deprecated in favor of the new report-to directive", -1);
                ReportUriDirective thisDirective = new ReportUriDirective(values, directiveErrorConsumer);
                if (this.reportUri == null) {
                    this.reportUri = thisDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = thisDirective;
                break;
            }
            case "sandbox": {
                SandboxDirective thisDirective = new SandboxDirective(values, directiveErrorConsumer);
                if (this.sandbox == null) {
                    this.sandbox = thisDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = thisDirective;
                break;
            }
            case "upgrade-insecure-requests": {
                if (!this.upgradeInsecureRequests) {
                    if (!values.isEmpty()) {
                        directiveErrorConsumer.add(Severity.Error, "The upgrade-insecure-requests directive does not support values", 0);
                    }
                    this.upgradeInsecureRequests = true;
                } else {
                    wasDupe = true;
                }
                newDirective = new Directive(values);
                break;
            }
            default: {
                FetchDirectiveKind fetchDirectiveKind = FetchDirectiveKind.fromString(lowcaseDirectiveName);
                if (fetchDirectiveKind != null) {
                    SourceExpressionDirective thisDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                    if (this.fetchDirectives.containsKey((Object)fetchDirectiveKind)) {
                        wasDupe = true;
                    } else {
                        this.fetchDirectives.put(fetchDirectiveKind, thisDirective);
                    }
                    newDirective = thisDirective;
                    break;
                }
                directiveErrorConsumer.add(Severity.Warning, "Unrecognized directive " + lowcaseDirectiveName, -1);
                newDirective = new Directive(values);
                break;
            }
        }
        this.directives.add(new NamedDirective(name, newDirective));
        if (wasDupe) {
            directiveErrorConsumer.add(Severity.Warning, "Duplicate directive " + lowcaseDirectiveName, -1);
        }
        return newDirective;
    }

    public boolean remove(String name) {
        boolean removed = false;
        String lowcaseName = name.toLowerCase(Locale.ENGLISH);
        ArrayList<NamedDirective> copy = new ArrayList<NamedDirective>(this.directives.size());
        for (NamedDirective existing : this.directives) {
            if (!existing.lowcaseName.equals(lowcaseName)) {
                copy.add(existing);
                continue;
            }
            removed = true;
        }
        if (!removed) {
            return false;
        }
        this.directives = copy;
        switch (lowcaseName) {
            case "base-uri": {
                this.baseUri = null;
                break;
            }
            case "block-all-mixed-content": {
                this.blockAllMixedContent = false;
                break;
            }
            case "form-action": {
                this.formAction = null;
                break;
            }
            case "frame-ancestors": {
                this.frameAncestors = null;
                break;
            }
            case "navigate-to": {
                this.navigateTo = null;
                break;
            }
            case "plugin-types": {
                this.pluginTypes = null;
                break;
            }
            case "report-to": {
                this.reportTo = null;
                break;
            }
            case "report-uri": {
                this.reportUri = null;
                break;
            }
            case "sandbox": {
                this.sandbox = null;
                break;
            }
            case "upgrade-insecure-requests": {
                this.upgradeInsecureRequests = false;
                break;
            }
            default: {
                FetchDirectiveKind fetchDirectiveKind = FetchDirectiveKind.fromString(lowcaseName);
                if (fetchDirectiveKind == null) break;
                this.fetchDirectives.remove((Object)fetchDirectiveKind);
                break;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (NamedDirective directive : this.directives) {
            if (!first) {
                out.append("; ");
            }
            first = false;
            out.append(directive.name);
            for (String value : directive.directive.getValues()) {
                out.append(' ');
                out.append(value);
            }
        }
        return out.toString();
    }

    public Optional<SourceExpressionDirective> baseUri() {
        return Optional.ofNullable(this.baseUri);
    }

    public boolean blockAllMixedContent() {
        return this.blockAllMixedContent;
    }

    public void setBlockAllMixedContent(boolean value) {
        if (this.blockAllMixedContent) {
            if (value) {
                return;
            }
            this.remove("block-all-mixed-content");
        } else {
            if (!value) {
                return;
            }
            this.blockAllMixedContent = true;
            this.directives.add(new NamedDirective("block-all-mixed-content", new Directive(Collections.emptyList())));
        }
    }

    public Optional<SourceExpressionDirective> formAction() {
        return Optional.ofNullable(this.formAction);
    }

    public Optional<FrameAncestorsDirective> frameAncestors() {
        return Optional.ofNullable(this.frameAncestors);
    }

    public Optional<SourceExpressionDirective> navigateTo() {
        return Optional.ofNullable(this.navigateTo);
    }

    public Optional<PluginTypesDirective> pluginTypes() {
        return Optional.ofNullable(this.pluginTypes);
    }

    public Optional<RFC7230Token> reportTo() {
        return Optional.ofNullable(this.reportTo);
    }

    public void setReportTo(RFC7230Token token) {
        if (token == null) {
            this.remove("report-to");
            return;
        }
        boolean found = false;
        for (NamedDirective directive : this.directives) {
            if (!directive.lowcaseName.equals("report-to")) continue;
            directive.directive.values = new ArrayList<String>();
            directive.directive.addValue(token.value);
            found = true;
            break;
        }
        if (!found) {
            this.directives.add(new NamedDirective("report-to", new Directive(Collections.singletonList(token.value))));
        }
        this.reportTo = token;
    }

    public Optional<ReportUriDirective> reportUri() {
        return Optional.ofNullable(this.reportUri);
    }

    public Optional<SandboxDirective> sandbox() {
        return Optional.ofNullable(this.sandbox);
    }

    public boolean upgradeInsecureRequests() {
        return this.upgradeInsecureRequests;
    }

    public void setUpgradeInsecureRequests(boolean value) {
        if (this.upgradeInsecureRequests) {
            if (value) {
                return;
            }
            this.remove("upgrade-insecure-requests");
        } else {
            if (!value) {
                return;
            }
            this.upgradeInsecureRequests = true;
            this.directives.add(new NamedDirective("upgrade-insecure-requests", new Directive(Collections.emptyList())));
        }
    }

    public Optional<SourceExpressionDirective> getFetchDirective(FetchDirectiveKind kind) {
        return Optional.ofNullable(this.fetchDirectives.get((Object)kind));
    }

    public boolean allowsExternalScript(Optional<String> nonce, Optional<String> integrity, Optional<URLWithScheme> scriptUrl, Optional<Boolean> parserInserted, Optional<URLWithScheme> origin) {
        String actualNonce;
        if (this.sandbox != null && !this.sandbox.allowScripts()) {
            return false;
        }
        SourceExpressionDirective directive = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ScriptSrcElem).orElse(null);
        if (directive == null) {
            return true;
        }
        if (nonce.isPresent() && (actualNonce = nonce.get()).length() > 0 && directive.getNonces().stream().anyMatch(n -> n.base64ValuePart.equals(actualNonce))) {
            return true;
        }
        if (integrity.isPresent() && !directive.getHashes().isEmpty()) {
            String integritySources = integrity.get();
            boolean bypassDueToIntegrityMatch = true;
            boolean atLeastOneValidIntegrity = false;
            for (String source : Utils.splitOnAsciiWhitespace(integritySources)) {
                Optional<Hash> parsedIntegritySource = Hash.parseHash("'" + source + "'");
                if (!parsedIntegritySource.isPresent()) continue;
                if (!directive.getHashes().contains(parsedIntegritySource.get())) {
                    bypassDueToIntegrityMatch = false;
                    break;
                }
                atLeastOneValidIntegrity = true;
            }
            if (atLeastOneValidIntegrity && bypassDueToIntegrityMatch) {
                return true;
            }
        }
        if (directive.strictDynamic()) {
            return parserInserted.orElse(true) == false;
        }
        if (scriptUrl.isPresent()) {
            return Policy.doesUrlMatchSourceListInOrigin(scriptUrl.get(), directive, origin);
        }
        return false;
    }

    public boolean allowsInlineScript(Optional<String> nonce, Optional<String> source, Optional<Boolean> parserInserted) {
        if (this.sandbox != null && !this.sandbox.allowScripts()) {
            return false;
        }
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.Script, nonce, source, parserInserted);
    }

    public boolean allowsScriptAsAttribute(Optional<String> source) {
        if (this.sandbox != null && !this.sandbox.allowScripts()) {
            return false;
        }
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.ScriptAttribute, Optional.empty(), source, Optional.empty());
    }

    public boolean allowsEval() {
        FetchDirectiveKind governingDirective = this.fetchDirectives.containsKey((Object)FetchDirectiveKind.ScriptSrc) ? FetchDirectiveKind.ScriptSrc : FetchDirectiveKind.DefaultSrc;
        SourceExpressionDirective sourceList = this.fetchDirectives.get((Object)governingDirective);
        return sourceList == null || sourceList.unsafeEval();
    }

    public boolean allowsNavigation(Optional<URLWithScheme> to, Optional<Boolean> redirected, Optional<URLWithScheme> redirectedTo, Optional<URLWithScheme> origin) {
        if (this.navigateTo == null) {
            return true;
        }
        if (this.navigateTo.unsafeAllowRedirects()) {
            if (!redirected.orElse(false).booleanValue()) {
                if (!to.isPresent()) {
                    return false;
                }
                if (!Policy.doesUrlMatchSourceListInOrigin(to.get(), this.navigateTo, origin)) {
                    return false;
                }
            }
            if (redirected.orElse(true).booleanValue()) {
                if (!redirectedTo.isPresent()) {
                    return false;
                }
                if (!Policy.doesUrlMatchSourceListInOrigin(redirectedTo.get(), this.navigateTo, origin)) {
                    return false;
                }
            }
        } else {
            if (!to.isPresent()) {
                return false;
            }
            if (!Policy.doesUrlMatchSourceListInOrigin(to.get(), this.navigateTo, origin)) {
                return false;
            }
        }
        return true;
    }

    public boolean allowsFormAction(Optional<URLWithScheme> to, Optional<Boolean> redirected, Optional<URLWithScheme> redirectedTo, Optional<URLWithScheme> origin) {
        if (this.sandbox != null && !this.sandbox.allowForms()) {
            return false;
        }
        if (this.formAction != null) {
            if (!to.isPresent()) {
                return false;
            }
            return Policy.doesUrlMatchSourceListInOrigin(to.get(), this.formAction, origin);
        }
        return this.allowsNavigation(to, redirected, redirectedTo, origin);
    }

    public boolean allowsJavascriptUrlNavigation(Optional<String> source, Optional<URLWithScheme> origin) {
        return this.allowsNavigation(Optional.of(new GUID("javascript", source.orElse(""))), Optional.of(false), Optional.empty(), origin) && this.doesElementMatchSourceListForTypeAndSource(InlineType.Navigation, Optional.empty(), source.map(s2 -> "javascript:" + s2), Optional.of(false));
    }

    public boolean allowsExternalStyle(Optional<String> nonce, Optional<URLWithScheme> styleUrl, Optional<URLWithScheme> origin) {
        String actualNonce;
        SourceExpressionDirective directive = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.StyleSrcElem).orElse(null);
        if (directive == null) {
            return true;
        }
        if (nonce.isPresent() && (actualNonce = nonce.get()).length() > 0 && directive.getNonces().stream().anyMatch(n -> n.base64ValuePart.equals(actualNonce))) {
            return true;
        }
        if (styleUrl.isPresent()) {
            return Policy.doesUrlMatchSourceListInOrigin(styleUrl.get(), directive, origin);
        }
        return false;
    }

    public boolean allowsInlineStyle(Optional<String> nonce, Optional<String> source) {
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.Style, nonce, source, Optional.empty());
    }

    public boolean allowsStyleAsAttribute(Optional<String> source) {
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.StyleAttribute, Optional.empty(), source, Optional.empty());
    }

    public boolean allowsFrame(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.FrameSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsFrameAncestor(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        if (this.frameAncestors == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), this.frameAncestors, origin);
    }

    public boolean allowsConnection(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ConnectSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        URLWithScheme actualSource = source.get();
        String scheme = actualSource.scheme;
        URLWithScheme usedSource = actualSource;
        if (actualSource instanceof URI) {
            if (scheme.equals("ws")) {
                usedSource = new URI("http", actualSource.host, (int)actualSource.port, actualSource.path);
            } else if (scheme.equals("wss")) {
                usedSource = new URI("https", actualSource.host, (int)actualSource.port, actualSource.path);
            }
        }
        return Policy.doesUrlMatchSourceListInOrigin(usedSource, sourceList, origin);
    }

    public boolean allowsFont(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.FontSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsImage(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ImgSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsApplicationManifest(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ManifestSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsMedia(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.MediaSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsObject(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ObjectSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsPrefetch(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.PrefetchSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsWorker(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.WorkerSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsPlugin(Optional<MediaType> mediaType) {
        if (this.pluginTypes == null) {
            return true;
        }
        if (!mediaType.isPresent()) {
            return false;
        }
        return this.pluginTypes.getMediaTypes().contains(mediaType.get());
    }

    public Optional<SourceExpressionDirective> getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind kind) {
        for (FetchDirectiveKind candidate : FetchDirectiveKind.getFetchDirectiveFallbackList(kind)) {
            SourceExpressionDirective list = this.fetchDirectives.get((Object)candidate);
            if (list == null) continue;
            return Optional.of(list);
        }
        return Optional.empty();
    }

    private boolean doesElementMatchSourceListForTypeAndSource(InlineType type, Optional<String> nonce, Optional<String> source, Optional<Boolean> parserInserted) {
        String actualNonce;
        boolean allowAllInline;
        SourceExpressionDirective directive = this.getGoverningDirectiveForEffectiveDirective(type.effectiveDirective).orElse(null);
        if (directive == null) {
            return true;
        }
        boolean bl = allowAllInline = directive.getNonces().isEmpty() && directive.getHashes().isEmpty() && (type != InlineType.Script && type != InlineType.ScriptAttribute && type != InlineType.Navigation || !directive.strictDynamic()) && directive.unsafeInline();
        if (allowAllInline) {
            return true;
        }
        if (nonce.isPresent() && (actualNonce = nonce.get()).length() > 0 && directive.getNonces().stream().anyMatch(n -> n.base64ValuePart.equals(actualNonce))) {
            return true;
        }
        if (source.isPresent() && !directive.getHashes().isEmpty() && (type == InlineType.Script || type == InlineType.Style || directive.unsafeHashes())) {
            byte[] actualSource = source.get().getBytes(StandardCharsets.UTF_8);
            Base64.Encoder base64encoder = Base64.getEncoder();
            String actualSha256 = null;
            String actualSha384 = null;
            String actualSha512 = null;
            try {
                block7: for (Hash hash : directive.getHashes()) {
                    switch (hash.algorithm) {
                        case SHA256: {
                            if (actualSha256 == null) {
                                actualSha256 = base64encoder.encodeToString(MessageDigest.getInstance("SHA-256").digest(actualSource));
                            }
                            if (!actualSha256.equals(Policy.normalizeBase64Url(hash.base64ValuePart))) continue block7;
                            return true;
                        }
                        case SHA384: {
                            if (actualSha384 == null) {
                                actualSha384 = base64encoder.encodeToString(MessageDigest.getInstance("SHA-384").digest(actualSource));
                            }
                            if (!actualSha384.equals(Policy.normalizeBase64Url(hash.base64ValuePart))) continue block7;
                            return true;
                        }
                        case SHA512: {
                            if (actualSha512 == null) {
                                actualSha512 = base64encoder.encodeToString(MessageDigest.getInstance("SHA-512").digest(actualSource));
                            }
                            if (!actualSha512.equals(Policy.normalizeBase64Url(hash.base64ValuePart))) continue block7;
                            return true;
                        }
                    }
                    throw new IllegalArgumentException("Unknown hash algorithm " + (Object)((Object)hash.algorithm));
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return type == InlineType.Script && directive.strictDynamic() && parserInserted.orElse(true) == false;
    }

    private static String normalizeBase64Url(String input) {
        return input.replace('-', '+').replace('_', '/');
    }

    public static boolean doesUrlMatchSourceListInOrigin(URLWithScheme url, HostSourceDirective list, Optional<URLWithScheme> origin) {
        String urlScheme = url.scheme;
        if (list.star()) {
            if (Objects.equals(urlScheme, "ftp") || Objects.equals(urlScheme, "http") || Objects.equals(urlScheme, "https")) {
                return true;
            }
            if (origin.isPresent() && Objects.equals(urlScheme, origin.get().scheme)) {
                return true;
            }
        }
        for (Scheme scheme : list.getSchemes()) {
            if (!Policy.schemePartMatches(scheme.value, urlScheme)) continue;
            return true;
        }
        for (Host expression : list.getHosts()) {
            String scheme = expression.scheme;
            if (scheme == null ? !origin.isPresent() || !Policy.schemePartMatches(origin.get().scheme, urlScheme) : !Policy.schemePartMatches(scheme, urlScheme)) continue;
            if (url.host == null || !Policy.hostPartMatches(expression.host, url.host) || !Policy.portPartMatches(expression.port, url.port, urlScheme) || !Policy.pathPartMatches(expression.path, url.path)) continue;
            return true;
        }
        if (list.self() && origin.isPresent()) {
            URLWithScheme actualOrigin = origin.get();
            String originScheme = actualOrigin.scheme;
            if (Objects.equals(actualOrigin.host, url.host) && (Objects.equals(actualOrigin.port, url.port) || Objects.equals(actualOrigin.port, URI.defaultPortForProtocol(originScheme)) && Objects.equals(url.port, URI.defaultPortForProtocol(urlScheme))) && (urlScheme.equals("https") || urlScheme.equals("wss") || originScheme.equals("http") && (urlScheme.equals("http") || urlScheme.equals("ws")))) {
                return true;
            }
        }
        return false;
    }

    private static boolean schemePartMatches(String A2, String B) {
        return A2.equals(B) || A2.equals("http") && B.equals("https") || A2.equals("ws") && (B.equals("wss") || B.equals("http") || B.equals("https")) || A2.equals("wss") && B.equals("https");
    }

    private static boolean hostPartMatches(String A2, String B) {
        if (A2.startsWith("*")) {
            String remaining = A2.substring(1);
            return B.toLowerCase(Locale.ENGLISH).endsWith(remaining.toLowerCase(Locale.ENGLISH));
        }
        if (!A2.equalsIgnoreCase(B)) {
            return false;
        }
        Matcher IPv4Matcher = Constants.IPv4address.matcher(A2);
        Matcher IPv6Matcher = Constants.IPv6addressWithOptionalBracket.matcher(A2);
        Matcher IPv6LoopbackMatcher = Constants.IPV6loopback.matcher(A2);
        return (!IPv4Matcher.find() || A2.equals("127.0.0.1")) && !IPv6Matcher.find() && !IPv6LoopbackMatcher.find();
    }

    private static boolean portPartMatches(int A2, int portB, String schemeB) {
        if (A2 == -1) {
            return portB == URI.defaultPortForProtocol(schemeB);
        }
        if (A2 == -200) {
            return true;
        }
        if (A2 == portB) {
            return true;
        }
        if (portB == -1) {
            return A2 == URI.defaultPortForProtocol(schemeB);
        }
        return false;
    }

    private static boolean pathPartMatches(String pathA, String pathB) {
        if (pathA == null) {
            pathA = "";
        }
        if (pathB == null) {
            pathB = "";
        }
        if (pathA.isEmpty()) {
            return true;
        }
        if (pathA.equals("/") && pathB.isEmpty()) {
            return true;
        }
        boolean exactMatch = !pathA.endsWith("/");
        List<String> pathListA = Utils.strictlySplit(pathA, '/');
        List<String> pathListB = Utils.strictlySplit(pathB, '/');
        if (pathListA.size() > pathListB.size()) {
            return false;
        }
        if (exactMatch && pathListA.size() != pathListB.size()) {
            return false;
        }
        if (!exactMatch) {
            pathListA.remove(pathListA.size() - 1);
        }
        Iterator<String> it1 = pathListA.iterator();
        Iterator<String> it2 = pathListB.iterator();
        while (it1.hasNext()) {
            String b;
            String a = Utils.decodeString(it1.next());
            if (a.equals(b = Utils.decodeString(it2.next()))) continue;
            return false;
        }
        return true;
    }

    static void enforceAscii(String s2) {
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(s2)) {
            throw new IllegalArgumentException("string is not ascii: \"" + s2 + "\"");
        }
    }

    private static String stripLeadingWhitespace(String string) {
        return string.replaceFirst("^[" + Constants.WHITESPACE_CHARS + "]+", "");
    }

    private static String stripTrailingWhitespace(String string) {
        return string.replaceAll("[" + Constants.WHITESPACE_CHARS + "]+$", "");
    }

    @Nonnull
    private static String collect(String input, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(input);
        if (!matcher.find() || matcher.start() != 0) {
            return "";
        }
        return input.substring(0, matcher.end());
    }

    @FunctionalInterface
    public static interface PolicyListErrorConsumer {
        public static final PolicyListErrorConsumer ignored = (severity, message, policyIndex, directiveIndex, valueIndex) -> {};

        public void add(Severity var1, String var2, int var3, int var4, int var5);
    }

    @FunctionalInterface
    public static interface PolicyErrorConsumer {
        public static final PolicyErrorConsumer ignored = (severity, message, directiveIndex, valueIndex) -> {};

        public void add(Severity var1, String var2, int var3, int var4);
    }

    public static enum Severity {
        Info,
        Warning,
        Error;

    }

    private static class NamedDirective {
        final String name;
        final Directive directive;
        final String lowcaseName;

        private NamedDirective(String name, Directive directive) {
            this.name = name;
            this.directive = directive;
            this.lowcaseName = this.name.toLowerCase(Locale.ENGLISH);
        }
    }

    private static enum InlineType {
        Script(FetchDirectiveKind.ScriptSrcElem),
        ScriptAttribute(FetchDirectiveKind.ScriptSrcAttr),
        Style(FetchDirectiveKind.StyleSrcElem),
        StyleAttribute(FetchDirectiveKind.StyleSrcAttr),
        Navigation(FetchDirectiveKind.ScriptSrcElem);

        final FetchDirectiveKind effectiveDirective;

        private InlineType(FetchDirectiveKind effectiveDirective) {
            this.effectiveDirective = effectiveDirective;
        }
    }
}

