/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Directives;

import com.shapesecurity.salvation2.Directive;
import com.shapesecurity.salvation2.Directives.HostSourceDirective;
import com.shapesecurity.salvation2.Policy;
import com.shapesecurity.salvation2.Values.Hash;
import com.shapesecurity.salvation2.Values.Nonce;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class SourceExpressionDirective
extends HostSourceDirective {
    private boolean unsafeInline = false;
    private boolean unsafeEval = false;
    private boolean strictDynamic = false;
    private boolean unsafeHashes = false;
    private boolean reportSample = false;
    private boolean unsafeAllowRedirects = false;
    private List<Nonce> nonces = new ArrayList<Nonce>();
    private List<Hash> hashes = new ArrayList<Hash>();

    public SourceExpressionDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String token : values) {
            String lowcaseToken;
            switch (lowcaseToken = token.toLowerCase(Locale.ENGLISH)) {
                case "'unsafe-inline'": {
                    if (!this.unsafeInline) {
                        this.unsafeInline = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-inline'", index);
                    break;
                }
                case "'unsafe-eval'": {
                    if (!this.unsafeEval) {
                        this.unsafeEval = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-eval'", index);
                    break;
                }
                case "'strict-dynamic'": {
                    if (!this.strictDynamic) {
                        this.strictDynamic = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate source-expression 'strict-dynamic'", index);
                    break;
                }
                case "'unsafe-hashes'": {
                    if (!this.unsafeHashes) {
                        this.unsafeHashes = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-hashes'", index);
                    break;
                }
                case "'report-sample'": {
                    if (!this.reportSample) {
                        this.reportSample = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate source-expression 'report-sample'", index);
                    break;
                }
                case "'unsafe-allow-redirects'": {
                    if (!this.unsafeAllowRedirects) {
                        this.unsafeAllowRedirects = true;
                        break;
                    }
                    errors.add(Policy.Severity.Warning, "Duplicate source-expression 'unsafe-allow-redirects'", index);
                    break;
                }
                case "'unsafe-redirect'": {
                    errors.add(Policy.Severity.Error, "'unsafe-redirect' has been removed from CSP as of version 2.0", index);
                    break;
                }
                case "'unsafe-hashed-attributes'": {
                    errors.add(Policy.Severity.Error, "'unsafe-hashed-attributes' was renamed to 'unsafe-hashes' in June 2018", index);
                    break;
                }
                default: {
                    if (lowcaseToken.startsWith("'nonce-")) {
                        Optional<Nonce> nonce = Nonce.parseNonce(token);
                        if (nonce.isPresent()) {
                            this._addNonce(nonce.get(), index, errors);
                            break;
                        }
                        errors.add(Policy.Severity.Error, "Unrecognised nonce " + token, index);
                        break;
                    }
                    if (lowcaseToken.startsWith("'sha")) {
                        Optional<Hash> hash = Hash.parseHash(token);
                        if (hash.isPresent()) {
                            this._addHash(hash.get(), index, errors);
                            break;
                        }
                        errors.add(Policy.Severity.Error, "'sha...' source-expression uses an unrecognized algorithm or does not match the base64-value grammar (or is missing its trailing \"'\")", index);
                        break;
                    }
                    this._addHostOrSchemeDuringConstruction(token, lowcaseToken, "source-expression", index, errors);
                }
            }
            ++index;
        }
        if (this.none != null && values.size() > 1) {
            errors.add(Policy.Severity.Error, "'none' must not be combined with any other source-expression", 1);
        }
        if (values.isEmpty()) {
            errors.add(Policy.Severity.Error, "Source-expression lists cannot be empty (use 'none' instead)", -1);
        }
    }

    private boolean _addNonce(Nonce nonce, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.nonces.contains(nonce)) {
            errors.add(Policy.Severity.Warning, "Duplicate nonce " + nonce.toString(), index);
            return false;
        }
        this.nonces.add(nonce);
        return true;
    }

    private boolean _addHash(Hash hash, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.hashes.contains(hash)) {
            errors.add(Policy.Severity.Warning, "Duplicate hash " + hash.toString(), index);
            return false;
        }
        if (hash.base64ValuePart.length() != hash.algorithm.length) {
            errors.add(Policy.Severity.Warning, "Wrong length for " + hash.algorithm.toString() + ": expected " + hash.algorithm.length + ", got " + hash.base64ValuePart.length(), index);
        }
        if (hash.base64ValuePart.contains("_") || hash.base64ValuePart.contains("-")) {
            errors.add(Policy.Severity.Warning, "'_' and '-' in hashes can never match actual elements", index);
        }
        this.hashes.add(hash);
        return true;
    }

    public boolean unsafeInline() {
        return this.unsafeInline;
    }

    public void setUnsafeInline(boolean unsafeInline) {
        if (this.unsafeInline == unsafeInline) {
            return;
        }
        if (unsafeInline) {
            this.addValue("'unsafe-inline'");
        } else {
            this.removeValueIgnoreCase("'unsafe-inline'");
        }
        this.unsafeInline = unsafeInline;
    }

    public boolean unsafeEval() {
        return this.unsafeEval;
    }

    public void setUnsafeEval(boolean unsafeEval) {
        if (this.unsafeEval == unsafeEval) {
            return;
        }
        if (unsafeEval) {
            this.addValue("'unsafe-eval'");
        } else {
            this.removeValueIgnoreCase("'unsafe-eval'");
        }
        this.unsafeEval = unsafeEval;
    }

    public boolean strictDynamic() {
        return this.strictDynamic;
    }

    public void setStrictDynamic(boolean strictDynamic) {
        if (this.strictDynamic == strictDynamic) {
            return;
        }
        if (strictDynamic) {
            this.addValue("'strict-dynamic'");
        } else {
            this.removeValueIgnoreCase("'strict-dynamic'");
        }
        this.strictDynamic = strictDynamic;
    }

    public boolean unsafeHashes() {
        return this.unsafeHashes;
    }

    public void setUnsafeHashes(boolean unsafeHashes) {
        if (this.unsafeHashes == unsafeHashes) {
            return;
        }
        if (unsafeHashes) {
            this.addValue("'unsafe-hashes'");
        } else {
            this.removeValueIgnoreCase("'unsafe-hashes'");
        }
        this.unsafeHashes = unsafeHashes;
    }

    public boolean reportSample() {
        return this.reportSample;
    }

    public void setReportSample(boolean reportSample) {
        if (this.reportSample == reportSample) {
            return;
        }
        if (reportSample) {
            this.addValue("'report-sample'");
        } else {
            this.removeValueIgnoreCase("'report-sample'");
        }
        this.reportSample = reportSample;
    }

    public boolean unsafeAllowRedirects() {
        return this.unsafeAllowRedirects;
    }

    public void setUnsafeAllowRedirects(boolean unsafeAllowRedirects) {
        if (this.unsafeAllowRedirects == unsafeAllowRedirects) {
            return;
        }
        if (unsafeAllowRedirects) {
            this.addValue("'unsafe-allow-redirects'");
        } else {
            this.removeValueIgnoreCase("'unsafe-allow-redirects'");
        }
        this.unsafeAllowRedirects = unsafeAllowRedirects;
    }

    public List<Nonce> getNonces() {
        return Collections.unmodifiableList(this.nonces);
    }

    public void addNonce(Nonce nonce, Directive.ManipulationErrorConsumer errors) {
        if (this._addNonce(nonce, -1, SourceExpressionDirective.wrapManipulationErrorConsumer(errors))) {
            this.addValue(nonce.toString());
        }
    }

    public boolean removeNonce(Nonce nonce) {
        if (!this.nonces.contains(nonce)) {
            return false;
        }
        this.nonces.remove(nonce);
        this.removeValuesMatching(nonce, Nonce::parseNonce);
        return true;
    }

    public List<Hash> getHashes() {
        return Collections.unmodifiableList(this.hashes);
    }

    public void addHash(Hash hash, Directive.ManipulationErrorConsumer errors) {
        if (this._addHash(hash, -1, SourceExpressionDirective.wrapManipulationErrorConsumer(errors))) {
            this.addValue(hash.toString());
        }
    }

    public boolean removeHash(Hash hash) {
        if (!this.hashes.contains(hash)) {
            return false;
        }
        this.hashes.remove(hash);
        this.removeValuesMatching(hash, Hash::parseHash);
        return true;
    }
}

