/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.crypto;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.crypto.SubtleCrypto;
import java.security.SecureRandom;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeTypedArrayView;

@JsxClass
public class Crypto
extends SimpleScriptable {
    static final SecureRandom RANDOM = new SecureRandom();

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Crypto() {
    }

    public Crypto(Window window) {
        this.setParentScope(window);
        this.setPrototype(window.getPrototype(Crypto.class));
    }

    @JsxFunction
    public NativeTypedArrayView<?> getRandomValues(NativeTypedArrayView<?> array) {
        if (array == null) {
            throw ScriptRuntime.typeError("Argument 1 of Crypto.getRandomValues is not an object.");
        }
        if (array.getByteLength() > 65536) {
            throw Context.reportRuntimeError("Error: Failed to execute 'getRandomValues' on 'Crypto': The ArrayBufferView's byte length (" + array.getByteLength() + ") exceeds the number of bytes of entropy available via this API (65536).");
        }
        for (int i = 0; i < array.getByteLength() / array.getBytesPerElement(); ++i) {
            array.put(i, array, (Object)RANDOM.nextInt());
        }
        return array;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public SubtleCrypto getSubtle() {
        SubtleCrypto stuble = new SubtleCrypto();
        Window window = this.getWindow();
        stuble.setParentScope(window);
        stuble.setPrototype(window.getPrototype(SubtleCrypto.class));
        return stuble;
    }
}

