/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.FunctionWrapper;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

public class NativeFunctionToStringFunction
extends FunctionWrapper {
    public static void installFix(Scriptable window, BrowserVersion browserVersion) {
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_NEW_LINE)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(window, "Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, "toString");
            NativeFunctionToStringFunction newToString = new NativeFunctionToStringFunction(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, "toString", (Object)newToString);
        } else if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_COMPACT)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(window, "Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, "toString");
            NativeFunctionToStringFunctionChrome newToString = new NativeFunctionToStringFunctionChrome(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, "toString", (Object)newToString);
        } else if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_NL)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype(window, "Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, "toString");
            NativeFunctionToStringFunctionFF newToString = new NativeFunctionToStringFunctionFF(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, "toString", (Object)newToString);
        }
    }

    NativeFunctionToStringFunction(Function wrapped) {
        super(wrapped);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String s2 = (String)super.call(cx, scope, thisObj, args);
        if (thisObj instanceof BaseFunction && s2.contains("[native code]")) {
            String functionName = ((BaseFunction)thisObj).getFunctionName();
            return "\nfunction " + functionName + "() {\n    [native code]\n}\n";
        }
        return s2;
    }

    static class NativeFunctionToStringFunctionFF
    extends FunctionWrapper {
        NativeFunctionToStringFunctionFF(Function wrapped) {
            super(wrapped);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            String s2 = (String)super.call(cx, scope, thisObj, args);
            return s2.replace("function anonymous() {", "function anonymous(\n) {");
        }
    }

    static class NativeFunctionToStringFunctionChrome
    extends FunctionWrapper {
        NativeFunctionToStringFunctionChrome(Function wrapped) {
            super(wrapped);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            String s2 = (String)super.call(cx, scope, thisObj, args);
            if (thisObj instanceof BaseFunction && s2.contains("[native code]")) {
                String functionName = ((BaseFunction)thisObj).getFunctionName();
                return "function " + functionName + "() { [native code] }";
            }
            return s2.replace("function anonymous() {", "function anonymous(\n) {");
        }
    }
}

