/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class HtmlSubmitInput
extends HtmlInput
implements LabelableElement {
    public static final String DEFAULT_VALUE = "Submit Query";

    HtmlSubmitInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, HtmlSubmitInput.addValueIfNeeded(page, attributes));
    }

    private static Map<String, DomAttr> addValueIfNeeded(SgmlPage page, Map<String, DomAttr> attributes) {
        BrowserVersion browserVersion = page.getWebClient().getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.SUBMITINPUT_DEFAULT_VALUE_IF_VALUE_NOT_DEFINED)) {
            for (String key : attributes.keySet()) {
                if (!"value".equalsIgnoreCase(key)) continue;
                return attributes;
            }
            DomAttr newAttr = new DomAttr(page, null, "value", DEFAULT_VALUE, true);
            attributes.put("value", newAttr);
        }
        return attributes;
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void reset() {
    }

    @Override
    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (DomAttr attribute : this.getAttributesMap().values()) {
            String name = attribute.getNodeName();
            String value = attribute.getValue();
            if ("value".equals(name) && DEFAULT_VALUE.equals(value)) continue;
            printWriter.print(" ");
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringUtils.escapeXmlAttributeValue(value));
            printWriter.print("\"");
        }
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        if (!this.getNameAttribute().isEmpty() && !this.hasAttribute("value")) {
            return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), DEFAULT_VALUE)};
        }
        return super.getSubmitNameValuePairs();
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("value".equals(qualifiedName)) {
            this.setDefaultValue(attributeValue, false);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return true;
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }
}

