/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.regexp.RegExpJsToJavaConverter;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HtmlInput
extends HtmlElement
implements DisabledElement,
SubmittableElement,
FormFieldWithNameHistory {
    private static final Log LOG = LogFactory.getLog(HtmlInput.class);
    public static final String TAG_NAME = "input";
    private String defaultValue_;
    private final String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private boolean createdByJavascript_;
    private boolean valueModifiedByJavascript_;
    private Object valueAtFocus_;

    public HtmlInput(SgmlPage page, Map<String, DomAttr> attributes) {
        this(TAG_NAME, page, attributes);
    }

    public HtmlInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.defaultValue_ = this.getValueAttribute();
        this.originalName_ = this.getNameAttribute();
    }

    @Override
    public void setAttribute(String attributeName, String attributeValue) {
        if ("value".equals(attributeName)) {
            this.setValueAttribute(attributeValue);
        } else {
            super.setAttribute(attributeName, attributeValue);
        }
    }

    public void setValueAttribute(String newValue) {
        WebAssert.notNull("newValue", newValue);
        super.setAttribute("value", newValue);
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public final String getTypeAttribute() {
        String type = this.getAttributeDirect("type");
        if (ATTRIBUTE_NOT_DEFINED == type) {
            return "text";
        }
        return type;
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeDirect("value");
    }

    public final String getCheckedAttribute() {
        return this.getAttributeDirect("checked");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeDirect("readonly");
    }

    public final String getSizeAttribute() {
        return this.getAttributeDirect("size");
    }

    public final String getMaxLengthAttribute() {
        return this.getAttribute("maxLength");
    }

    protected int getMaxLength() {
        String maxLength = this.getMaxLengthAttribute();
        if (maxLength.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(maxLength.trim());
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public final String getMinLengthAttribute() {
        return this.getAttribute("minLength");
    }

    protected int getMinLength() {
        String minLength = this.getMinLengthAttribute();
        if (minLength.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(minLength.trim());
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }

    public String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public String getSrc() {
        String src = this.getSrcAttributeNormalized();
        if (ATTRIBUTE_NOT_DEFINED == src) {
            return src;
        }
        HtmlPage page = this.getHtmlPageOrNull();
        if (page != null) {
            try {
                return page.getFullyQualifiedUrl(src).toExternalForm();
            }
            catch (MalformedURLException e) {
                LOG.warn(e.getMessage(), e);
            }
        }
        return src;
    }

    public void setSrcAttribute(String src) {
        this.setAttribute("src", src);
    }

    public final String getAltAttribute() {
        return this.getAttributeDirect("alt");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeDirect("usemap");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeDirect("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeDirect("onchange");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    @Override
    public void reset() {
        this.setValueAttribute(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue, true);
    }

    protected void setDefaultValue(String defaultValue, boolean modifyValue) {
        String oldAttributeValue = this.defaultValue_;
        HtmlAttributeChangeEvent event = ATTRIBUTE_NOT_DEFINED == this.defaultValue_ ? new HtmlAttributeChangeEvent(this, "value", defaultValue) : new HtmlAttributeChangeEvent(this, "value", oldAttributeValue);
        this.defaultValue_ = defaultValue;
        if (modifyValue) {
            if (this instanceof HtmlFileInput) {
                super.setAttribute("value", defaultValue);
            } else {
                this.setValueAttribute(defaultValue);
            }
        }
        HtmlInput.notifyAttributeChangeListeners(event, this, oldAttributeValue, true);
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue_;
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public Page setChecked(boolean isChecked) {
        return this.getPage();
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setAttribute("readOnly", "readOnly");
        } else {
            this.removeAttribute("readOnly");
        }
    }

    public boolean isChecked() {
        return this.hasAttribute("checked");
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_DOES_NOT_CLICK_SURROUNDING_ANCHOR);
    }

    @Override
    public boolean handles(Event event) {
        if (event instanceof MouseEvent && this.hasFeature(BrowserVersionFeatures.EVENT_MOUSE_ON_DISABLED)) {
            return true;
        }
        return super.handles(event);
    }

    static Page executeOnChangeHandlerIfAppropriate(HtmlElement htmlElement) {
        SgmlPage page = htmlElement.getPage();
        WebClient webClient = page.getWebClient();
        if (!webClient.isJavaScriptEngineEnabled()) {
            return page;
        }
        AbstractJavaScriptEngine<?> engine = webClient.getJavaScriptEngine();
        if (engine.isScriptRunning()) {
            return page;
        }
        ScriptResult scriptResult = htmlElement.fireEvent("change");
        if (webClient.containsWebWindow(page.getEnclosingWindow())) {
            return page.getEnclosingWindow().getEnclosedPage();
        }
        if (scriptResult != null) {
            return webClient.getCurrentWindow().getEnclosedPage();
        }
        return page;
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("name".equals(qualifiedName)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    public void valueModifiedByJavascript() {
        this.valueModifiedByJavascript_ = true;
    }

    @Override
    public final void focus() {
        super.focus();
        this.valueAtFocus_ = this.getInternalValue();
    }

    @Override
    public final void removeFocus() {
        super.removeFocus();
        if (this.valueAtFocus_ != null && !this.valueAtFocus_.equals(this.getInternalValue())) {
            this.handleFocusLostValueChanged();
        }
        this.valueAtFocus_ = null;
    }

    void handleFocusLostValueChanged() {
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    Object getInternalValue() {
        return this.getValueAttribute();
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }

    public String getSize() {
        return this.getAttributeDirect("size");
    }

    public void setSize(String size) {
        this.setAttribute("size", size);
    }

    public void setMaxLength(int maxLength) {
        this.setAttribute("maxLength", String.valueOf(maxLength));
    }

    public void setMinLength(int minLength) {
        this.setAttribute("minLength", String.valueOf(minLength));
    }

    public String getAccept() {
        return this.getAttribute("accept");
    }

    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    public String getAutocomplete() {
        return this.getAttributeDirect("autocomplete");
    }

    public void setAutocomplete(String autocomplete) {
        this.setAttribute("autocomplete", autocomplete);
    }

    public String getPlaceholder() {
        return this.getAttributeDirect("placeholder");
    }

    public void setPlaceholder(String placeholder) {
        this.setAttribute("placeholder", placeholder);
    }

    public String getPattern() {
        return this.getAttributeDirect("pattern");
    }

    public void setPattern(String pattern) {
        this.setAttribute("pattern", pattern);
    }

    public String getMin() {
        return this.getAttributeDirect("min");
    }

    public void setMin(String min2) {
        this.setAttribute("min", min2);
    }

    public String getMax() {
        return this.getAttributeDirect("max");
    }

    public void setMax(String max) {
        this.setAttribute("max", max);
    }

    public String getStep() {
        return this.getAttributeDirect("step");
    }

    public void setStep(String step) {
        this.setAttribute("step", step);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxLengthValid() && this.isMinLengthValid() && this.isPatternValid();
    }

    @Override
    protected boolean isRequiredSupported() {
        return true;
    }

    protected boolean isPatternSupported() {
        return false;
    }

    protected boolean isBlankPatternValidated() {
        return true;
    }

    protected boolean isMinMaxLengthSupported() {
        return false;
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlInput newnode = (HtmlInput)super.cloneNode(deep);
        newnode.newNames_ = new HashSet<String>(this.newNames_);
        return newnode;
    }

    private boolean isMaxLengthValid() {
        if (!this.isMinMaxLengthSupported() || this.valueModifiedByJavascript_ || !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_ATTRIBUTE_MIN_MAX_LENGTH_SUPPORTED) || this.getMaxLength() == Integer.MAX_VALUE) {
            return true;
        }
        return this.getValueAttribute().length() <= this.getMaxLength();
    }

    private boolean isMinLengthValid() {
        if (!this.isMinMaxLengthSupported() || this.valueModifiedByJavascript_ || !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_ATTRIBUTE_MIN_MAX_LENGTH_SUPPORTED) || this.getMinLength() == Integer.MIN_VALUE) {
            return true;
        }
        return this.getValueAttribute().length() >= this.getMinLength();
    }

    private boolean isPatternValid() {
        if (!this.isPatternSupported()) {
            return true;
        }
        String pattern = this.getPattern();
        if (StringUtils.isEmpty(pattern)) {
            return true;
        }
        String value = this.getValueAttribute();
        if (StringUtils.isEmpty(value)) {
            return true;
        }
        if (!this.isBlankPatternValidated() && StringUtils.isBlank(value)) {
            return true;
        }
        RegExpJsToJavaConverter converter = new RegExpJsToJavaConverter();
        String javaPattern = converter.convert(pattern);
        try {
            return Pattern.matches(javaPattern, value);
        }
        catch (Exception exception) {
            return true;
        }
    }
}

