/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlAnchor
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlAnchor.class);
    public static final String TAG_NAME = "a";

    HtmlAnchor(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public <P extends Page> P click(Event event, boolean shiftKey, boolean ctrlKey, boolean altKey, boolean ignoreVisibility) throws IOException {
        WebWindow oldWebWindow = null;
        if (ctrlKey) {
            oldWebWindow = ((HTMLElement)event.getSrcElement()).getDomNodeOrDie().getPage().getWebClient().getCurrentWindow();
        }
        Object page = super.click(event, shiftKey, ctrlKey, altKey, ignoreVisibility);
        if (ctrlKey) {
            page.getEnclosingWindow().getWebClient().setCurrentWindow(oldWebWindow);
            page = oldWebWindow.getEnclosedPage();
        }
        return page;
    }

    protected void doClickStateUpdate(boolean shiftKey, boolean ctrlKey, String hrefSuffix) throws IOException {
        String href = (this.getHrefAttribute() + hrefSuffix).trim();
        if (LOG.isDebugEnabled()) {
            String w = this.getPage().getEnclosingWindow().getName();
            LOG.debug("do click action in window '" + w + "', using href '" + href + "'");
        }
        if (ATTRIBUTE_NOT_DEFINED == this.getHrefAttribute()) {
            return;
        }
        HtmlPage page = (HtmlPage)this.getPage();
        if (StringUtils.startsWithIgnoreCase(href, "javascript:")) {
            StringBuilder builder = new StringBuilder(href.length());
            builder.append("javascript:");
            for (int i = "javascript:".length(); i < href.length(); ++i) {
                char ch = href.charAt(i);
                if (ch == '%' && i + 2 < href.length()) {
                    char ch1 = Character.toUpperCase(href.charAt(i + 1));
                    char ch2 = Character.toUpperCase(href.charAt(i + 2));
                    if ((Character.isDigit(ch1) || ch1 >= 'A' && ch1 <= 'F') && (Character.isDigit(ch2) || ch2 >= 'A' && ch2 <= 'F')) {
                        builder.append((char)Integer.parseInt(href.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue;
                    }
                }
                builder.append(ch);
            }
            String target = shiftKey || ctrlKey || ATTRIBUTE_NOT_DEFINED != this.getDownloadAttribute() ? "_blank" : page.getResolvedTarget(this.getTargetAttribute());
            WebWindow win = page.getWebClient().openTargetWindow(page.getEnclosingWindow(), target, "_self");
            Page enclosedPage = win.getEnclosedPage();
            if (enclosedPage == null) {
                win.getWebClient().getPage(win, WebRequest.newAboutBlankRequest());
                enclosedPage = win.getEnclosedPage();
            }
            if (enclosedPage != null && enclosedPage.isHtmlPage()) {
                page = (HtmlPage)enclosedPage;
                page.executeJavaScript(builder.toString(), "javascript url", this.getStartLineNumber());
            }
            return;
        }
        URL url = HtmlAnchor.getTargetUrl(href, page);
        WebClient webClient = page.getWebClient();
        BrowserVersion browser = webClient.getBrowserVersion();
        if (ATTRIBUTE_NOT_DEFINED != this.getPingAttribute() && browser.hasFeature(BrowserVersionFeatures.ANCHOR_SEND_PING_REQUEST)) {
            URL pingUrl = HtmlAnchor.getTargetUrl(this.getPingAttribute(), page);
            WebRequest pingRequest = new WebRequest(pingUrl, HttpMethod.POST);
            pingRequest.setAdditionalHeader("Ping-From", page.getUrl().toExternalForm());
            pingRequest.setAdditionalHeader("Ping-To", url.toExternalForm());
            pingRequest.setRequestBody("PING");
            webClient.loadWebResponse(pingRequest);
        }
        WebRequest webRequest = new WebRequest(url, browser.getHtmlAcceptHeader(), browser.getAcceptEncodingHeader());
        webRequest.setCharset(page.getCharset());
        webRequest.setRefererlHeader(page.getUrl());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting page for " + url.toExternalForm() + ", derived from href '" + href + "', using the originating URL " + page.getUrl());
        }
        String target = shiftKey || ctrlKey || webClient.getAttachmentHandler() == null && ATTRIBUTE_NOT_DEFINED != this.getDownloadAttribute() ? "_blank" : page.getResolvedTarget(this.getTargetAttribute());
        page.getWebClient().download(page.getEnclosingWindow(), target, webRequest, true, false, ATTRIBUTE_NOT_DEFINED != this.getDownloadAttribute(), "Link click");
    }

    public static URL getTargetUrl(String href, HtmlPage page) throws MalformedURLException {
        URL url = page.getFullyQualifiedUrl(href);
        if (StringUtils.isEmpty(href)) {
            boolean dropFilename = page.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.ANCHOR_EMPTY_HREF_NO_FILENAME);
            if (dropFilename) {
                String path = url.getPath();
                path = path.substring(0, path.lastIndexOf(47) + 1);
                url = UrlUtils.getUrlWithNewPath(url, path);
            }
            url = UrlUtils.getUrlWithNewRef(url, null);
        }
        return url;
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        this.doClickStateUpdate(shiftKey, ctrlKey, "");
        return false;
    }

    public final String getCharsetAttribute() {
        return this.getAttributeDirect("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttributeDirect("type");
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getHrefAttribute() {
        return this.getAttributeDirect("href").trim();
    }

    public final String getHrefLangAttribute() {
        return this.getAttributeDirect("hreflang");
    }

    public final String getRelAttribute() {
        return this.getAttributeDirect("rel");
    }

    public final String getRevAttribute() {
        return this.getAttributeDirect("rev");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getShapeAttribute() {
        return this.getAttributeDirect("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttributeDirect("coords");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttributeDirect("target");
    }

    public final Page openLinkInNewWindow() throws MalformedURLException {
        URL target = ((HtmlPage)this.getPage()).getFullyQualifiedUrl(this.getHrefAttribute());
        String windowName = "HtmlAnchor.openLinkInNewWindow() target";
        WebWindow newWindow = this.getPage().getWebClient().openWindow(target, "HtmlAnchor.openLinkInNewWindow() target");
        return newWindow.getEnclosedPage();
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return true;
        }
        return super.handles(event);
    }

    public final String getPingAttribute() {
        return this.getAttributeDirect("ping");
    }

    public final String getDownloadAttribute() {
        return this.getAttributeDirect("download");
    }
}

